/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.buffer.index;

import java.io.File;
import java.util.BitSet;
import java.util.Set;
import java.util.stream.IntStream;
import org.teamapps.universaldb.index.buffer.common.PrimitiveEntryAtomicStore;

public class FloatAtomicMappedIndex {
    private final PrimitiveEntryAtomicStore atomicStore;

    public FloatAtomicMappedIndex(File path, String name) {
        this.atomicStore = new PrimitiveEntryAtomicStore(path, name);
    }

    public float getValue(int id) {
        return this.atomicStore.getFloat(id);
    }

    public void setValue(int id, float value) {
        this.atomicStore.setFloat(id, value);
    }

    public boolean isEmpty(int id) {
        return this.getValue(id) != 0.0f;
    }

    public int getMaximumId() {
        return this.atomicStore.getMaximumId(4);
    }

    public int getLastNonEmptyIndex() {
        int maximumId;
        for (int i = maximumId = this.getMaximumId(); i > 0; --i) {
            if (this.isEmpty(i)) continue;
            return i;
        }
        return -1;
    }

    public IntStream getIndexStream() {
        return IntStream.range(1, this.getMaximumId() + 1);
    }

    public BitSet filterEquals(float value, BitSet bitSet) {
        return this.filterEquals(value, bitSet.stream());
    }

    public BitSet filterEquals(float value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getFloat(id) == value).forEach(result::set);
        return result;
    }

    public BitSet filterNotEquals(float value, BitSet bitSet) {
        return this.filterNotEquals(value, bitSet.stream());
    }

    public BitSet filterNotEquals(float value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getFloat(id) != value).forEach(result::set);
        return result;
    }

    public BitSet filterGreater(float value, BitSet bitSet) {
        return this.filterGreater(value, bitSet.stream());
    }

    public BitSet filterGreater(float value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getFloat(id) > value).forEach(result::set);
        return result;
    }

    public BitSet filterSmaller(float value, BitSet bitSet) {
        return this.filterSmaller(value, bitSet.stream());
    }

    public BitSet filterSmaller(float value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getFloat(id) < value).forEach(result::set);
        return result;
    }

    public BitSet filterBetween(float startValue, float endValue, BitSet bitSet) {
        return this.filterBetween(startValue, endValue, bitSet.stream());
    }

    public BitSet filterBetween(float startValue, float endValue, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> {
            float v = this.atomicStore.getFloat(id);
            return v > startValue && v < endValue;
        }).forEach(result::set);
        return result;
    }

    public BitSet filterContains(Set<Float> valueSet, BitSet bitSet) {
        return this.filterContains(valueSet, bitSet.stream());
    }

    public BitSet filterContains(Set<Float> valueSet, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> valueSet.contains(Float.valueOf(this.atomicStore.getFloat(id)))).forEach(result::set);
        return result;
    }

    public BitSet filterContainsNot(Set<Float> valueSet, BitSet bitSet) {
        return this.filterContainsNot(valueSet, bitSet.stream());
    }

    public BitSet filterContainsNot(Set<Float> valueSet, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> !valueSet.contains(Float.valueOf(this.atomicStore.getFloat(id)))).forEach(result::set);
        return result;
    }

    public void flush() {
        this.atomicStore.flush();
    }

    public void close() {
        this.atomicStore.close();
    }

    public void drop() {
        this.atomicStore.drop();
    }
}

