/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.buffer.index;

import java.io.File;
import java.util.BitSet;
import java.util.Set;
import java.util.stream.IntStream;
import org.teamapps.universaldb.index.buffer.common.BlockEntryAtomicStore;

public class StringAtomicMappedIndex {
    private BlockEntryAtomicStore atomicStore;

    public StringAtomicMappedIndex(File path, String name) {
        this.atomicStore = new BlockEntryAtomicStore(path, name);
    }

    public String getValue(int id) {
        return this.atomicStore.getText(id);
    }

    public void setValue(int id, String value) {
        this.atomicStore.setText(id, value);
    }

    public void removeValue(int id) {
        this.atomicStore.removeText(id);
    }

    public boolean isEmpty(int id) {
        return this.atomicStore.isEmpty(id);
    }

    public int getMaximumId() {
        return this.atomicStore.getLastNonEmptyId();
    }

    public int getLastNonEmptyId() {
        return this.atomicStore.getLastNonEmptyId();
    }

    public IntStream getIndexStream() {
        return IntStream.range(1, this.getMaximumId() + 1);
    }

    public BitSet filterEquals(String value, BitSet bitSet) {
        return this.filterEquals(value, bitSet.stream());
    }

    public BitSet filterEquals(String value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getText(id).equals(value)).forEach(result::set);
        return result;
    }

    public BitSet filterNotEquals(String value, BitSet bitSet) {
        return this.filterNotEquals(value, bitSet.stream());
    }

    public BitSet filterNotEquals(String value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> !this.atomicStore.getText(id).equals(value)).forEach(result::set);
        return result;
    }

    public BitSet filterContains(Set<String> valueSet, BitSet bitSet) {
        return this.filterContains(valueSet, bitSet.stream());
    }

    public BitSet filterContains(Set<String> valueSet, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> valueSet.contains(this.atomicStore.getText(id))).forEach(result::set);
        return result;
    }

    public BitSet filterContainsNot(Set<String> valueSet, BitSet bitSet) {
        return this.filterContainsNot(valueSet, bitSet.stream());
    }

    public BitSet filterContainsNot(Set<String> valueSet, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> !valueSet.contains(this.atomicStore.getText(id))).forEach(result::set);
        return result;
    }

    public void flush() {
        this.atomicStore.flush();
    }

    public void close() {
        this.atomicStore.close();
    }

    public void drop() {
        this.atomicStore.drop();
    }
}

