/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.log;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.teamapps.universaldb.index.log.LogIndex;
import org.teamapps.universaldb.index.log.LogIterator;
import org.teamapps.universaldb.index.log.PositionIndexedMessage;

public class DefaultLogIndex
implements LogIndex {
    private final File storeFile;
    private final DataOutputStream dos;
    private long position;

    public DefaultLogIndex(File basePath, String name) {
        this.storeFile = new File(basePath, name);
        this.position = this.storeFile.length();
        this.dos = this.createIndexFile();
    }

    private DataOutputStream createIndexFile() {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.storeFile, true), 16000));
            if (this.position == 0L) {
                dataOutputStream.writeInt((int)(System.currentTimeMillis() / 1000L));
                this.position = 4L;
            }
            return dataOutputStream;
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating log index", e);
        }
    }

    @Override
    public synchronized long writeLog(byte[] bytes, boolean committed) {
        try {
            this.dos.writeInt(bytes.length);
            this.dos.write(bytes);
            long storePos = this.position;
            this.position += (long)(bytes.length + 4);
            if (committed) {
                this.dos.flush();
            }
            return storePos;
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing log to file", e);
        }
    }

    @Override
    public synchronized byte[] readLog(long pos) {
        try {
            RandomAccessFile ras = new RandomAccessFile(this.storeFile, "r");
            ras.seek(pos);
            int size = ras.readInt();
            byte[] bytes = new byte[size];
            for (int read = 0; read < bytes.length; read += ras.read(bytes, read, size - read)) {
            }
            ras.close();
            return bytes;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading log file", e);
        }
    }

    @Override
    public LogIterator readLogs() {
        return new LogIterator(Collections.singletonList(this.storeFile), 0L, false);
    }

    @Override
    public LogIterator readLogs(long pos) {
        return new LogIterator(Collections.singletonList(this.storeFile), pos, false);
    }

    @Override
    public void readLogs(List<PositionIndexedMessage> messages) {
        if (!messages.isEmpty()) {
            messages.sort(Comparator.comparingLong(PositionIndexedMessage::getPosition));
            LogIterator iterator = new LogIterator(Collections.singletonList(this.storeFile), messages.get(0).getPosition(), false);
            iterator.readMessages(messages);
            iterator.closeSave();
        }
    }

    @Override
    public long[] readLogPositions() {
        if (this.isEmpty()) {
            return new long[0];
        }
        LogIterator logIterator = new LogIterator(Collections.singletonList(this.storeFile), 0L, false);
        ArrayList<Long> positions = new ArrayList<Long>();
        positions.add(4L);
        while (logIterator.hasNext()) {
            positions.add(logIterator.getCurrentReadPosition());
            logIterator.next();
        }
        return positions.stream().limit(positions.size() - 1).mapToLong(l -> l).toArray();
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public boolean isEmpty() {
        return this.position <= 4L;
    }

    @Override
    public long getStoreSize() {
        return this.storeFile.length();
    }

    @Override
    public void flush() {
        try {
            this.dos.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        try {
            this.dos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void drop() {
        try {
            this.close();
            this.storeFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

