/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.log;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.teamapps.message.protocol.file.FileData;
import org.teamapps.message.protocol.file.FileDataReader;
import org.teamapps.message.protocol.file.FileDataType;
import org.teamapps.message.protocol.file.FileDataWriter;
import org.teamapps.message.protocol.file.LocalFileData;

public class LocalFileStore
implements FileDataReader,
FileDataWriter {
    private final File basePath;
    private AtomicInteger idGenerator;

    public LocalFileStore(File path, String name) {
        this.basePath = new File(path, name);
        this.basePath.mkdir();
        this.idGenerator = new AtomicInteger(this.basePath.listFiles().length + 1);
    }

    public FileData readFileData(FileDataType type, String fileName, long length, String descriptor, boolean encrypted, String encryptionKey) {
        return new LocalFileData(fileName, length, descriptor);
    }

    public FileData writeFileData(FileData fileData) throws IOException {
        if (fileData.getBasePath().equals(this.basePath.getPath())) {
            return fileData;
        }
        String fileId = "F-" + System.currentTimeMillis() + "-" + Integer.toHexString(this.idGenerator.incrementAndGet()).toUpperCase() + ".bin";
        File destFile = new File(this.basePath, fileId);
        fileData.copyToFile(destFile);
        return new LocalFileData(fileData.getFileName(), fileData.getLength(), destFile.getPath());
    }
}

