/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.transaction.resolved;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.file.value.StoreDescriptionFile;
import org.teamapps.universaldb.index.reference.value.ResolvedMultiReferenceUpdate;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.universaldb.util.DataStreamUtil;

public class ResolvedTransactionRecordValue {
    private final int columnId;
    private final IndexType indexType;
    private final Object value;

    public ResolvedTransactionRecordValue(int columnId, IndexType indexType, Object value) {
        this.columnId = columnId;
        this.indexType = indexType;
        this.value = value;
    }

    public ResolvedTransactionRecordValue(DataInputStream dis) throws IOException {
        this.columnId = dis.readInt();
        this.indexType = IndexType.getIndexTypeById(dis.readByte());
        boolean valueAvailable = dis.readBoolean();
        this.value = valueAvailable ? this.readRecordValue(dis) : null;
    }

    public int getColumnId() {
        return this.columnId;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public Object getValue() {
        return this.value;
    }

    private Object readRecordValue(DataInputStream dis) throws IOException {
        switch (this.indexType) {
            case BOOLEAN: {
                return dis.readBoolean();
            }
            case SHORT: {
                return dis.readShort();
            }
            case INT: {
                return dis.readInt();
            }
            case LONG: {
                return dis.readLong();
            }
            case FLOAT: {
                return Float.valueOf(dis.readFloat());
            }
            case DOUBLE: {
                return dis.readDouble();
            }
            case TEXT: {
                return DataStreamUtil.readStringWithLengthHeader(dis);
            }
            case TRANSLATABLE_TEXT: {
                return new TranslatableText(dis);
            }
            case REFERENCE: {
                return dis.readInt();
            }
            case MULTI_REFERENCE: {
                return new ResolvedMultiReferenceUpdate(dis);
            }
            case FILE: {
                return new StoreDescriptionFile(dis);
            }
            case BINARY: {
                return DataStreamUtil.readByteArrayWithLengthHeader(dis);
            }
        }
        return null;
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.columnId);
        dos.writeByte(this.indexType.getId());
        if (this.value == null) {
            dos.writeBoolean(false);
        } else {
            dos.writeBoolean(true);
            switch (this.indexType) {
                case BOOLEAN: {
                    dos.writeBoolean((Boolean)this.value);
                    break;
                }
                case SHORT: {
                    dos.writeShort(((Short)this.value).shortValue());
                    break;
                }
                case INT: {
                    dos.writeInt((Integer)this.value);
                    break;
                }
                case LONG: {
                    dos.writeLong((Long)this.value);
                    break;
                }
                case FLOAT: {
                    dos.writeFloat(((Float)this.value).floatValue());
                    break;
                }
                case DOUBLE: {
                    dos.writeDouble((Double)this.value);
                    break;
                }
                case TEXT: {
                    DataStreamUtil.writeStringWithLengthHeader(dos, (String)this.value);
                    break;
                }
                case TRANSLATABLE_TEXT: {
                    TranslatableText translatableText = (TranslatableText)this.value;
                    translatableText.writeValues(dos);
                    break;
                }
                case REFERENCE: {
                    dos.writeInt((Integer)this.value);
                    break;
                }
                case MULTI_REFERENCE: {
                    ResolvedMultiReferenceUpdate multiReferenceUpdate = (ResolvedMultiReferenceUpdate)this.value;
                    multiReferenceUpdate.write(dos);
                    break;
                }
                case FILE: {
                    FileValue fileValue = (FileValue)this.value;
                    fileValue.writeValues(dos);
                    break;
                }
                case BINARY: {
                    DataStreamUtil.writeByteArrayWithLengthHeader(dos, (byte[])this.value);
                    break;
                }
            }
        }
    }
}

