/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.translation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;

public class BinaryTranslatedText {
    private final String originalLanguage;
    private final Map<String, String> map = new LinkedHashMap<String, String>();

    public BinaryTranslatedText(String text, String originalLanguage) {
        this.originalLanguage = originalLanguage;
        this.map.put(originalLanguage, text);
    }

    public BinaryTranslatedText(DataInputStream dis) throws IOException {
        this.originalLanguage = this.readShortString(dis);
        int size = dis.readShort();
        for (int i = 0; i < size; ++i) {
            String language = this.readShortString(dis);
            String text = this.readString(dis);
            this.map.put(language, text);
        }
    }

    public BinaryTranslatedText(byte[] bytes) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public BinaryTranslatedText setTranslation(String text, String language) {
        this.map.put(language, text);
        return this;
    }

    public String getText() {
        return this.map.get(this.originalLanguage);
    }

    public String getText(String language) {
        return this.map.get(language);
    }

    public byte[] getEncodedValue() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.writeShortString(this.originalLanguage, dos);
        dos.writeShort(this.map.size());
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            this.writeShortString(entry.getKey(), dos);
            this.writeString(entry.getValue(), dos);
        }
        dos.close();
        return bos.toByteArray();
    }

    private void writeShortString(String text, DataOutputStream dos) throws IOException {
        dos.writeByte(text.length());
        dos.write(text.getBytes(StandardCharsets.UTF_8));
    }

    private void writeString(String text, DataOutputStream dos) throws IOException {
        dos.writeInt(text.length());
        dos.write(text.getBytes(StandardCharsets.UTF_8));
    }

    private String readShortString(DataInputStream dis) throws IOException {
        int len = dis.readUnsignedByte();
        byte[] bytes = new byte[len];
        dis.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private String readString(DataInputStream dis) throws IOException {
        int len = dis.readInt();
        byte[] bytes = new byte[len];
        dis.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

