/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.message;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teamapps.message.protocol.message.MessageRecord;

public class BaseMessageCache {
    private final boolean fullCache;
    private final Map<Integer, MessageRecord> messageMap;
    private final List<MessageRecord> messageList;

    public static BaseMessageCache fullCache() {
        return new BaseMessageCache(true, 0);
    }

    public static BaseMessageCache lruCache(int size) {
        return new BaseMessageCache(false, size);
    }

    private BaseMessageCache(boolean fullCache, final int maxSize) {
        this.fullCache = fullCache;
        this.messageMap = !fullCache ? new LinkedHashMap<Integer, MessageRecord>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Integer, MessageRecord> eldest) {
                return this.size() >= maxSize;
            }
        } : new HashMap();
        this.messageList = fullCache ? new ArrayList() : null;
    }

    public void addMessage(int id, boolean update, MessageRecord message) {
        if (this.fullCache) {
            MessageRecord oldMessage;
            if (update && (oldMessage = this.messageMap.get(id)) != null) {
                this.messageList.remove(oldMessage);
            }
            this.messageList.add(message);
        }
        this.messageMap.put(id, message);
    }

    public void removeMessage(int id) {
        MessageRecord oldMessage = this.messageMap.remove(id);
        if (this.fullCache && oldMessage != null) {
            this.messageList.remove(oldMessage);
        }
    }

    public MessageRecord getMessage(int id) {
        return this.messageMap.get(id);
    }

    public List<MessageRecord> getMessages() {
        return new ArrayList<MessageRecord>(this.messageList);
    }

    public int getMessageCount() {
        return this.messageList.size();
    }

    public boolean isFullCache() {
        return this.fullCache;
    }
}

