/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.message;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.teamapps.message.protocol.file.FileDataReader;
import org.teamapps.message.protocol.file.FileDataWriter;
import org.teamapps.message.protocol.file.LocalFileStore;
import org.teamapps.message.protocol.message.Message;
import org.teamapps.message.protocol.message.MessageRecord;
import org.teamapps.message.protocol.model.ModelRegistry;
import org.teamapps.message.protocol.model.PojoObjectDecoderRegistry;
import org.teamapps.universaldb.index.buffer.common.PrimitiveEntryAtomicStore;
import org.teamapps.universaldb.message.BaseMessageCache;
import org.teamapps.universaldb.message.BaseMessageStore;
import org.teamapps.universaldb.message.BaseMessageStoreIterator;
import org.teamapps.universaldb.message.CloseableIterator;
import org.teamapps.universaldb.message.MessageChangeType;
import org.teamapps.universaldb.message.MessagePosition;

public class BaseMessageStoreImpl
implements BaseMessageStore {
    private final File storeFile;
    private final DataOutputStream dos;
    private final PrimitiveEntryAtomicStore messagePositions;
    private final ModelRegistry modelRegistry;
    private final LocalFileStore localFileStore;
    private final BaseMessageCache messageCache;
    private final BiConsumer<MessageRecord, MessageChangeType> changeHandler;
    private int lastId;
    private long position;

    public BaseMessageStoreImpl(File path, String name) {
        this(path, name, null, null, null);
    }

    public BaseMessageStoreImpl(File path, String name, BaseMessageCache messageCache) {
        this(path, name, null, messageCache, null);
    }

    public BaseMessageStoreImpl(File path, String name, ModelRegistry modelRegistry, BaseMessageCache messageCache, BiConsumer<MessageRecord, MessageChangeType> changeHandler) {
        File basePath = new File(path, name);
        basePath.mkdir();
        this.modelRegistry = modelRegistry;
        this.localFileStore = new LocalFileStore(basePath, "file-store");
        this.storeFile = new File(basePath, "messages.msx");
        this.position = this.storeFile.length();
        this.messagePositions = new PrimitiveEntryAtomicStore(basePath, "pos");
        this.changeHandler = changeHandler;
        this.dos = this.init();
        if (messageCache != null && messageCache.isFullCache()) {
            this.getStream().forEach(message -> messageCache.addMessage(message.getRecordId(), false, (MessageRecord)message));
        }
        this.messageCache = messageCache;
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
    }

    private DataOutputStream init() {
        try {
            this.lastId = (int)this.messagePositions.getLong(0);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.storeFile, true), 16000));
            if (this.position == 0L) {
                dataOutputStream.writeInt((int)(System.currentTimeMillis() / 1000L));
                this.position = 4L;
            } else {
                this.position = this.storeFile.length();
            }
            return dataOutputStream;
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating log index", e);
        }
    }

    @Override
    public synchronized void save(MessageRecord message) {
        try {
            int recordId = message.getRecordId();
            long previousPos = 0L;
            MessageChangeType changeType = MessageChangeType.UPDATE;
            if (recordId == 0) {
                changeType = MessageChangeType.CREATE;
                recordId = ++this.lastId;
                this.messagePositions.setLong(0, recordId);
                message.setRecordId(recordId);
                message.setRecordModificationDate(Instant.now());
            } else {
                previousPos = this.messagePositions.getLong(recordId);
                message.setRecordModificationDate(Instant.now());
            }
            if (this.changeHandler != null) {
                this.changeHandler.accept(message, changeType);
            }
            byte[] bytes = message.toBytes((FileDataWriter)this.localFileStore, true);
            this.dos.writeBoolean(false);
            this.dos.writeLong(previousPos);
            this.dos.writeLong(0L);
            this.dos.writeInt(bytes.length);
            this.dos.write(bytes);
            long storePos = this.position;
            this.position += (long)(bytes.length + 21);
            this.dos.flush();
            this.messagePositions.setLong(recordId, storePos);
            if (previousPos > 0L) {
                RandomAccessFile ras = new RandomAccessFile(this.storeFile, "rw");
                ras.seek(previousPos + 9L);
                ras.writeLong(storePos);
                ras.close();
            }
            if (this.messageCache != null) {
                this.messageCache.addMessage(recordId, previousPos > 0L, message);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void delete(int id) {
        try {
            long pos = this.messagePositions.getLong(id);
            if (pos > 0L) {
                this.messagePositions.setLong(id, pos * -1L);
                RandomAccessFile ras = new RandomAccessFile(this.storeFile, "rw");
                ras.seek(pos);
                ras.writeBoolean(true);
                ras.close();
                if (this.messageCache != null) {
                    this.messageCache.removeMessage(id);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void undelete(int id) {
        try {
            long pos = this.messagePositions.getLong(id);
            if (pos < 0L) {
                this.messagePositions.setLong(id, pos * -1L);
                RandomAccessFile ras = new RandomAccessFile(this.storeFile, "rw");
                ras.seek(pos * -1L);
                ras.writeBoolean(false);
                ras.close();
                if (this.messageCache != null) {
                    this.messageCache.removeMessage(id);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MessageRecord getById(int id) {
        if (this.messageCache != null) {
            MessageRecord message = this.messageCache.getMessage(id);
            if (message == null) {
                long pos = this.messagePositions.getLong(id);
                message = this.getByPosition(pos);
                if (message != null) {
                    this.messageCache.addMessage(id, false, message);
                }
                return message;
            }
            return message;
        }
        long pos = this.messagePositions.getLong(id);
        return this.getByPosition(pos);
    }

    @Override
    public MessageRecord getByPosition(long pos) {
        if (pos <= 0L) {
            return null;
        }
        try {
            RandomAccessFile ras = new RandomAccessFile(this.storeFile, "r");
            ras.seek(pos + 17L);
            int size = ras.readInt();
            byte[] bytes = new byte[size];
            for (int read = 0; read < bytes.length; read += ras.read(bytes, read, size - read)) {
            }
            ras.close();
            if (this.modelRegistry != null) {
                return new Message(bytes, this.modelRegistry, (FileDataReader)this.localFileStore, (PojoObjectDecoderRegistry)this.modelRegistry);
            }
            return new Message(bytes, (FileDataReader)this.localFileStore);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MessageRecord getLast() {
        return this.getById(this.lastId);
    }

    @Override
    public int getMessageCount() {
        if (this.messageCache != null && this.messageCache.isFullCache()) {
            return this.messageCache.getMessageCount();
        }
        return this.getMessagePositions(false, 0, false, Integer.MAX_VALUE).size();
    }

    @Override
    public int getDeletedCount() {
        return this.getMessagePositions(false, 0, true, Integer.MAX_VALUE).size();
    }

    private List<MessageRecord> readMessages(boolean backwards, int startId, boolean deleted, int limit) {
        List<MessagePosition<MessageRecord>> positionList = this.getMessagePositions(backwards, startId, deleted, limit);
        if (positionList.isEmpty()) {
            return Collections.emptyList();
        }
        Set<Long> requestedPositions = positionList.stream().map(MessagePosition::getPosition).collect(Collectors.toSet());
        long startPosition = positionList.stream().mapToLong(MessagePosition::getPosition).min().orElse(0L);
        CloseableIterator<MessageRecord> iterator = this.createIterator(deleted, startPosition, requestedPositions);
        ArrayList<MessageRecord> messages = new ArrayList<MessageRecord>();
        while (iterator.hasNext() && messages.size() < limit) {
            messages.add((MessageRecord)iterator.next());
        }
        return messages.stream().sorted(Comparator.comparingInt(MessageRecord::getRecordId)).collect(Collectors.toList());
    }

    private List<MessagePosition<MessageRecord>> getMessagePositions(boolean backwards, int startId, boolean deleted, int limit) {
        ArrayList<MessagePosition<MessageRecord>> positions = new ArrayList<MessagePosition<MessageRecord>>();
        int length = backwards ? startId : this.lastId + 1 - startId;
        for (int i = 0; i < length; ++i) {
            int id = backwards ? startId - i : startId + i;
            long position = this.messagePositions.getLong(id);
            if (position > 0L && !deleted) {
                positions.add(new MessagePosition(id, position));
            } else if (position < 0L && deleted) {
                positions.add(new MessagePosition(id, Math.abs(position)));
            }
            if (positions.size() != limit) continue;
            return positions;
        }
        return positions;
    }

    @Override
    public List<MessageRecord> getAllMessages() {
        if (this.messageCache != null && this.messageCache.isFullCache()) {
            return this.messageCache.getMessages();
        }
        return this.getStream().collect(Collectors.toList());
    }

    @Override
    public List<MessageRecord> getPreviousMessages(int id, int limit) {
        return this.readMessages(true, id, false, limit);
    }

    @Override
    public List<MessageRecord> getNextMessages(int id, int limit) {
        return this.readMessages(false, id, false, limit);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<MessageRecord> getMessageVersions(int id) {
        ArrayList<MessageRecord> messages = new ArrayList<MessageRecord>();
        long pos = this.messagePositions.getLong(id);
        try (RandomAccessFile ras = new RandomAccessFile(this.storeFile, "r");){
            while (pos > 0L) {
                try {
                    ras.seek(pos);
                    boolean deleted = ras.readBoolean();
                    long previousPos = ras.readLong();
                    long nextPos = ras.readLong();
                    pos = previousPos;
                    int size = ras.readInt();
                    byte[] bytes = new byte[size];
                    for (int read = 0; read < bytes.length; read += ras.read(bytes, read, size - read)) {
                    }
                    Message message = this.modelRegistry != null ? new Message(bytes, this.modelRegistry, (FileDataReader)this.localFileStore, (PojoObjectDecoderRegistry)this.modelRegistry) : new Message(bytes, (FileDataReader)this.localFileStore);
                    messages.add((MessageRecord)message);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                    return messages;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CloseableIterator<MessageRecord> iterate() {
        return this.createIterator(false, 0L);
    }

    @Override
    public CloseableIterator<MessageRecord> iterateDeleted() {
        return this.createIterator(true, 0L);
    }

    private CloseableIterator<MessageRecord> createIterator(boolean readDeleted, long startPos) {
        return this.createIterator(readDeleted, startPos, null);
    }

    private CloseableIterator<MessageRecord> createIterator(boolean readDeleted, long startPos, Set<Long> requestedPositions) {
        try {
            return new BaseMessageStoreIterator(requestedPositions, readDeleted, startPos, this.storeFile, this.modelRegistry, this.localFileStore);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Stream<MessageRecord> getStream() {
        return this.getStream(false, 0L);
    }

    @Override
    public Stream<MessageRecord> getStream(int id) {
        return this.getStream(false, id);
    }

    private Stream<MessageRecord> getStream(boolean readDeleted, long startPos) {
        CloseableIterator<MessageRecord> iterator = this.createIterator(readDeleted, startPos);
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).onClose(iterator::closeSave);
    }

    @Override
    public boolean isEmpty() {
        return this.position <= 4L;
    }

    @Override
    public long getStoreSize() {
        return this.storeFile.length();
    }

    @Override
    public void flush() {
        try {
            this.messagePositions.flush();
            this.dos.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        try {
            this.messagePositions.close();
            this.dos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void drop() {
        try {
            this.close();
            this.storeFile.delete();
            this.messagePositions.drop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

