/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.teamapps.universaldb.model.FieldModel;
import org.teamapps.universaldb.model.FieldType;
import org.teamapps.universaldb.model.TableModel;

public class FileFieldModel
extends FieldModel {
    private final boolean indexContent;
    private final int maxIndexContentLength;
    private final boolean detectLanguage;

    protected FileFieldModel(String title, TableModel tableModel) {
        this(title, title, tableModel, true, 100000, true);
    }

    protected FileFieldModel(String name, String title, TableModel tableModel, boolean indexContent, int maxIndexContentLength, boolean detectLanguage) {
        super(name, title, tableModel, FieldType.FILE);
        this.indexContent = indexContent;
        this.maxIndexContentLength = maxIndexContentLength;
        this.detectLanguage = detectLanguage;
    }

    protected FileFieldModel(DataInputStream dis, TableModel model) throws IOException {
        super(dis, model);
        this.indexContent = dis.readBoolean();
        this.maxIndexContentLength = dis.readInt();
        this.detectLanguage = dis.readBoolean();
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        super.write(dos);
        dos.writeBoolean(this.indexContent);
        dos.writeInt(this.maxIndexContentLength);
        dos.writeBoolean(this.detectLanguage);
    }

    public boolean isIndexContent() {
        return this.indexContent;
    }

    public int getMaxIndexContentLength() {
        return this.maxIndexContentLength;
    }

    public boolean isDetectLanguage() {
        return this.detectLanguage;
    }
}

