/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.buffer.index;

import java.io.File;
import java.util.BitSet;
import java.util.Set;
import java.util.stream.IntStream;
import org.teamapps.universaldb.index.buffer.common.PrimitiveEntryAtomicStore;

public class ShortAtomicMappedIndex {
    private final PrimitiveEntryAtomicStore atomicStore;

    public ShortAtomicMappedIndex(File path, String name) {
        this.atomicStore = new PrimitiveEntryAtomicStore(path, name);
    }

    public short getValue(int id) {
        return this.atomicStore.getShort(id);
    }

    public void setValue(int id, short value) {
        this.atomicStore.setShort(id, value);
    }

    public boolean isEmpty(int id) {
        return this.getValue(id) != 0;
    }

    public int getMaximumId() {
        return this.atomicStore.getMaximumId(2);
    }

    public int getLastNonEmptyIndex() {
        int maximumId;
        for (int i = maximumId = this.getMaximumId(); i > 0; --i) {
            if (this.isEmpty(i)) continue;
            return i;
        }
        return -1;
    }

    public IntStream getIndexStream() {
        return IntStream.range(1, this.getMaximumId() + 1);
    }

    public BitSet filterEquals(short value, BitSet bitSet) {
        return this.filterEquals(value, bitSet.stream());
    }

    public BitSet filterEquals(short value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getShort(id) == value).forEach(result::set);
        return result;
    }

    public BitSet filterNotEquals(short value, BitSet bitSet) {
        return this.filterNotEquals(value, bitSet.stream());
    }

    public BitSet filterNotEquals(short value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getShort(id) != value).forEach(result::set);
        return result;
    }

    public BitSet filterGreater(short value, BitSet bitSet) {
        return this.filterGreater(value, bitSet.stream());
    }

    public BitSet filterGreater(short value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getShort(id) > value).forEach(result::set);
        return result;
    }

    public BitSet filterSmaller(short value, BitSet bitSet) {
        return this.filterSmaller(value, bitSet.stream());
    }

    public BitSet filterSmaller(short value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getShort(id) < value).forEach(result::set);
        return result;
    }

    public BitSet filterBetween(short startValue, short endValue, BitSet bitSet) {
        return this.filterBetween(startValue, endValue, bitSet.stream());
    }

    public BitSet filterBetween(short startValue, short endValue, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> {
            short v = this.atomicStore.getShort(id);
            return v > startValue && v < endValue;
        }).forEach(result::set);
        return result;
    }

    public BitSet filterContains(Set<Short> valueSet, BitSet bitSet) {
        return this.filterContains(valueSet, bitSet.stream());
    }

    public BitSet filterContains(Set<Short> valueSet, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> valueSet.contains(this.atomicStore.getShort(id))).forEach(result::set);
        return result;
    }

    public BitSet filterContainsNot(Set<Short> valueSet, BitSet bitSet) {
        return this.filterContainsNot(valueSet, bitSet.stream());
    }

    public BitSet filterContainsNot(Set<Short> valueSet, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> !valueSet.contains(this.atomicStore.getShort(id))).forEach(result::set);
        return result;
    }

    public void flush() {
        this.atomicStore.flush();
    }

    public void close() {
        this.atomicStore.close();
    }

    public void drop() {
        this.atomicStore.drop();
    }
}

