/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.versioning;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.buffer.common.PrimitiveEntryAtomicStore;
import org.teamapps.universaldb.index.log.DefaultLogIndex;
import org.teamapps.universaldb.index.log.LogIndex;
import org.teamapps.universaldb.index.transaction.resolved.ResolvedTransaction;
import org.teamapps.universaldb.index.transaction.resolved.ResolvedTransactionRecord;
import org.teamapps.universaldb.index.versioning.RecordUpdate;

public class RecordVersioningIndex {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final File dataPath;
    private final TableIndex table;
    private PrimitiveEntryAtomicStore positionsIndex;
    private LogIndex logIndex;

    public RecordVersioningIndex(TableIndex table) {
        this.table = table;
        this.dataPath = table.getDataPath();
        this.positionsIndex = new PrimitiveEntryAtomicStore(this.dataPath, "versioning-pos");
        this.logIndex = new DefaultLogIndex(this.dataPath, "versioning-log.vdx");
    }

    public boolean isEmpty() {
        return this.logIndex.isEmpty();
    }

    public void checkVersionIndex(UniversalDB universalDB) {
        try {
            if (this.logIndex.isEmpty() && this.table.getCount() > 0) {
                long time = System.currentTimeMillis();
                logger.info("Empty version index, write index for: {}", (Object)this.table.getFQN());
                universalDB.createInitialTableTransactions(this.table);
                logger.info("Finished writing version index for: {}, time: {}", (Object)this.table.getName(), (Object)(System.currentTimeMillis() - time));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error writing initial versioning index", e);
        }
    }

    public List<RecordUpdate> readRecordUpdates(int recordId) throws IOException {
        long storePos = this.positionsIndex.getLong(recordId);
        if (storePos == 0L) {
            return Collections.emptyList();
        }
        ArrayList<RecordUpdate> recordUpdates = new ArrayList<RecordUpdate>();
        byte[] bytes = this.logIndex.readLog(storePos);
        RecordUpdate recordUpdate = new RecordUpdate(bytes);
        recordUpdates.add(recordUpdate);
        while (recordUpdate.getPreviousPosition() > 0L) {
            bytes = this.logIndex.readLog(recordUpdate.getPreviousPosition());
            recordUpdate = new RecordUpdate(bytes);
            recordUpdates.add(recordUpdate);
        }
        Collections.reverse(recordUpdates);
        return recordUpdates;
    }

    public void writeRecordUpdate(ResolvedTransaction transaction, ResolvedTransactionRecord record) {
        this.writeRecordUpdate(RecordUpdate.createUpdate(transaction, record));
    }

    public void writeRecordUpdate(RecordUpdate recordUpdate) {
        try {
            long previousPosition = this.positionsIndex.getLong(recordUpdate.getRecordId());
            recordUpdate.setPreviousPosition(previousPosition);
            byte[] updateEntry = recordUpdate.getBytes();
            long newPosition = this.logIndex.writeLog(updateEntry);
            this.positionsIndex.setLong(recordUpdate.getRecordId(), newPosition);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating new record update", e);
        }
    }

    public void close() {
        try {
            this.positionsIndex.close();
            this.logIndex.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void drop() {
        this.positionsIndex.drop();
        this.logIndex.drop();
    }
}

