/*-
 * ========================LICENSE_START=================================
 * UniversalDB
 * ---
 * Copyright (C) 2014 - 2023 TeamApps.org
 * ---
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
package org.teamapps.universaldb.index.file.value;

import java.util.HashMap;
import java.util.Map;

public enum MimeType {
	X3D("x3d", "application/vnd.hzn-3d-crossword", "3D Crossword Plugin"),
	MSEQ("mseq", "application/vnd.mseq", "3GPP MSEQ File"),
	PWN("pwn", "application/vnd.3m.post-it-notes", "3M Post It Notes"),
	PLB("plb", "application/vnd.3gpp.pic-bw-large", "3rd Generation Partnership Project - Pic Large"),
	PSB("psb", "application/vnd.3gpp.pic-bw-small", "3rd Generation Partnership Project - Pic Small"),
	PVB("pvb", "application/vnd.3gpp.pic-bw-var", "3rd Generation Partnership Project - Pic Var"),
	TCAP("tcap", "application/vnd.3gpp2.tcap", "3rd Generation Partnership Project - Transaction Capabilities Application Part"),
	_7ZIP("7z", "application/x-7z-compressed", "7-Zip"),
	ABW("abw", "application/x-abiword", "AbiWord"),
	ACE("ace", "application/x-ace-compressed", "Ace Archive"),
	ACC("acc", "application/vnd.americandynamics.acc", "Active Content Compression"),
	ACU("acu", "application/vnd.acucobol", "ACU Cobol"),
	ATC("atc", "application/vnd.acucorp", "ACU Cobol"),
	ADP("adp", "audio/adpcm", "Adaptive differential pulse-code modulation"),
	AAB("aab", "application/x-authorware-bin", "Adobe (Macropedia) Authorware - Binary File"),
	AAM("aam", "application/x-authorware-map", "Adobe (Macropedia) Authorware - Map"),
	AAS("aas", "application/x-authorware-seg", "Adobe (Macropedia) Authorware - Segment File"),
	AIR("air", "application/vnd.adobe.air-application-installer-package+zip", "Adobe AIR Application"),
	SWF("swf", "application/x-shockwave-flash", "Adobe Flash"),
	FXP("fxp", "application/vnd.adobe.fxp", "Adobe Flex Project"),
	PDF("pdf", "application/pdf", "Adobe Portable Document Format"),
	PPD("ppd", "application/vnd.cups-ppd", "Adobe PostScript Printer Description File Format"),
	DIR("dir", "application/x-director", "Adobe Shockwave Player"),
	XDP("xdp", "application/vnd.adobe.xdp+xml", "Adobe XML Data Package"),
	XFDF("xfdf", "application/vnd.adobe.xfdf", "Adobe XML Forms Data Format"),
	AAC("aac", "audio/x-aac", "Advanced Audio Coding (AAC)"),
	AHEAD("ahead", "application/vnd.ahead.space", "Ahead AIR Application"),
	AZF("azf", "application/vnd.airzip.filesecure.azf", "AirZip FileSECURE"),
	AZS("azs", "application/vnd.airzip.filesecure.azs", "AirZip FileSECURE"),
	AZW("azw", "application/vnd.amazon.ebook", "Amazon Kindle eBook format"),
	AMI("ami", "application/vnd.amiga.ami", "AmigaDE"),
	APK("apk", "application/vnd.android.package-archive", "Android Package Archive"),
	CII("cii", "application/vnd.anser-web-certificate-issue-initiation", "ANSER-WEB Terminal Client - Certificate Issue"),
	FTI("fti", "application/vnd.anser-web-funds-transfer-initiation", "ANSER-WEB Terminal Client - Web Funds Transfer"),
	ATX("atx", "application/vnd.antix.game-component", "Antix Game Player"),
	DMG("dmg", "application/x-apple-diskimage", "Apple Disk Image"),
	MPKG("mpkg", "application/vnd.apple.installer+xml", "Apple Installer Package"),
	AW("aw", "application/applixware", "Applixware"),
	LES("les", "application/vnd.hhe.lesson-player", "Archipelago Lesson Player"),
	ARC("arc", "application/x-freearc", "Archive document - Multiple Fils Embedded"),
	SWI("swi", "application/vnd.aristanetworks.swi", "Arista Networks Software Image"),
	S("s", "text/x-asm", "Assembler Source File"),
	ATOMCAT("atomcat", "application/atomcat+xml", "Atom Publishing Protocol"),
	ATOMSVC("atomsvc", "application/atomsvc+xml", "Atom Publishing Protocol Service Document"),
	ATOM_XML("atom", "application/atom+xml", "Atom Syndication Format"),
	AC("ac", "application/pkix-attr-cert", "Attribute Certificate"),
	AIF("aif", "audio/x-aiff", "Audio Interchange File Format"),
	AVI("avi", "video/x-msvideo", "Audio Video Interleave (AVI)"),
	AEP("aep", "application/vnd.audiograph", "Audiograph"),
	DXF("dxf", "image/vnd.dxf", "AutoCAD DXF"),
	DWF("dwf", "model/vnd.dwf", "Autodesk Design Web Format (DWF)"),
	AVIF("avif", "image/avif", "AV1 Image File"),
	PAR("par", "text/plain-bas", "BAS Partitur Format"),
	BCPIO("bcpio", "application/x-bcpio", "Binary CPIO Archive"),
	BIN("bin", "application/octet-stream", "Binary Data"),
	BMP("bmp", "image/bmp", "Bitmap Image File"),
	TORRENT("torrent", "application/x-bittorrent", "BitTorrent"),
	COD("cod", "application/vnd.rim.cod", "Blackberry COD File"),
	MPM("mpm", "application/vnd.blueice.multipass", "Blueice Research Multipass"),
	BMI("bmi", "application/vnd.bmi", "BMI Drawing Data Interchange"),
	SH("sh", "application/x-sh", "Bourne Shell Script"),
	BTIF("btif", "image/prs.btif", "BTIF"),
	REP("rep", "application/vnd.businessobjects", "BusinessObjects"),
	BZ("bz", "application/x-bzip", "Bzip Archive"),
	BZ2("bz2", "application/x-bzip2", "Bzip2 Archive"),
	CSH("csh", "application/x-csh", "C Shell Script"),
	C("c", "text/x-c", "C Source File"),
	CDXML("cdxml", "application/vnd.chemdraw+xml", "CambridgeSoft Chem Draw"),
	CSS("css", "text/css", "Cascading Style Sheets (CSS)"),
	CDA("cda", "application/x-cdf", "CD Audio"),
	CDX("cdx", "chemical/x-cdx", "ChemDraw eXchange file"),
	CML("cml", "chemical/x-cml", "Chemical Markup Language"),
	CSML("csml", "chemical/x-csml", "Chemical Style Markup Language"),
	CDBCMSG("cdbcmsg", "application/vnd.contact.cmsg", "CIM Database"),
	CLA("cla", "application/vnd.claymore", "Claymore Data Files"),
	C4G("c4g", "application/vnd.clonk.c4group", "Clonk Game"),
	SUB("sub", "image/vnd.dvb.subtitle", "Close Captioning - Subtitle"),
	CDMIA("cdmia", "application/cdmi-capability", "Cloud Data Management Interface (CDMI) - Capability"),
	CDMIC("cdmic", "application/cdmi-container", "Cloud Data Management Interface (CDMI) - Contaimer"),
	CDMID("cdmid", "application/cdmi-domain", "Cloud Data Management Interface (CDMI) - Domain"),
	CDMIO("cdmio", "application/cdmi-object", "Cloud Data Management Interface (CDMI) - Object"),
	CDMIQ("cdmiq", "application/cdmi-queue", "Cloud Data Management Interface (CDMI) - Queue"),
	C11AMC("c11amc", "application/vnd.cluetrust.cartomobile-config", "ClueTrust CartoMobile - Config"),
	C11AMZ("c11amz", "application/vnd.cluetrust.cartomobile-config-pkg", "ClueTrust CartoMobile - Config Package"),
	RAS("ras", "image/x-cmu-raster", "CMU Image"),
	DAE("dae", "model/vnd.collada+xml", "COLLADA"),
	CSV("csv", "text/csv", "Comma-Seperated Values"),
	CPT("cpt", "application/mac-compactpro", "Compact Pro"),
	WMLC("wmlc", "application/vnd.wap.wmlc", "Compiled Wireless Markup Language (WMLC)"),
	CGM("cgm", "image/cgm", "Computer Graphics Metafile"),
	ICE("ice", "x-conference/x-cooltalk", "CoolTalk"),
	CMX("cmx", "image/x-cmx", "Corel Metafile Exchange (CMX)"),
	XAR("xar", "application/vnd.xara", "CorelXARA"),
	CMC("cmc", "application/vnd.cosmocaller", "CosmoCaller"),
	CPIO("cpio", "application/x-cpio", "CPIO Archive"),
	CLKX("clkx", "application/vnd.crick.clicker", "CrickSoftware - Clicker"),
	CLKK("clkk", "application/vnd.crick.clicker.keyboard", "CrickSoftware - Clicker - Keyboard"),
	CLKP("clkp", "application/vnd.crick.clicker.palette", "CrickSoftware - Clicker - Palette"),
	CLKT("clkt", "application/vnd.crick.clicker.template", "CrickSoftware - Clicker - Template"),
	CLKW("clkw", "application/vnd.crick.clicker.wordbank", "CrickSoftware - Clicker - Wordbank"),
	WBS("wbs", "application/vnd.criticaltools.wbs+xml", "Critical Tools - PERT Chart EXPERT"),
	CRYPTONOTE("cryptonote", "application/vnd.rig.cryptonote", "CryptoNote"),
	CIF("cif", "chemical/x-cif", "Crystallographic Interchange Format"),
	CMDF("cmdf", "chemical/x-cmdf", "CrystalMaker Data Format"),
	CU("cu", "application/cu-seeme", "CU-SeeMe"),
	CWW("cww", "application/prs.cww", "CU-Writer"),
	CURL("curl", "text/vnd.curl", "Curl - Applet"),
	DCURL("dcurl", "text/vnd.curl.dcurl", "Curl - Detached Applet"),
	MCURL("mcurl", "text/vnd.curl.mcurl", "Curl - Manifest File"),
	SCURL("scurl", "text/vnd.curl.scurl", "Curl - Source Code"),
	CAR("car", "application/vnd.curl.car", "CURL Applet"),
	PCURL("pcurl", "application/vnd.curl.pcurl", "CURL Applet"),
	CMP("cmp", "application/vnd.yellowriver-custom-menu", "CustomMenu"),
	DSSC("dssc", "application/dssc+der", "Data Structure for the Security Suitability of Cryptographic Algorithms"),
	XDSSC("xdssc", "application/dssc+xml", "Data Structure for the Security Suitability of Cryptographic Algorithms"),
	DEB("deb", "application/x-debian-package", "Debian Package"),
	UVA("uva", "audio/vnd.dece.audio", "DECE Audio"),
	UVI("uvi", "image/vnd.dece.graphic", "DECE Graphic"),
	UVH("uvh", "video/vnd.dece.hd", "DECE High Definition Video"),
	UVM("uvm", "video/vnd.dece.mobile", "DECE Mobile Video"),
	UVU("uvu", "video/vnd.uvvu.mp4", "DECE MP4"),
	UVP("uvp", "video/vnd.dece.pd", "DECE PD Video"),
	UVS("uvs", "video/vnd.dece.sd", "DECE SD Video"),
	UVV("uvv", "video/vnd.dece.video", "DECE Video"),
	DVI("dvi", "application/x-dvi", "Device Independent File Format (DVI)"),
	SEED("seed", "application/vnd.fdsn.seed", "Digital Siesmograph Networks - SEED Datafiles"),
	DTB("dtb", "application/x-dtbook+xml", "Digital Talking Book"),
	RES("res", "application/x-dtbresource+xml", "Digital Talking Book - Resource File"),
	AIT("ait", "application/vnd.dvb.ait", "Digital Video Broadcasting"),
	SVC("svc", "application/vnd.dvb.service", "Digital Video Broadcasting"),
	EOL("eol", "audio/vnd.digital-winds", "Digital Winds Music"),
	DJVU("djvu", "image/vnd.djvu", "DjVu"),
	DTD("dtd", "application/xml-dtd", "Document Type Definition"),
	MLP("mlp", "application/vnd.dolby.mlp", "Dolby Meridian Lossless Packing"),
	WAD("wad", "application/x-doom", "Doom Video Game"),
	DPG("dpg", "application/vnd.dpgraph", "DPGraph"),
	DRA("dra", "audio/vnd.dra", "DRA Audio"),
	DFAC("dfac", "application/vnd.dreamfactory", "DreamFactory"),
	DTS("dts", "audio/vnd.dts", "DTS Audio"),
	DTSHD("dtshd", "audio/vnd.dts.hd", "DTS High Definition Audio"),
	DWG("dwg", "image/vnd.dwg", "DWG Drawing"),
	GEO("geo", "application/vnd.dynageo", "DynaGeo"),
	ES("es", "application/ecmascript", "ECMAScript"),
	MAG("mag", "application/vnd.ecowin.chart", "EcoWin Chart"),
	MMR("mmr", "image/vnd.fujixerox.edmics-mmr", "EDMICS 2000"),
	RLC("rlc", "image/vnd.fujixerox.edmics-rlc", "EDMICS 2000"),
	EXI("exi", "application/exi", "Efficient XML Interchange"),
	MGZ("mgz", "application/vnd.proteus.magazine", "EFI Proteus"),
	EPUB("epub", "application/epub+zip", "Electronic Publication"),
	EML("eml", "message/rfc822", "Email Message"),
	NML("nml", "application/vnd.enliven", "Enliven Viewer"),
	XPR("xpr", "application/vnd.is-xpr", "Express by Infoseek"),
	XIF("xif", "image/vnd.xiff", "eXtended Image File Format (XIFF)"),
	XFDL("xfdl", "application/vnd.xfdl", "Extensible Forms Description Language"),
	EMMA("emma", "application/emma+xml", "Extensible MultiModal Annotation"),
	EZ2("ez2", "application/vnd.ezpix-album", "EZPix Secure Photo Album"),
	EZ3("ez3", "application/vnd.ezpix-package", "EZPix Secure Photo Album"),
	FST("fst", "image/vnd.fst", "FAST Search & Transfer ASA"),
	FVT("fvt", "video/vnd.fvt", "FAST Search & Transfer ASA"),
	FBS("fbs", "image/vnd.fastbidsheet", "FastBid Sheet"),
	FE_LAUNCH("fe_launch", "application/vnd.denovo.fcselayout-link", "FCS Express Layout Link"),
	F4V("f4v", "video/x-f4v", "Flash Video"),
	FLV("flv", "video/x-flv", "Flash Video"),
	FPX("fpx", "image/vnd.fpx", "FlashPix"),
	NPX("npx", "image/vnd.net-fpx", "FlashPix"),
	FLX("flx", "text/vnd.fmi.flexstor", "FLEXSTOR"),
	FLI("fli", "video/x-fli", "FLI/FLC Animation Format"),
	FTC("ftc", "application/vnd.fluxtime.clip", "FluxTime Clip"),
	FDF("fdf", "application/vnd.fdf", "Forms Data Format"),
	F("f", "text/x-fortran", "Fortran Source File"),
	MIF("mif", "application/vnd.mif", "FrameMaker Interchange Format"),
	FM("fm", "application/vnd.framemaker", "FrameMaker Normal Format"),
	FH("fh", "image/x-freehand", "FreeHand MX"),
	FSC("fsc", "application/vnd.fsc.weblaunch", "Friendly Software Corporation"),
	FNC("fnc", "application/vnd.frogans.fnc", "Frogans Player"),
	LTF("ltf", "application/vnd.frogans.ltf", "Frogans Player"),
	DDD("ddd", "application/vnd.fujixerox.ddd", "Fujitsu - Xerox 2D CAD Data"),
	XDW("xdw", "application/vnd.fujixerox.docuworks", "Fujitsu - Xerox DocuWorks"),
	XBD("xbd", "application/vnd.fujixerox.docuworks.binder", "Fujitsu - Xerox DocuWorks Binder"),
	OAS("oas", "application/vnd.fujitsu.oasys", "Fujitsu Oasys"),
	OA2("oa2", "application/vnd.fujitsu.oasys2", "Fujitsu Oasys"),
	OA3("oa3", "application/vnd.fujitsu.oasys3", "Fujitsu Oasys"),
	FG5("fg5", "application/vnd.fujitsu.oasysgp", "Fujitsu Oasys"),
	BH2("bh2", "application/vnd.fujitsu.oasysprs", "Fujitsu Oasys"),
	SPL("spl", "application/x-futuresplash", "FutureSplash Animator"),
	FZS("fzs", "application/vnd.fuzzysheet", "FuzzySheet"),
	G3("g3", "image/g3fax", "G3 Fax Image"),
	GMX("gmx", "application/vnd.gmx", "GameMaker ActiveX"),
	GTW("gtw", "model/vnd.gtw", "Gen-Trix Studio"),
	TXD("txd", "application/vnd.genomatix.tuxedo", "Genomatix Tuxedo Framework"),
	GGB("ggb", "application/vnd.geogebra.file", "GeoGebra"),
	GGT("ggt", "application/vnd.geogebra.tool", "GeoGebra"),
	GDL("gdl", "model/vnd.gdl", "Geometric Description Language (GDL)"),
	GEX("gex", "application/vnd.geometry-explorer", "GeoMetry Explorer"),
	GXT("gxt", "application/vnd.geonext", "GEONExT and JSXGraph"),
	G2W("g2w", "application/vnd.geoplan", "GeoplanW"),
	G3W("g3w", "application/vnd.geospace", "GeospacW"),
	GSF("gsf", "application/x-font-ghostscript", "Ghostscript Font"),
	BDF("bdf", "application/x-font-bdf", "Glyph Bitmap Distribution Format"),
	GTAR("gtar", "application/x-gtar", "GNU Tar Files"),
	TEXINFO("texinfo", "application/x-texinfo", "GNU Texinfo Document"),
	GNUMERIC("gnumeric", "application/x-gnumeric", "Gnumeric"),
	KML("kml", "application/vnd.google-earth.kml+xml", "Google Earth - KML"),
	KMZ("kmz", "application/vnd.google-earth.kmz", "Google Earth - Zipped KML"),
	GPX("gpx", "application/gpx+xml", "GPS eXchange Format"),
	GQF("gqf", "application/vnd.grafeq", "GrafEq"),
	GIF("gif", "image/gif", "Graphics Interchange Format"),
	GV("gv", "text/vnd.graphviz", "Graphviz"),
	GAC("gac", "application/vnd.groove-account", "Groove - Account"),
	GHF("ghf", "application/vnd.groove-help", "Groove - Help"),
	GIM("gim", "application/vnd.groove-identity-message", "Groove - Identity Message"),
	GRV("grv", "application/vnd.groove-injector", "Groove - Injector"),
	GTM("gtm", "application/vnd.groove-tool-message", "Groove - Tool Message"),
	TPL("tpl", "application/vnd.groove-tool-template", "Groove - Tool Template"),
	VCG("vcg", "application/vnd.groove-vcard", "Groove - Vcard"),
	GZ("gz", "application/gzip", "GZip"),
	H261("h261", "video/h261", "H.261"),
	H263("h263", "video/h263", "H.263"),
	H264("h264", "video/h264", "H.264"),
	HPID("hpid", "application/vnd.hp-hpid", "Hewlett Packard Instant Delivery"),
	HPS("hps", "application/vnd.hp-hps", "Hewlett-Packard's WebPrintSmart"),
	HDF("hdf", "application/x-hdf", "Hierarchical Data Format"),
	RIP("rip", "audio/vnd.rip", "Hit'n'Mix"),
	HBCI("hbci", "application/vnd.hbci", "Homebanking Computer Interface (HBCI)"),
	JLT("jlt", "application/vnd.hp-jlyt", "HP Indigo Digital Press - Job Layout Languate"),
	PCL("pcl", "application/vnd.hp-pcl", "HP Printer Command Language"),
	HPGL("hpgl", "application/vnd.hp-hpgl", "HP-GL/2 and HP RTL"),
	HVS("hvs", "application/vnd.yamaha.hv-script", "HV Script"),
	HVD("hvd", "application/vnd.yamaha.hv-dic", "HV Voice Dictionary"),
	HVP("hvp", "application/vnd.yamaha.hv-voice", "HV Voice Parameter"),
	SFD_HDSTX("sfd-hdstx", "application/vnd.hydrostatix.sof-data", "Hydrostatix Master Suite"),
	STK("stk", "application/hyperstudio", "Hyperstudio"),
	HAL("hal", "application/vnd.hal+xml", "Hypertext Application Language"),
	HTML("html", "text/html", "HyperText Markup Language (HTML)"),
	IRM("irm", "application/vnd.ibm.rights-management", "IBM DB2 Rights Manager"),
	SC("sc", "application/vnd.ibm.secure-container", "IBM Electronic Media Management System - Secure Container"),
	ICS("ics", "text/calendar", "iCalendar"),
	ICC("icc", "application/vnd.iccprofile", "ICC profile"),
	ICO("ico", "image/x-icon", "Icon Image"),
	IGL("igl", "application/vnd.igloader", "igLoader"),
	IEF("ief", "image/ief", "Image Exchange Format"),
	IVP("ivp", "application/vnd.immervision-ivp", "ImmerVision PURE Players"),
	IVU("ivu", "application/vnd.immervision-ivu", "ImmerVision PURE Players"),
	RIF("rif", "application/reginfo+xml", "IMS Networks"),
	_3DML("3dml", "text/vnd.in3d.3dml", "In3D - 3DML"),
	SPOT("spot", "text/vnd.in3d.spot", "In3D - 3DML"),
	IGS("igs", "model/iges", "Initial Graphics Exchange Specification (IGES)"),
	I2G("i2g", "application/vnd.intergeo", "Interactive Geometry Software"),
	CDY("cdy", "application/vnd.cinderella", "Interactive Geometry Software Cinderella"),
	XPW("xpw", "application/vnd.intercon.formnet", "Intercon FormNet"),
	FCS("fcs", "application/vnd.isac.fcs", "International Society for Advancement of Cytometry"),
	IPFIX("ipfix", "application/ipfix", "Internet Protocol Flow Information Export"),
	CER("cer", "application/pkix-cert", "Internet Public Key Infrastructure - Certificate"),
	PKI("pki", "application/pkixcmp", "Internet Public Key Infrastructure - Certificate Management Protocole"),
	CRL("crl", "application/pkix-crl", "Internet Public Key Infrastructure - Certificate Revocation Lists"),
	PKIPATH("pkipath", "application/pkix-pkipath", "Internet Public Key Infrastructure - Certification Path"),
	IGM("igm", "application/vnd.insors.igm", "IOCOM Visimeet"),
	RCPROFILE("rcprofile", "application/vnd.ipunplugged.rcprofile", "IP Unplugged Roaming Client"),
	IRP("irp", "application/vnd.irepository.package+xml", "iRepository / Lucidoc Editor"),
	JAD("jad", "text/vnd.sun.j2me.app-descriptor", "J2ME App Descriptor"),
	JAR("jar", "application/java-archive", "Java Archive"),
	CLASS("class", "application/java-vm", "Java Bytecode File"),
	JNLP("jnlp", "application/x-java-jnlp-file", "Java Network Launching Protocol"),
	SER("ser", "application/java-serialized-object", "Java Serialized Object"),
	JAVA("java", "text/x-java-source,java", "Java Source File"),
	JS("js", "application/javascript", "JavaScript"),
	MJS("mjs", "text/javascript", "JavaScript Module"),
	JSON("json", "application/json", "JavaScript Object Notation (JSON)"),
	JODA("joda", "application/vnd.joost.joda-archive", "Joda Archive"),
	JPM("jpm", "video/jpm", "JPEG 2000 Compound Image File Format"),
	JPEG("jpeg", "image/jpeg", "JPEG Image"),
	JPG("jpg", "image/jpeg", "JPEG Image"),
	PJPEG("pjpeg", "image/pjpeg", "JPEG Image (Progressive)"),
	JPGV("jpgv", "video/jpeg", "JPGVideo"),
	JSONLD("jsonld", "application/ld+json", "JSON - Linked Data"),
	KTZ("ktz", "application/vnd.kahootz", "Kahootz"),
	MMD("mmd", "application/vnd.chipnuts.karaoke-mmd", "Karaoke on Chipnuts Chipsets"),
	KARBON("karbon", "application/vnd.kde.karbon", "KDE KOffice Office Suite - Karbon"),
	CHRT("chrt", "application/vnd.kde.kchart", "KDE KOffice Office Suite - KChart"),
	KFO("kfo", "application/vnd.kde.kformula", "KDE KOffice Office Suite - Kformula"),
	FLW("flw", "application/vnd.kde.kivio", "KDE KOffice Office Suite - Kivio"),
	KON("kon", "application/vnd.kde.kontour", "KDE KOffice Office Suite - Kontour"),
	KPR("kpr", "application/vnd.kde.kpresenter", "KDE KOffice Office Suite - Kpresenter"),
	KSP("ksp", "application/vnd.kde.kspread", "KDE KOffice Office Suite - Kspread"),
	KWD("kwd", "application/vnd.kde.kword", "KDE KOffice Office Suite - Kword"),
	HTKE("htke", "application/vnd.kenameaapp", "Kenamea App"),
	KIA("kia", "application/vnd.kidspiration", "Kidspiration"),
	KNE("kne", "application/vnd.kinar", "Kinar Applications"),
	SSE("sse", "application/vnd.kodak-descriptor", "Kodak Storyshare"),
	LASXML("lasxml", "application/vnd.las.las+xml", "Laser App Enterprise"),
	LATEX("latex", "application/x-latex", "LaTeX"),
	LBD("lbd", "application/vnd.llamagraphics.life-balance.desktop", "Life Balance - Desktop Edition"),
	LBE("lbe", "application/vnd.llamagraphics.life-balance.exchange+xml", "Life Balance - Exchange Format"),
	JAM("jam", "application/vnd.jam", "Lightspeed Audio Lab"),
 	_123("123", "application/vnd.lotus-1-2-3", "Lotus 1-2-3"),
	APR("apr", "application/vnd.lotus-approach", "Lotus Approach"),
	PRE("pre", "application/vnd.lotus-freelance", "Lotus Freelance"),
	NSF("nsf", "application/vnd.lotus-notes", "Lotus Notes"),
	ORG("org", "application/vnd.lotus-organizer", "Lotus Organizer"),
	SCM("scm", "application/vnd.lotus-screencam", "Lotus Screencam"),
	LWP("lwp", "application/vnd.lotus-wordpro", "Lotus Wordpro"),
	LVP("lvp", "audio/vnd.lucent.voice", "Lucent Voice"),
	M3U("m3u", "audio/x-mpegurl", "M3U (Multimedia Playlist)"),
	M4V("m4v", "video/x-m4v", "M4v"),
	HQX("hqx", "application/mac-binhex40", "Macintosh BinHex 4.0"),
	PORTPKG("portpkg", "application/vnd.macports.portpkg", "MacPorts Port System"),
	MGP("mgp", "application/vnd.osgeo.mapguide.package", "MapGuide DBXML"),
	MRC("mrc", "application/marc", "MARC Formats"),
	MRCX("mrcx", "application/marcxml+xml", "MARC21 XML Schema"),
	MXF("mxf", "application/mxf", "Material Exchange Format"),
	NBP("nbp", "application/vnd.wolfram.player", "Mathematica Notebook Player"),
	MA("ma", "application/mathematica", "Mathematica Notebooks"),
	MATHML("mathml", "application/mathml+xml", "Mathematical Markup Language"),
	MBOX("mbox", "application/mbox", "Mbox database files"),
	MC1("mc1", "application/vnd.medcalcdata", "MedCalc"),
	MSCML("mscml", "application/mediaservercontrol+xml", "Media Server Control Markup Language"),
	CDKEY("cdkey", "application/vnd.mediastation.cdkey", "MediaRemote"),
	MWF("mwf", "application/vnd.mfer", "Medical Waveform Encoding Format"),
	MFM("mfm", "application/vnd.mfmp", "Melody Format for Mobile Platform"),
	MSH("msh", "model/mesh", "Mesh Data Type"),
	MADS("mads", "application/mads+xml", "Metadata Authority Description Schema"),
	METS("mets", "application/mets+xml", "Metadata Encoding and Transmission Standard"),
	MODS("mods", "application/mods+xml", "Metadata Object Description Schema"),
	META4("meta4", "application/metalink4+xml", "Metalink"),
	MCD("mcd", "application/vnd.mcd", "Micro CADAM Helix D&D"),
	FLO("flo", "application/vnd.micrografx.flo", "Micrografx"),
	IGX("igx", "application/vnd.micrografx.igx", "Micrografx iGrafx Professional"),
	ES3("es3", "application/vnd.eszigno3+xml", "MICROSEC e-Szign�"),
	MDB("mdb", "application/x-msaccess", "Microsoft Access"),
	ASF("asf", "video/x-ms-asf", "Microsoft Advanced Systems Format (ASF)"),
	EXE("exe", "application/x-msdownload", "Microsoft Application"),
	CIL("cil", "application/vnd.ms-artgalry", "Microsoft Artgalry"),
	CAB("cab", "application/vnd.ms-cab-compressed", "Microsoft Cabinet File"),
	IMS("ims", "application/vnd.ms-ims", "Microsoft Class Server"),
	APPLICATION("application", "application/x-ms-application", "Microsoft ClickOnce"),
	CLP("clp", "application/x-msclip", "Microsoft Clipboard Clip"),
	MDI("mdi", "image/vnd.ms-modi", "Microsoft Document Imaging Format"),
	EOT("eot", "application/vnd.ms-fontobject", "Microsoft Embedded OpenType"),
	XLS("xls", "application/vnd.ms-excel", "Microsoft Excel"),
	XLAM("xlam", "application/vnd.ms-excel.addin.macroenabled.12", "Microsoft Excel - Add-In File"),
	XLSB("xlsb", "application/vnd.ms-excel.sheet.binary.macroenabled.12", "Microsoft Excel - Binary Workbook"),
	XLTM("xltm", "application/vnd.ms-excel.template.macroenabled.12", "Microsoft Excel - Macro-Enabled Template File"),
	XLSM("xlsm", "application/vnd.ms-excel.sheet.macroenabled.12", "Microsoft Excel - Macro-Enabled Workbook"),
	CHM("chm", "application/vnd.ms-htmlhelp", "Microsoft Html Help File"),
	CRD("crd", "application/x-mscardfile", "Microsoft Information Card"),
	LRM("lrm", "application/vnd.ms-lrm", "Microsoft Learning Resource Module"),
	MVB("mvb", "application/x-msmediaview", "Microsoft MediaView"),
	MNY("mny", "application/x-msmoney", "Microsoft Money"),
	PPTX("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "Microsoft Office - OOXML - Presentation"),
	SLDX("sldx", "application/vnd.openxmlformats-officedocument.presentationml.slide", "Microsoft Office - OOXML - Presentation (Slide)"),
	PPSX("ppsx", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "Microsoft Office - OOXML - Presentation (Slideshow)"),
	POTX("potx", "application/vnd.openxmlformats-officedocument.presentationml.template", "Microsoft Office - OOXML - Presentation Template"),
	XLSX("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "Microsoft Office - OOXML - Spreadsheet"),
	XLTX("xltx", "application/vnd.openxmlformats-officedocument.spreadsheetml.template", "Microsoft Office - OOXML - Spreadsheet Template"),
	DOCX("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "Microsoft Office - OOXML - Word Document"),
	DOTX("dotx", "application/vnd.openxmlformats-officedocument.wordprocessingml.template", "Microsoft Office - OOXML - Word Document Template"),
	OBD("obd", "application/x-msbinder", "Microsoft Office Binder"),
	THMX("thmx", "application/vnd.ms-officetheme", "Microsoft Office System Release Theme"),
	ONETOC("onetoc", "application/onenote", "Microsoft OneNote"),
	PYA("pya", "audio/vnd.ms-playready.media.pya", "Microsoft PlayReady Ecosystem"),
	PYV("pyv", "video/vnd.ms-playready.media.pyv", "Microsoft PlayReady Ecosystem Video"),
	PPT("ppt", "application/vnd.ms-powerpoint", "Microsoft PowerPoint"),
	PPAM("ppam", "application/vnd.ms-powerpoint.addin.macroenabled.12", "Microsoft PowerPoint - Add-in file"),
	SLDM("sldm", "application/vnd.ms-powerpoint.slide.macroenabled.12", "Microsoft PowerPoint - Macro-Enabled Open XML Slide"),
	PPTM("pptm", "application/vnd.ms-powerpoint.presentation.macroenabled.12", "Microsoft PowerPoint - Macro-Enabled Presentation File"),
	PPSM("ppsm", "application/vnd.ms-powerpoint.slideshow.macroenabled.12", "Microsoft PowerPoint - Macro-Enabled Slide Show File"),
	POTM("potm", "application/vnd.ms-powerpoint.template.macroenabled.12", "Microsoft PowerPoint - Macro-Enabled Template File"),
	MPP("mpp", "application/vnd.ms-project", "Microsoft Project"),
	PUB("pub", "application/x-mspublisher", "Microsoft Publisher"),
	SCD("scd", "application/x-msschedule", "Microsoft Schedule+"),
	XAP("xap", "application/x-silverlight-app", "Microsoft Silverlight"),
	STL("stl", "application/vnd.ms-pki.stl", "Microsoft Trust UI Provider - Certificate Trust Link"),
	CAT("cat", "application/vnd.ms-pki.seccat", "Microsoft Trust UI Provider - Security Catalog"),
	VSD("vsd", "application/vnd.visio", "Microsoft Visio"),
	VSDX("vsdx", "application/vnd.visio2013", "Microsoft Visio 2013"),
	WM("wm", "video/x-ms-wm", "Microsoft Windows Media"),
	WMA("wma", "audio/x-ms-wma", "Microsoft Windows Media Audio"),
	WAX("wax", "audio/x-ms-wax", "Microsoft Windows Media Audio Redirector"),
	WMX("wmx", "video/x-ms-wmx", "Microsoft Windows Media Audio/Video Playlist"),
	WMD("wmd", "application/x-ms-wmd", "Microsoft Windows Media Player Download Package"),
	WPL("wpl", "application/vnd.ms-wpl", "Microsoft Windows Media Player Playlist"),
	WMZ("wmz", "application/x-ms-wmz", "Microsoft Windows Media Player Skin Package"),
	WMV("wmv", "video/x-ms-wmv", "Microsoft Windows Media Video"),
	WVX("wvx", "video/x-ms-wvx", "Microsoft Windows Media Video Playlist"),
	WMF("wmf", "application/x-msmetafile", "Microsoft Windows Metafile"),
	TRM("trm", "application/x-msterminal", "Microsoft Windows Terminal Services"),
	DOC("doc", "application/msword", "Microsoft Word"),
	DOCM("docm", "application/vnd.ms-word.document.macroenabled.12", "Microsoft Word - Macro-Enabled Document"),
	DOTM("dotm", "application/vnd.ms-word.template.macroenabled.12", "Microsoft Word - Macro-Enabled Template"),
	WRI("wri", "application/x-mswrite", "Microsoft Wordpad"),
	WPS("wps", "application/vnd.ms-works", "Microsoft Works"),
	XBAP("xbap", "application/x-ms-xbap", "Microsoft XAML Browser Application"),
	XPS("xps", "application/vnd.ms-xpsdocument", "Microsoft XML Paper Specification"),
	MIDI("midi", "audio/midi", "MIDI"),
	MID("mid", "audio/midi", "MIDI - Musical Instrument Digital Interface"),
	MPY("mpy", "application/vnd.ibm.minipay", "MiniPay"),
	AFP("afp", "application/vnd.ibm.modcap", "MO:DCA-P"),
	RMS("rms", "application/vnd.jcp.javame.midlet-rms", "Mobile Information Device Profile"),
	TMO("tmo", "application/vnd.tmobile-livetv", "MobileTV"),
	PRC("prc", "application/x-mobipocket-ebook", "Mobipocket"),
	MBK("mbk", "application/vnd.mobius.mbk", "Mobius Management Systems - Basket file"),
	DIS("dis", "application/vnd.mobius.dis", "Mobius Management Systems - Distribution Database"),
	PLC("plc", "application/vnd.mobius.plc", "Mobius Management Systems - Policy Definition Language File"),
	MQY("mqy", "application/vnd.mobius.mqy", "Mobius Management Systems - Query File"),
	MSL("msl", "application/vnd.mobius.msl", "Mobius Management Systems - Script Language"),
	TXF("txf", "application/vnd.mobius.txf", "Mobius Management Systems - Topic Index File"),
	DAF("daf", "application/vnd.mobius.daf", "Mobius Management Systems - UniversalArchive"),
	FLY("fly", "text/vnd.fly", "mod_fly / fly.cgi"),
	MPC("mpc", "application/vnd.mophun.certificate", "Mophun Certificate"),
	MPN("mpn", "application/vnd.mophun.application", "Mophun VM"),
	MJ2("mj2", "video/mj2", "Motion JPEG 2000"),
	MPGA("mpga", "audio/mpeg", "MPEG Audio"),
	TS("ts", "video/mp2t", "MPEG Transport Stream"),
	MXU("mxu", "video/vnd.mpegurl", "MPEG Url"),
	MPEG("mpeg", "video/mpeg", "MPEG Video"),
	M21("m21", "application/mp21", "MPEG-21"),
	MP4A("mp4a", "audio/mp4", "MPEG-4 Audio"),
	MP4("mp4", "video/mp4", "MPEG-4 Video"),
	MP4_("mp4", "application/mp4", "MPEG4"),
	M3U8("m3u8", "application/vnd.apple.mpegurl", "Multimedia Playlist Unicode"),
	MUS("mus", "application/vnd.musician", "MUsical Score Interpreted Code Invented for the ASCII designation of Notation"),
	MSTY("msty", "application/vnd.muvee.style", "Muvee Automatic Video Editing"),
	MXML("mxml", "application/xv+xml", "MXML"),
	NGDAT("ngdat", "application/vnd.nokia.n-gage.data", "N-Gage Game Data"),
	N_GAGE("n-gage", "application/vnd.nokia.n-gage.symbian.install", "N-Gage Game Installer"),
	NCX("ncx", "application/x-dtbncx+xml", "Navigation Control file for XML (for ePub)"),
	NC("nc", "application/x-netcdf", "Network Common Data Form (NetCDF)"),
	NLU("nlu", "application/vnd.neurolanguage.nlu", "neuroLanguage"),
	DNA("dna", "application/vnd.dna", "New Moon Liftoff/DNA"),
	NND("nnd", "application/vnd.noblenet-directory", "NobleNet Directory"),
	NNS("nns", "application/vnd.noblenet-sealer", "NobleNet Sealer"),
	NNW("nnw", "application/vnd.noblenet-web", "NobleNet Web"),
	RPST("rpst", "application/vnd.nokia.radio-preset", "Nokia Radio Application - Preset"),
	RPSS("rpss", "application/vnd.nokia.radio-presets", "Nokia Radio Application - Preset"),
	N3("n3", "text/n3", "Notation3"),
	EDM("edm", "application/vnd.novadigm.edm", "Novadigm's RADIA and EDM products"),
	EDX("edx", "application/vnd.novadigm.edx", "Novadigm's RADIA and EDM products"),
	EXT("ext", "application/vnd.novadigm.ext", "Novadigm's RADIA and EDM products"),
	GPH("gph", "application/vnd.flographit", "NpGraphIt"),
	ECELP4800("ecelp4800", "audio/vnd.nuera.ecelp4800", "Nuera ECELP 4800"),
	ECELP7470("ecelp7470", "audio/vnd.nuera.ecelp7470", "Nuera ECELP 7470"),
	ECELP9600("ecelp9600", "audio/vnd.nuera.ecelp9600", "Nuera ECELP 9600"),
	ODA("oda", "application/oda", "Office Document Architecture"),
	OGX("ogx", "application/ogg", "Ogg"),
	OGA("oga", "audio/ogg", "Ogg Audio"),
	OGV("ogv", "video/ogg", "Ogg Video"),
	DD2("dd2", "application/vnd.oma.dd2+xml", "OMA Download Agents"),
	OTH("oth", "application/vnd.oasis.opendocument.text-web", "Open Document Text Web"),
	OPF("opf", "application/oebps-package+xml", "Open eBook Publication Structure"),
	QBO("qbo", "application/vnd.intu.qbo", "Open Financial Exchange"),
	OXT("oxt", "application/vnd.openofficeorg.extension", "Open Office Extension"),
	OSF("osf", "application/vnd.yamaha.openscoreformat", "Open Score Format"),
	WEBA("weba", "audio/webm", "Open Web Media Project - Audio"),
	WEBM("webm", "video/webm", "Open Web Media Project - Video"),
	ODC("odc", "application/vnd.oasis.opendocument.chart", "OpenDocument Chart"),
	OTC("otc", "application/vnd.oasis.opendocument.chart-template", "OpenDocument Chart Template"),
	ODB("odb", "application/vnd.oasis.opendocument.database", "OpenDocument Database"),
	ODF("odf", "application/vnd.oasis.opendocument.formula", "OpenDocument Formula"),
	ODFT("odft", "application/vnd.oasis.opendocument.formula-template", "OpenDocument Formula Template"),
	ODG("odg", "application/vnd.oasis.opendocument.graphics", "OpenDocument Graphics"),
	OTG("otg", "application/vnd.oasis.opendocument.graphics-template", "OpenDocument Graphics Template"),
	ODI("odi", "application/vnd.oasis.opendocument.image", "OpenDocument Image"),
	OTI("oti", "application/vnd.oasis.opendocument.image-template", "OpenDocument Image Template"),
	ODP("odp", "application/vnd.oasis.opendocument.presentation", "OpenDocument Presentation"),
	OTP("otp", "application/vnd.oasis.opendocument.presentation-template", "OpenDocument Presentation Template"),
	ODS("ods", "application/vnd.oasis.opendocument.spreadsheet", "OpenDocument Spreadsheet"),
	OTS("ots", "application/vnd.oasis.opendocument.spreadsheet-template", "OpenDocument Spreadsheet Template"),
	ODT("odt", "application/vnd.oasis.opendocument.text", "OpenDocument Text"),
	ODM("odm", "application/vnd.oasis.opendocument.text-master", "OpenDocument Text Master"),
	OTT("ott", "application/vnd.oasis.opendocument.text-template", "OpenDocument Text Template"),
	KTX("ktx", "image/ktx", "OpenGL Textures (KTX)"),
	SXC("sxc", "application/vnd.sun.xml.calc", "OpenOffice - Calc (Spreadsheet)"),
	STC("stc", "application/vnd.sun.xml.calc.template", "OpenOffice - Calc Template (Spreadsheet)"),
	SXD("sxd", "application/vnd.sun.xml.draw", "OpenOffice - Draw (Graphics)"),
	STD("std", "application/vnd.sun.xml.draw.template", "OpenOffice - Draw Template (Graphics)"),
	SXI("sxi", "application/vnd.sun.xml.impress", "OpenOffice - Impress (Presentation)"),
	STI("sti", "application/vnd.sun.xml.impress.template", "OpenOffice - Impress Template (Presentation)"),
	SXM("sxm", "application/vnd.sun.xml.math", "OpenOffice - Math (Formula)"),
	SXW("sxw", "application/vnd.sun.xml.writer", "OpenOffice - Writer (Text - HTML)"),
	SXG("sxg", "application/vnd.sun.xml.writer.global", "OpenOffice - Writer (Text - HTML)"),
	STW("stw", "application/vnd.sun.xml.writer.template", "OpenOffice - Writer Template (Text - HTML)"),
	OTF("otf", "application/x-font-otf", "OpenType Font File"),
	OPUS("opus", "audio/opus", "Opus Audio"),
	OSFPVG("osfpvg", "application/vnd.yamaha.openscoreformat.osfpvg+xml", "OSFPVG"),
	DP("dp", "application/vnd.osgi.dp", "OSGi Deployment Package"),
	PDB("pdb", "application/vnd.palm", "PalmOS Data"),
	P("p", "text/x-pascal", "Pascal Source File"),
	PAW("paw", "application/vnd.pawaafile", "PawaaFILE"),
	PCLXL("pclxl", "application/vnd.hp-pclxl", "PCL 6 Enhanced (Formely PCL XL)"),
	EFIF("efif", "application/vnd.picsel", "Pcsel eFIF File"),
	PCX("pcx", "image/x-pcx", "PCX Image"),
	PSD("psd", "image/vnd.adobe.photoshop", "Photoshop Document"),
	PRF("prf", "application/pics-rules", "PICSRules"),
	PIC("pic", "image/x-pict", "PICT Image"),
	CHAT("chat", "application/x-chat", "pIRCh"),
	P10("p10", "application/pkcs10", "PKCS #10 - Certification Request Standard"),
	P12("p12", "application/x-pkcs12", "PKCS #12 - Personal Information Exchange Syntax Standard"),
	P7M("p7m", "application/pkcs7-mime", "PKCS #7 - Cryptographic Message Syntax Standard"),
	P7S("p7s", "application/pkcs7-signature", "PKCS #7 - Cryptographic Message Syntax Standard"),
	P7R("p7r", "application/x-pkcs7-certreqresp", "PKCS #7 - Cryptographic Message Syntax Standard (Certificate Request Response)"),
	P7B("p7b", "application/x-pkcs7-certificates", "PKCS #7 - Cryptographic Message Syntax Standard (Certificates)"),
	P8("p8", "application/pkcs8", "PKCS #8 - Private-Key Information Syntax Standard"),
	PLF("plf", "application/vnd.pocketlearn", "PocketLearn Viewers"),
	PNM("pnm", "image/x-portable-anymap", "Portable Anymap Image"),
	PBM("pbm", "image/x-portable-bitmap", "Portable Bitmap Format"),
	PCF("pcf", "application/x-font-pcf", "Portable Compiled Format"),
	PFR("pfr", "application/font-tdpfr", "Portable Font Resource"),
	PGN("pgn", "application/x-chess-pgn", "Portable Game Notation (Chess Games)"),
	PGM("pgm", "image/x-portable-graymap", "Portable Graymap Format"),
	PNG("png", "image/png", "Portable Network Graphics (PNG)"),
	PNG_("png", "image/x-png", "Portable Network Graphics (PNG) (x-token)"),
	PPM("ppm", "image/x-portable-pixmap", "Portable Pixmap Format"),
	PSKCXML("pskcxml", "application/pskc+xml", "Portable Symmetric Key Container"),
	PML("pml", "application/vnd.ctc-posml", "PosML"),
	AI("ai", "application/postscript", "PostScript"),
	PFA("pfa", "application/x-font-type1", "PostScript Fonts"),
	PBD("pbd", "application/vnd.powerbuilder6", "PowerBuilder"),
	PGP("pgp", "application/pgp-encrypted", "Pretty Good Privacy"),
	BOX("box", "application/vnd.previewsystems.box", "Preview Systems ZipLock/VBox"),
	PTID("ptid", "application/vnd.pvi.ptid1", "Princeton Video Image"),
	PLS("pls", "application/pls+xml", "Pronunciation Lexicon Specification"),
	STR("str", "application/vnd.pg.format", "Proprietary P&G Standard Reporting System"),
	EI6("ei6", "application/vnd.pg.osasli", "Proprietary P&G Standard Reporting System"),
	DSC("dsc", "text/prs.lines.tag", "PRS Lines Tag"),
	PSF("psf", "application/x-font-linux-psf", "PSF Fonts"),
	QPS("qps", "application/vnd.publishare-delta-tree", "PubliShare Objects"),
	WG("wg", "application/vnd.pmi.widget", "Qualcomm's Plaza Mobile Internet"),
	QXD("qxd", "application/vnd.quark.quarkxpress", "QuarkXpress"),
	ESF("esf", "application/vnd.epson.esf", "QUASS Stream Player"),
	MSF("msf", "application/vnd.epson.msf", "QUASS Stream Player"),
	SSF("ssf", "application/vnd.epson.ssf", "QUASS Stream Player"),
	QAM("qam", "application/vnd.epson.quickanime", "QuickAnime Player"),
	QFX("qfx", "application/vnd.intu.qfx", "Quicken"),
	QT("qt", "video/quicktime", "Quicktime Video"),
	RAR("rar", "application/x-rar-compressed", "RAR Archive"),
	RAM("ram", "audio/x-pn-realaudio", "Real Audio Sound"),
	RMP("rmp", "audio/x-pn-realaudio-plugin", "Real Audio Sound"),
	RSD("rsd", "application/rsd+xml", "Really Simple Discovery"),
	RM("rm", "application/vnd.rn-realmedia", "RealMedia"),
	BED("bed", "application/vnd.realvnc.bed", "RealVNC"),
	MXL("mxl", "application/vnd.recordare.musicxml", "Recordare Applications"),
	MUSICXML("musicxml", "application/vnd.recordare.musicxml+xml", "Recordare Applications"),
	RNC("rnc", "application/relax-ng-compact-syntax", "Relax NG Compact Syntax"),
	RDZ("rdz", "application/vnd.data-vision.rdz", "RemoteDocs R-Viewer"),
	RDF("rdf", "application/rdf+xml", "Resource Description Framework"),
	RP9("rp9", "application/vnd.cloanto.rp9", "RetroPlatform Player"),
	JISP("jisp", "application/vnd.jisp", "RhymBox"),
	RTF("rtf", "application/rtf", "Rich Text Format"),
	RTX("rtx", "text/richtext", "Rich Text Format (RTF)"),
	LINK66("link66", "application/vnd.route66.link66+xml", "ROUTE 66 Location Based Services"),
	RSS_XML("rss", "application/rss+xml", "RSS - Really Simple Syndication"),
	SHF("shf", "application/shf+xml", "S Hexdump Format"),
	ST("st", "application/vnd.sailingtracker.track", "SailingTracker"),
	SVG("svg", "image/svg+xml", "Scalable Vector Graphics (SVG)"),
	SUS("sus", "application/vnd.sus-calendar", "ScheduleUs"),
	SRU("sru", "application/sru+xml", "Search/Retrieve via URL Response Format"),
	SETPAY("setpay", "application/set-payment-initiation", "Secure Electronic Transaction - Payment"),
	SETREG("setreg", "application/set-registration-initiation", "Secure Electronic Transaction - Registration"),
	SEMA("sema", "application/vnd.sema", "Secured eMail"),
	SEMD("semd", "application/vnd.semd", "Secured eMail"),
	SEMF("semf", "application/vnd.semf", "Secured eMail"),
	SEE("see", "application/vnd.seemail", "SeeMail"),
	SNF("snf", "application/x-font-snf", "Server Normal Format"),
	SPQ("spq", "application/scvp-vp-request", "Server-Based Certificate Validation Protocol - Validation Policies - Request"),
	SPP("spp", "application/scvp-vp-response", "Server-Based Certificate Validation Protocol - Validation Policies - Response"),
	SCQ("scq", "application/scvp-cv-request", "Server-Based Certificate Validation Protocol - Validation Request"),
	SCS("scs", "application/scvp-cv-response", "Server-Based Certificate Validation Protocol - Validation Response"),
	SDP("sdp", "application/sdp", "Session Description Protocol"),
	ETX("etx", "text/x-setext", "Setext"),
	MOVIE("movie", "video/x-sgi-movie", "SGI Movie"),
	IFM("ifm", "application/vnd.shana.informed.formdata", "Shana Informed Filler"),
	ITP("itp", "application/vnd.shana.informed.formtemplate", "Shana Informed Filler"),
	IIF("iif", "application/vnd.shana.informed.interchange", "Shana Informed Filler"),
	IPK("ipk", "application/vnd.shana.informed.package", "Shana Informed Filler"),
	TFI("tfi", "application/thraud+xml", "Sharing Transaction Fraud Data"),
	SHAR("shar", "application/x-shar", "Shell Archive"),
	RGB("rgb", "image/x-rgb", "Silicon Graphics RGB Bitmap"),
	SLT("slt", "application/vnd.epson.salt", "SimpleAnimeLite Player"),
	ASO("aso", "application/vnd.accpac.simply.aso", "Simply Accounting"),
	IMP("imp", "application/vnd.accpac.simply.imp", "Simply Accounting - Data Import"),
	TWD("twd", "application/vnd.simtech-mindmapper", "SimTech MindMapper"),
	CSP("csp", "application/vnd.commonspace", "Sixth Floor Media - CommonSpace"),
	SAF("saf", "application/vnd.yamaha.smaf-audio", "SMAF Audio"),
	MMF("mmf", "application/vnd.smaf", "SMAF File"),
	SPF("spf", "application/vnd.yamaha.smaf-phrase", "SMAF Phrase"),
	TEACHER("teacher", "application/vnd.smart.teacher", "SMART Technologies Apps"),
	SVD("svd", "application/vnd.svd", "SourceView Document"),
	RQ("rq", "application/sparql-query", "SPARQL - Query"),
	SRX("srx", "application/sparql-results+xml", "SPARQL - Results"),
	GRAM("gram", "application/srgs", "Speech Recognition Grammar Specification"),
	GRXML("grxml", "application/srgs+xml", "Speech Recognition Grammar Specification - XML"),
	SSML("ssml", "application/ssml+xml", "Speech Synthesis Markup Language"),
	SKP("skp", "application/vnd.koan", "SSEYO Koan Play File"),
	SGML("sgml", "text/sgml", "Standard Generalized Markup Language (SGML)"),
	SDC("sdc", "application/vnd.stardivision.calc", "StarOffice - Calc"),
	SDA("sda", "application/vnd.stardivision.draw", "StarOffice - Draw"),
	SDD("sdd", "application/vnd.stardivision.impress", "StarOffice - Impress"),
	SMF("smf", "application/vnd.stardivision.math", "StarOffice - Math"),
	SDW("sdw", "application/vnd.stardivision.writer", "StarOffice - Writer"),
	SGL("sgl", "application/vnd.stardivision.writer-global", "StarOffice - Writer (Global)"),
	SM("sm", "application/vnd.stepmania.stepchart", "StepMania"),
	SIT("sit", "application/x-stuffit", "Stuffit Archive"),
	SITX("sitx", "application/x-stuffitx", "Stuffit Archive"),
	SDKM("sdkm", "application/vnd.solent.sdkm+xml", "SudokuMagic"),
	XO("xo", "application/vnd.olpc-sugar", "Sugar Linux Application Bundle"),
	AU("au", "audio/basic", "Sun Audio - Au file format"),
	WQD("wqd", "application/vnd.wqd", "SundaHus WQ"),
	SIS("sis", "application/vnd.symbian.install", "Symbian Install Package"),
	SMI("smi", "application/smil+xml", "Synchronized Multimedia Integration Language"),
	XSM("xsm", "application/vnd.syncml+xml", "SyncML"),
	BDM("bdm", "application/vnd.syncml.dm+wbxml", "SyncML - Device Management"),
	XDM("xdm", "application/vnd.syncml.dm+xml", "SyncML - Device Management"),
	SV4CPIO("sv4cpio", "application/x-sv4cpio", "System V Release 4 CPIO Archive"),
	SV4CRC("sv4crc", "application/x-sv4crc", "System V Release 4 CPIO Checksum Data"),
	SBML("sbml", "application/sbml+xml", "Systems Biology Markup Language"),
	TSV("tsv", "text/tab-separated-values", "Tab Seperated Values"),
	TIFF("tiff", "image/tiff", "Tagged Image File Format"),
	TAO("tao", "application/vnd.tao.intent-module-archive", "Tao Intent"),
	TAR("tar", "application/x-tar", "Tar File (Tape Archive)"),
	TCL("tcl", "application/x-tcl", "Tcl Script"),
	TEX("tex", "application/x-tex", "TeX"),
	TFM("tfm", "application/x-tex-tfm", "TeX Font Metric"),
	TEI("tei", "application/tei+xml", "Text Encoding and Interchange"),
	TXT("txt", "text/plain", "Text File"),
	DXP("dxp", "application/vnd.spotfire.dxp", "TIBCO Spotfire"),
	SFS("sfs", "application/vnd.spotfire.sfs", "TIBCO Spotfire"),
	TSD("tsd", "application/timestamped-data", "Time Stamped Data Envelope"),
	TPT("tpt", "application/vnd.trid.tpt", "TRI Systems Config"),
	MXS("mxs", "application/vnd.triscape.mxs", "Triscape Map Explorer"),
	T("t", "text/troff", "troff"),
	TRA("tra", "application/vnd.trueapp", "True BASIC"),
	TTF("ttf", "application/x-font-ttf", "TrueType Font"),
	TTL("ttl", "text/turtle", "Turtle (Terse RDF Triple Language)"),
	UMJ("umj", "application/vnd.umajin", "UMAJIN"),
	UOML("uoml", "application/vnd.uoml+xml", "Unique Object Markup Language"),
	UNITYWEB("unityweb", "application/vnd.unity", "Unity 3d"),
	UFD("ufd", "application/vnd.ufdl", "Universal Forms Description Language"),
	URI("uri", "text/uri-list", "URI Resolution Services"),
	UTZ("utz", "application/vnd.uiq.theme", "User Interface Quartz - Theme (Symbian)"),
	USTAR("ustar", "application/x-ustar", "Ustar (Uniform Standard Tape Archive)"),
	UU("uu", "text/x-uuencode", "UUEncode"),
	VCS("vcs", "text/x-vcalendar", "vCalendar"),
	VCF("vcf", "text/x-vcard", "vCard"),
	VCD("vcd", "application/x-cdlink", "Video CD"),
	VSF("vsf", "application/vnd.vsf", "Viewport+"),
	WRL("wrl", "model/vrml", "Virtual Reality Modeling Language"),
	VCX("vcx", "application/vnd.vcx", "VirtualCatalog"),
	MTS("mts", "model/vnd.mts", "Virtue MTS"),
	VTU("vtu", "model/vnd.vtu", "Virtue VTU"),
	VIS("vis", "application/vnd.visionary", "Visionary"),
	VIV("viv", "video/vnd.vivo", "Vivo"),
	CCXML("ccxml", "application/ccxml+xml,", "Voice Browser Call Control"),
	VXML("vxml", "application/voicexml+xml", "VoiceXML"),
	SRC("src", "application/x-wais-source", "WAIS Source"),
	WBXML("wbxml", "application/vnd.wap.wbxml", "WAP Binary XML (WBXML)"),
	WBMP("wbmp", "image/vnd.wap.wbmp", "WAP Bitamp (WBMP)"),
	WAV("wav", "audio/x-wav", "Waveform Audio File Format (WAV)"),
	DAVMOUNT("davmount", "application/davmount+xml", "Web Distributed Authoring and Versioning"),
	WOFF("woff", "application/x-font-woff", "Web Open Font Format"),
	WSPOLICY("wspolicy", "application/wspolicy+xml", "Web Services Policy"),
	WEBP("webp", "image/webp", "WebP Image"),
	WTB("wtb", "application/vnd.webturbo", "WebTurbo"),
	WGT("wgt", "application/widget", "Widget Packaging and XML Configuration"),
	HLP("hlp", "application/winhlp", "WinHelp"),
	WML("wml", "text/vnd.wap.wml", "Wireless Markup Language (WML)"),
	WMLS("wmls", "text/vnd.wap.wmlscript", "Wireless Markup Language Script (WMLScript)"),
	WMLSC("wmlsc", "application/vnd.wap.wmlscriptc", "WMLScript"),
	WPD("wpd", "application/vnd.wordperfect", "Wordperfect"),
	STF("stf", "application/vnd.wt.stf", "Worldtalk"),
	WSDL("wsdl", "application/wsdl+xml", "WSDL - Web Services Description Language"),
	XBM("xbm", "image/x-xbitmap", "X BitMap"),
	XPM("xpm", "image/x-xpixmap", "X PixMap"),
	XWD("xwd", "image/x-xwindowdump", "X Window Dump"),
	DER("der", "application/x-x509-ca-cert", "X.509 Certificate"),
	FIG("fig", "application/x-xfig", "Xfig"),
	XHTML("xhtml", "application/xhtml+xml", "XHTML - The Extensible HyperText Markup Language"),
	XML("xml", "application/xml", "XML - Extensible Markup Language"),
	XDF("xdf", "application/xcap-diff+xml", "XML Configuration Access Protocol - XCAP Diff"),
	XENC("xenc", "application/xenc+xml", "XML Encryption Syntax and Processing"),
	XER("xer", "application/patch-ops-error+xml", "XML Patch Framework"),
	RL("rl", "application/resource-lists+xml", "XML Resource Lists"),
	RS("rs", "application/rls-services+xml", "XML Resource Lists"),
	RLD("rld", "application/resource-lists-diff+xml", "XML Resource Lists Diff"),
	XSLT("xslt", "application/xslt+xml", "XML Transformations"),
	XOP("xop", "application/xop+xml", "XML-Binary Optimized Packaging"),
	XPI("xpi", "application/x-xpinstall", "XPInstall - Mozilla"),
	XSPF("xspf", "application/xspf+xml", "XSPF - XML Shareable Playlist Format"),
	XUL("xul", "application/vnd.mozilla.xul+xml", "XUL - XML User Interface Language"),
	XYZ("xyz", "chemical/x-xyz", "XYZ File Format"),
	YAML("yaml", "text/yaml", "YAML Ain't Markup Language / Yet Another Markup Language"),
	YANG("yang", "application/yang", "YANG Data Modeling Language"),
	YIN("yin", "application/yin+xml", "YIN (YANG - XML)"),
	ZIR("zir", "application/vnd.zul", "Z.U.L. Geometry"),
	ZIP("zip", "application/zip", "Zip Archive"),
	ZMM("zmm", "application/vnd.handheld-entertainment+xml", "ZVUE Media Manager"),
	ZAZ("zaz", "application/vnd.zzazz.deck+xml", "Zzazz Deck"),
	;

	private final String extension;
	private final String mimeType;
	private final String description;

	private static Map<String, MimeType> byExtension;
	private static Map<String, MimeType> byMimeType;

	static {
		byExtension = new HashMap<>();
		byMimeType = new HashMap<>();
		for (MimeType type : values()) {
			byExtension.put(type.getExtension(), type);
			byMimeType.put(type.getMimeType(), type);
		}
	}

	public static MimeType getMimeType(String fileName) {
		if (fileName == null || !fileName.contains(".")) {
			return null;
		} else {
			String extension = fileName.contains(".") ? fileName.substring(fileName.lastIndexOf('.') + 1).toLowerCase() : fileName.toLowerCase();
			return byExtension.get(extension);
		}
	}

	public static String getMimeTypeString(String fileName) {
		MimeType type = getMimeType(fileName);
		return type != null ? type.getMimeType() : null;
	}

	public static MimeType getMimeTypeByMime(String mimeType) {
		return byMimeType.get(mimeType);
	}

	MimeType(String extension, String mimeType, String description) {
		this.extension = extension;
		this.mimeType = mimeType;
		this.description = description;
	}

	public String getExtension() {
		return extension;
	}

	public String getMimeType() {
		return mimeType;
	}

	public String getDescription() {
		return description;
	}
}
