/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.bool;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.AbstractIndex;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.bool.BooleanFilter;
import org.teamapps.universaldb.index.buffer.index.RecordIndex;
import org.teamapps.universaldb.model.FieldModel;

public class BooleanIndex
extends AbstractIndex<Boolean, BooleanFilter> {
    private RecordIndex recordIndex;

    public BooleanIndex(FieldModel fieldModel, TableIndex tableIndex) {
        super(fieldModel, tableIndex);
        this.recordIndex = new RecordIndex(tableIndex.getDataPath(), fieldModel.getName());
    }

    @Override
    public IndexType getType() {
        return IndexType.BOOLEAN;
    }

    @Override
    public Boolean getGenericValue(int id) {
        return this.getValue(id);
    }

    @Override
    public boolean isEmpty(int id) {
        return !this.getValue(id);
    }

    @Override
    public void setGenericValue(int id, Boolean value) {
        this.setValue(id, value);
    }

    @Override
    public void removeValue(int id) {
        this.setValue(id, false);
    }

    @Override
    public void close() {
        this.recordIndex.close();
    }

    @Override
    public void drop() {
        this.recordIndex.drop();
    }

    @Override
    public BitSet filter(BitSet records, BooleanFilter booleanFilter) {
        if (booleanFilter.getFilterValue()) {
            return this.filterEquals(records, true);
        }
        return this.filterEquals(records, false);
    }

    public boolean getValue(int id) {
        return this.recordIndex.getBoolean(id);
    }

    public void setValue(int id, boolean value) {
        this.recordIndex.setBoolean(id, value);
    }

    @Override
    public List<SortEntry> sortRecords(List<SortEntry> sortEntries, boolean ascending, UserContext userContext) {
        int order = ascending ? 1 : -1;
        sortEntries.sort((o1, o2) -> {
            boolean value1 = this.getValue(o1.getLeafId());
            boolean value2 = this.getValue(o2.getLeafId());
            return Boolean.compare(value1, value2) * order;
        });
        return sortEntries;
    }

    @Override
    public void dumpIndex(DataOutputStream dataOutputStream, BitSet records) throws IOException {
        int id = records.nextSetBit(0);
        while (id >= 0) {
            boolean value = this.getValue(id);
            dataOutputStream.writeInt(id);
            dataOutputStream.writeBoolean(value);
            id = records.nextSetBit(id + 1);
        }
    }

    @Override
    public void restoreIndex(DataInputStream dataInputStream) throws IOException {
        try {
            int id = dataInputStream.readInt();
            boolean value = dataInputStream.readBoolean();
            this.setValue(id, value);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public BitSet filterEquals(BitSet bitSet, boolean compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            boolean value = this.getValue(id);
            if (value == compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterNotEquals(BitSet bitSet, boolean compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            boolean value = this.getValue(id);
            if (value != compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public int getCount() {
        return this.recordIndex.getCount();
    }

    public BitSet getBitSet() {
        return this.recordIndex.getBitSet();
    }

    public List<Integer> getRecords() {
        return this.recordIndex.getRecords();
    }

    public int getMaxId() {
        return this.recordIndex.getMaxId();
    }
}

