/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.reference.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teamapps.universaldb.index.reference.CyclicReferenceUpdate;
import org.teamapps.universaldb.index.reference.value.ResolvedMultiReferenceType;

public class ResolvedMultiReferenceUpdate {
    private final ResolvedMultiReferenceType type;
    private final List<Integer> setReferences;
    private final List<Integer> addReferences;
    private final List<Integer> removeReferences;

    public static ResolvedMultiReferenceUpdate createRemoveAllReferences() {
        return new ResolvedMultiReferenceUpdate(ResolvedMultiReferenceType.REMOVE_ALL_REFERENCES, null, null, null);
    }

    public static ResolvedMultiReferenceUpdate createSetReferences(List<Integer> setReferences) {
        return new ResolvedMultiReferenceUpdate(ResolvedMultiReferenceType.SET_REFERENCES, setReferences, null, null);
    }

    public static ResolvedMultiReferenceUpdate createAddRemoveReferences(List<Integer> addReferences, List<Integer> removeReferences) {
        return new ResolvedMultiReferenceUpdate(ResolvedMultiReferenceType.ADD_REMOVE_REFERENCES, null, addReferences, removeReferences);
    }

    public static ResolvedMultiReferenceUpdate createAddRemoveReferences(CyclicReferenceUpdate referenceUpdate) {
        List<Integer> addReferences = referenceUpdate.isRemoveReference() ? Collections.emptyList() : Collections.singletonList(referenceUpdate.getReferencedRecordId());
        List<Integer> removeReferences = referenceUpdate.isRemoveReference() ? Collections.singletonList(referenceUpdate.getReferencedRecordId()) : Collections.emptyList();
        return new ResolvedMultiReferenceUpdate(ResolvedMultiReferenceType.ADD_REMOVE_REFERENCES, null, addReferences, removeReferences);
    }

    private ResolvedMultiReferenceUpdate(ResolvedMultiReferenceType type, List<Integer> setReferences, List<Integer> addReferences, List<Integer> removeReferences) {
        this.type = type;
        this.setReferences = setReferences;
        this.addReferences = addReferences;
        this.removeReferences = removeReferences;
    }

    public ResolvedMultiReferenceUpdate(DataInputStream dis) throws IOException {
        this.type = ResolvedMultiReferenceType.getById(dis.readByte());
        if (this.type == ResolvedMultiReferenceType.SET_REFERENCES) {
            this.setReferences = new ArrayList<Integer>();
            this.addReferences = null;
            this.removeReferences = null;
            int count = dis.readInt();
            for (int i = 0; i < count; ++i) {
                this.setReferences.add(dis.readInt());
            }
        } else if (this.type == ResolvedMultiReferenceType.ADD_REMOVE_REFERENCES) {
            this.setReferences = null;
            this.addReferences = new ArrayList<Integer>();
            this.removeReferences = new ArrayList<Integer>();
            int countAdd = dis.readInt();
            for (int i = 0; i < countAdd; ++i) {
                this.addReferences.add(dis.readInt());
            }
            int countRemove = dis.readInt();
            for (int i = 0; i < countRemove; ++i) {
                this.removeReferences.add(dis.readInt());
            }
        } else {
            this.setReferences = null;
            this.addReferences = null;
            this.removeReferences = null;
        }
    }

    public void write(DataOutputStream dos) throws IOException {
        block4: {
            block3: {
                dos.writeByte(this.type.getId());
                if (this.type != ResolvedMultiReferenceType.SET_REFERENCES) break block3;
                dos.writeInt(this.setReferences.size());
                for (Integer id : this.setReferences) {
                    dos.writeInt(id);
                }
                break block4;
            }
            if (this.type != ResolvedMultiReferenceType.ADD_REMOVE_REFERENCES) break block4;
            dos.writeInt(this.addReferences.size());
            for (Integer id : this.addReferences) {
                dos.writeInt(id);
            }
            dos.writeInt(this.removeReferences.size());
            for (Integer id : this.removeReferences) {
                dos.writeInt(id);
            }
        }
    }

    public ResolvedMultiReferenceType getType() {
        return this.type;
    }

    public List<Integer> getSetReferences() {
        return this.setReferences;
    }

    public List<Integer> getAddReferences() {
        return this.addReferences;
    }

    public List<Integer> getRemoveReferences() {
        return this.removeReferences;
    }
}

