/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.schema;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.universaldb.TableConfig;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.schema.Column;
import org.teamapps.universaldb.schema.Database;
import org.teamapps.universaldb.schema.Table;
import org.teamapps.universaldb.util.DataStreamUtil;

public class Schema {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final int schemaVersion = 1;
    private String pojoNamespace = "org.teamapps.datamodel";
    private String schemaName = "SchemaInfo";
    private final List<Database> databases = new ArrayList<Database>();

    public static Schema create() {
        return new Schema();
    }

    public static Schema create(String pojoNamespace) {
        Schema schema = new Schema();
        schema.setPojoNamespace(pojoNamespace);
        return schema;
    }

    public static Schema parse(String schemaData) {
        return new Schema(schemaData);
    }

    public static void checkName(String name) {
        if (name == null || name.isEmpty() || !name.chars().allMatch(Character::isLetterOrDigit)) {
            throw new RuntimeException("ERROR: INVALID NAME:" + name);
        }
    }

    public static void checkColumnName(String name) {
        Schema.checkName(name);
        if (Table.isReservedMetaName(name)) {
            throw new RuntimeException("ERROR: FORBIDDEN COLUMN NAME:" + name);
        }
    }

    private static List<String> getTokens(String line) {
        line = line.trim();
        String[] parts = line.split(" ");
        return Arrays.asList(parts);
    }

    public Schema() {
    }

    private Schema(String schemaData) {
        String[] lines = schemaData.split("\n");
        boolean foundSchema = false;
        Database db = null;
        Table table = null;
        Set<String> columnTypes = ColumnType.getNames();
        HashMap<Column, String> unresolvedReferenceTableMap = new HashMap<Column, String>();
        for (String line : lines) {
            List<String> tokens;
            int mappingId = 0;
            if ((line = line.trim()).startsWith("/") || line.startsWith("#")) continue;
            if (line.endsWith("]")) {
                int start = line.lastIndexOf(91);
                int end = line.lastIndexOf(93);
                mappingId = Integer.parseInt(line.substring(start + 1, end));
                line = line.substring(0, start);
            }
            if ((tokens = Schema.getTokens(line)).size() < 3 || !tokens.get(1).equalsIgnoreCase("as")) continue;
            String name = tokens.get(0);
            String type = tokens.get(2);
            if (type.equalsIgnoreCase("SCHEMA")) {
                String schemaName;
                foundSchema = true;
                this.setPojoNamespace(name);
                if (tokens.size() > 3 && !(schemaName = tokens.get(3)).isBlank()) {
                    this.setSchemaName(schemaName);
                }
            }
            if (!foundSchema) continue;
            if (type.equalsIgnoreCase("DATABASE")) {
                db = this.addDatabase(name);
                db.setMappingId(mappingId);
            }
            if (type.equalsIgnoreCase("TABLE")) {
                TableConfig tableConfig = TableConfig.parse(line);
                table = db.addTable(name, tableConfig.getTableOptions());
                table.setMappingId(mappingId);
            }
            if (type.equalsIgnoreCase("VIEW")) {
                String referencedTablePath = tokens.get(4);
                table = db.addView(name, referencedTablePath);
                table.setMappingId(mappingId);
            }
            if (type.equalsIgnoreCase("ENUM")) {
                // empty if block
            }
            if (columnTypes.contains(type.toUpperCase()) && !Table.isReservedMetaName(name)) {
                ColumnType columnType = ColumnType.valueOf(type);
                if (table == null) continue;
                Column column = table.addColumn(name, columnType);
                column.setMappingId(mappingId);
                if (columnType.isReference()) {
                    unresolvedReferenceTableMap.put(column, tokens.get(3));
                    String backReference = tokens.get(5);
                    column.setBackReference(backReference.equals("NONE") ? null : backReference);
                    if (!line.contains("CASCADE DELETE REFERENCES")) continue;
                    column.setCascadeDeleteReferences(true);
                    continue;
                }
                if (columnType != ColumnType.ENUM) continue;
                line = line.trim();
                String[] values = line.substring(line.indexOf("VALUES (") + 8).replace(")", "").split(", ");
                column.setEnumValues(Arrays.asList(values));
                continue;
            }
            if (!columnTypes.contains(type.toUpperCase()) || !Table.isReservedMetaName(name) || table == null) continue;
            Column column = table.getColumn(name);
            column.setMappingId(mappingId);
        }
        for (Map.Entry entry : unresolvedReferenceTableMap.entrySet()) {
            Column column = (Column)entry.getKey();
            String fullName = (String)entry.getValue();
            String[] parts = fullName.split("\\.");
            String dbName = parts[0];
            String tableName = parts[1];
            Database refDb = this.getDatabases().stream().filter(database -> database.getName().equals(dbName)).findAny().orElse(null);
            Table referenceTable = refDb.getAllTables().stream().filter(refTable -> refTable.getName().equals(tableName)).findAny().orElse(null);
            column.setReferencedTable(referenceTable);
        }
    }

    public Schema(byte[] data) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(data)));
    }

    public Schema(DataInputStream dis) throws IOException {
        this(DataStreamUtil.readStringWithLengthHeader(dis));
    }

    public byte[] getSchemaData() {
        String schema = this.getSchemaDefinition();
        return schema.getBytes(StandardCharsets.UTF_8);
    }

    public void writeSchema(DataOutputStream dataOutputStream) throws IOException {
        byte[] schemaData = this.getSchemaData();
        DataStreamUtil.writeByteArrayWithLengthHeader(dataOutputStream, schemaData);
    }

    private String createDefinition(boolean ignoreMapping) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.pojoNamespace).append(" as SCHEMA").append("\n");
        this.databases.forEach(db -> sb.append(db.createDefinition(ignoreMapping)));
        return sb.toString();
    }

    public List<Database> getDatabases() {
        return this.databases;
    }

    public Database getDatabase(String name) {
        return this.databases.stream().filter(db -> db.getName().equals(name)).findFirst().orElse(null);
    }

    public Database addDatabase(String name) {
        Schema.checkName(name);
        return this.addDatabase(new Database(this, name));
    }

    private Database addDatabase(Database dataBase) {
        this.databases.add(dataBase);
        return dataBase;
    }

    public String getPojoNamespace() {
        return this.pojoNamespace;
    }

    public void setPojoNamespace(String pojoNamespace) {
        this.pojoNamespace = pojoNamespace;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public int getSchemaVersion() {
        return 1;
    }

    public boolean isCompatibleWith(Schema schema) {
        if (this.schemaVersion != schema.getSchemaVersion()) {
            return false;
        }
        Map<String, Database> databaseMap = this.databases.stream().collect(Collectors.toMap(Database::getName, db -> db));
        for (Database database : schema.getDatabases()) {
            Database localDatabase = databaseMap.get(database.getName());
            if (localDatabase != null) {
                if (localDatabase.getMappingId() > 0 && database.getMappingId() > 0 && localDatabase.getMappingId() != database.getMappingId()) {
                    return false;
                }
                boolean compatibleWith = localDatabase.isCompatibleWith(database);
                if (compatibleWith) continue;
                return false;
            }
            if (database.getMappingId() == 0 || !this.getMappingIds().contains(database.getMappingId())) continue;
            return false;
        }
        return true;
    }

    public boolean isSameSchema(Schema schema) throws IOException {
        byte[] schemaData = this.getSchemaData();
        byte[] schemaData2 = schema.getSchemaData();
        return Arrays.equals(schemaData, schemaData2);
    }

    public boolean isSameSchemaIgnoreMapping(Schema schema) {
        return this.createDefinition(true).equals(schema.createDefinition(true));
    }

    public void merge(Schema schema) {
        if (!this.isCompatibleWith(schema)) {
            throw new RuntimeException("Error: cannot merge incompatible schemas:" + String.valueOf(this) + " with " + String.valueOf(schema));
        }
        Map<String, Database> databaseMap = this.databases.stream().collect(Collectors.toMap(Database::getName, db -> db));
        for (Database database : schema.getDatabases()) {
            Database localDatabase = databaseMap.get(database.getName());
            if (localDatabase == null) {
                this.addDatabase(database);
                continue;
            }
            if (localDatabase.getMappingId() == 0) {
                localDatabase.setMappingId(database.getMappingId());
            }
            localDatabase.merge(database);
        }
    }

    public boolean checkModel() {
        HashSet<Integer> mappingIds = new HashSet<Integer>();
        for (Database database : this.databases) {
            if (database.getMappingId() == 0) {
                logger.error("Missing mapping id:" + database.getFQN());
                return false;
            }
            if (mappingIds.contains(database.getMappingId())) {
                logger.error("Duplicate mapping id:" + database.getFQN());
                return false;
            }
            mappingIds.add(database.getMappingId());
            for (Table table : database.getTables()) {
                if (table.getMappingId() == 0) {
                    logger.error("Missing mapping id:" + table.getFQN());
                    return false;
                }
                if (mappingIds.contains(table.getMappingId())) {
                    logger.error("Duplicate mapping id:" + table.getFQN());
                    return false;
                }
                mappingIds.add(table.getMappingId());
                for (Column columnIndex : table.getColumns()) {
                    if (columnIndex.getMappingId() == 0) {
                        logger.error("Missing mapping id:" + columnIndex.getFQN());
                        return false;
                    }
                    if (mappingIds.contains(columnIndex.getMappingId())) {
                        logger.error("Duplicate mapping id:" + columnIndex.getFQN());
                        return false;
                    }
                    mappingIds.add(columnIndex.getMappingId());
                }
            }
        }
        return true;
    }

    public void mapSchema() {
        for (Database database : this.databases) {
            if (database.getMappingId() == 0) {
                database.setMappingId(this.getNextMappingId());
            }
            for (Table table : database.getTables()) {
                if (table.getMappingId() == 0) {
                    table.setMappingId(this.getNextMappingId());
                }
                for (Column column : table.getColumns()) {
                    if (column.getMappingId() != 0) continue;
                    column.setMappingId(this.getNextMappingId());
                }
            }
        }
    }

    private int getNextMappingId() {
        Set<Integer> mappingIds = this.getMappingIds();
        int mappingId = mappingIds.size() + 1;
        while (mappingIds.contains(mappingId)) {
            ++mappingId;
        }
        return mappingId;
    }

    public Set<Integer> getMappingIds() {
        HashSet<Integer> mappingIds = new HashSet<Integer>();
        for (Database database : this.databases) {
            mappingIds.add(database.getMappingId());
            for (Table table : database.getTables()) {
                mappingIds.add(table.getMappingId());
                for (Column column : table.getColumns()) {
                    mappingIds.add(column.getMappingId());
                }
            }
        }
        mappingIds.remove(0);
        return mappingIds;
    }

    public String toString() {
        return this.createDefinition(false);
    }

    public String getSchemaDefinition() {
        return this.createDefinition(false);
    }
}

