/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.buffer.index;

import java.io.File;
import java.util.BitSet;
import java.util.Set;
import java.util.stream.IntStream;
import org.teamapps.universaldb.index.buffer.common.PrimitiveEntryAtomicStore;

public class ByteAtomicMappedIndex {
    private final PrimitiveEntryAtomicStore atomicStore;

    public ByteAtomicMappedIndex(File path, String name) {
        this.atomicStore = new PrimitiveEntryAtomicStore(path, name);
    }

    public byte getValue(int id) {
        return this.atomicStore.getByte(id);
    }

    public void setValue(int id, byte value) {
        this.atomicStore.setByte(id, value);
    }

    public boolean isEmpty(int id) {
        return this.getValue(id) != 0;
    }

    public int getMaximumId() {
        return this.atomicStore.getMaximumId(1);
    }

    public int getLastNonEmptyIndex() {
        int maximumId;
        for (int i = maximumId = this.getMaximumId(); i > 0; --i) {
            if (this.isEmpty(i)) continue;
            return i;
        }
        return -1;
    }

    public IntStream getIndexStream() {
        return IntStream.range(1, this.getMaximumId() + 1);
    }

    public BitSet filterEquals(byte value, BitSet bitSet) {
        return this.filterEquals(value, bitSet.stream());
    }

    public BitSet filterEquals(byte value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getByte(id) == value).forEach(result::set);
        return result;
    }

    public BitSet filterNotEquals(byte value, BitSet bitSet) {
        return this.filterNotEquals(value, bitSet.stream());
    }

    public BitSet filterNotEquals(byte value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getByte(id) != value).forEach(result::set);
        return result;
    }

    public BitSet filterGreater(byte value, BitSet bitSet) {
        return this.filterGreater(value, bitSet.stream());
    }

    public BitSet filterGreater(byte value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getByte(id) > value).forEach(result::set);
        return result;
    }

    public BitSet filterSmaller(byte value, BitSet bitSet) {
        return this.filterSmaller(value, bitSet.stream());
    }

    public BitSet filterSmaller(byte value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getByte(id) < value).forEach(result::set);
        return result;
    }

    public BitSet filterBetween(byte startValue, byte endValue, BitSet bitSet) {
        return this.filterBetween(startValue, endValue, bitSet.stream());
    }

    public BitSet filterBetween(byte startValue, byte endValue, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> {
            byte v = this.atomicStore.getByte(id);
            return v > startValue && v < endValue;
        }).forEach(result::set);
        return result;
    }

    public BitSet filterContains(Set<Byte> valueSet, BitSet bitSet) {
        return this.filterContains(valueSet, bitSet.stream());
    }

    public BitSet filterContains(Set<Byte> valueSet, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> valueSet.contains(this.atomicStore.getByte(id))).forEach(result::set);
        return result;
    }

    public BitSet filterContainsNot(Set<Byte> valueSet, BitSet bitSet) {
        return this.filterContainsNot(valueSet, bitSet.stream());
    }

    public BitSet filterContainsNot(Set<Byte> valueSet, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> !valueSet.contains(this.atomicStore.getByte(id))).forEach(result::set);
        return result;
    }

    public void flush() {
        this.atomicStore.flush();
    }

    public void close() {
        this.atomicStore.close();
    }

    public void drop() {
        this.atomicStore.drop();
    }
}

