/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.buffer.index;

import java.io.File;
import java.util.BitSet;
import java.util.Set;
import java.util.stream.IntStream;
import org.teamapps.universaldb.index.buffer.common.PrimitiveEntryAtomicStore;

public class DoubleAtomicMappedIndex {
    private final PrimitiveEntryAtomicStore atomicStore;

    public DoubleAtomicMappedIndex(File path, String name) {
        this.atomicStore = new PrimitiveEntryAtomicStore(path, name);
    }

    public double getValue(int id) {
        return this.atomicStore.getDouble(id);
    }

    public void setValue(int id, double value) {
        this.atomicStore.setDouble(id, value);
    }

    public boolean isEmpty(int id) {
        return this.getValue(id) != 0.0;
    }

    public int getMaximumId() {
        return this.atomicStore.getMaximumId(8);
    }

    public int getLastNonEmptyIndex() {
        int maximumId;
        for (int i = maximumId = this.getMaximumId(); i > 0; --i) {
            if (this.isEmpty(i)) continue;
            return i;
        }
        return -1;
    }

    public IntStream getIndexStream() {
        return IntStream.range(1, this.getMaximumId() + 1);
    }

    public BitSet filterEquals(double value, BitSet bitSet) {
        return this.filterEquals(value, bitSet.stream());
    }

    public BitSet filterEquals(double value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getDouble(id) == value).forEach(result::set);
        return result;
    }

    public BitSet filterNotEquals(double value, BitSet bitSet) {
        return this.filterNotEquals(value, bitSet.stream());
    }

    public BitSet filterNotEquals(double value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getDouble(id) != value).forEach(result::set);
        return result;
    }

    public BitSet filterGreater(double value, BitSet bitSet) {
        return this.filterGreater(value, bitSet.stream());
    }

    public BitSet filterGreater(double value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getDouble(id) > value).forEach(result::set);
        return result;
    }

    public BitSet filterSmaller(double value, BitSet bitSet) {
        return this.filterSmaller(value, bitSet.stream());
    }

    public BitSet filterSmaller(double value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getDouble(id) < value).forEach(result::set);
        return result;
    }

    public BitSet filterBetween(double startValue, double endValue, BitSet bitSet) {
        return this.filterBetween(startValue, endValue, bitSet.stream());
    }

    public BitSet filterBetween(double startValue, double endValue, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> {
            double v = this.atomicStore.getDouble(id);
            return v > startValue && v < endValue;
        }).forEach(result::set);
        return result;
    }

    public BitSet filterContains(Set<Double> valueSet, BitSet bitSet) {
        return this.filterContains(valueSet, bitSet.stream());
    }

    public BitSet filterContains(Set<Double> valueSet, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> valueSet.contains(this.atomicStore.getDouble(id))).forEach(result::set);
        return result;
    }

    public BitSet filterContainsNot(Set<Double> valueSet, BitSet bitSet) {
        return this.filterContainsNot(valueSet, bitSet.stream());
    }

    public BitSet filterContainsNot(Set<Double> valueSet, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> !valueSet.contains(this.atomicStore.getDouble(id))).forEach(result::set);
        return result;
    }

    public void flush() {
        this.atomicStore.flush();
    }

    public void close() {
        this.atomicStore.close();
    }

    public void drop() {
        this.atomicStore.drop();
    }
}

