/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.date;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.List;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.index.numeric.NumericFilterType;

public class TimestampFilter
extends NumericFilter {
    public static TimestampFilter createGreaterFilter(LocalDate date) {
        return new TimestampFilter(NumericFilterType.GREATER, TimestampFilter.convertToEpochSecond(date), null);
    }

    public static TimestampFilter createGreaterFilter(LocalDateTime date) {
        return new TimestampFilter(NumericFilterType.GREATER, TimestampFilter.convertToEpochSecond(date), null);
    }

    public static TimestampFilter createGreaterFilter(Instant date) {
        return new TimestampFilter(NumericFilterType.GREATER, TimestampFilter.convertToEpochSecond(date), null);
    }

    public static TimestampFilter createGreaterEqualsFilter(LocalDate date) {
        return new TimestampFilter(NumericFilterType.GREATER_EQUALS, TimestampFilter.convertToEpochSecond(date), null);
    }

    public static TimestampFilter createGreaterEqualsFilter(LocalDateTime date) {
        return new TimestampFilter(NumericFilterType.GREATER_EQUALS, TimestampFilter.convertToEpochSecond(date), null);
    }

    public static TimestampFilter createGreaterEqualsFilter(Instant date) {
        return new TimestampFilter(NumericFilterType.GREATER_EQUALS, TimestampFilter.convertToEpochSecond(date), null);
    }

    public static TimestampFilter createSmallerFilter(LocalDate date) {
        return new TimestampFilter(NumericFilterType.SMALLER, TimestampFilter.convertToEpochSecond(date), null);
    }

    public static TimestampFilter createSmallerFilter(LocalDateTime date) {
        return new TimestampFilter(NumericFilterType.SMALLER, TimestampFilter.convertToEpochSecond(date), null);
    }

    public static TimestampFilter createSmallerFilter(Instant date) {
        return new TimestampFilter(NumericFilterType.SMALLER, TimestampFilter.convertToEpochSecond(date), null);
    }

    public static TimestampFilter createSmallerEqualsFilter(LocalDate date) {
        return new TimestampFilter(NumericFilterType.SMALLER_EQUALS, TimestampFilter.convertToEpochSecond(date), null);
    }

    public static TimestampFilter createSmallerEqualsFilter(LocalDateTime date) {
        return new TimestampFilter(NumericFilterType.SMALLER_EQUALS, TimestampFilter.convertToEpochSecond(date), null);
    }

    public static TimestampFilter createSmallerEqualsFilter(Instant date) {
        return new TimestampFilter(NumericFilterType.SMALLER_EQUALS, TimestampFilter.convertToEpochSecond(date), null);
    }

    public static TimestampFilter createBetweenFilter(LocalDate date1, LocalDate date2) {
        return new TimestampFilter(NumericFilterType.BETWEEN, TimestampFilter.convertToEpochSecond(date1), TimestampFilter.convertToEpochSecond(date2));
    }

    public static TimestampFilter createBetweenFilter(LocalDateTime date1, LocalDateTime date2) {
        return new TimestampFilter(NumericFilterType.BETWEEN, TimestampFilter.convertToEpochSecond(date1), TimestampFilter.convertToEpochSecond(date2));
    }

    public static TimestampFilter createBetweenFilter(Instant date1, Instant date2) {
        return new TimestampFilter(NumericFilterType.BETWEEN, TimestampFilter.convertToEpochSecond(date1), TimestampFilter.convertToEpochSecond(date2));
    }

    protected TimestampFilter(NumericFilterType filterType, List<Number> values) {
        super(filterType, values);
    }

    protected TimestampFilter(NumericFilterType filterType, Number value1, Number value2) {
        super(filterType, value1, value2);
    }

    private static int convertToEpochSecond(LocalDate date) {
        return (int)date.toEpochSecond(LocalTime.MIDNIGHT, ZoneOffset.UTC);
    }

    private static int convertToEpochSecond(LocalDateTime dateTime) {
        return (int)dateTime.toEpochSecond(ZoneOffset.UTC);
    }

    private static int convertToEpochSecond(Instant instant) {
        return (int)(instant.toEpochMilli() / 1000L);
    }
}

