/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.file.store;

import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import org.teamapps.udb.model.FileContentData;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.file.store.FileStore;
import org.teamapps.universaldb.index.file.store.FileStoreUtil;
import org.teamapps.universaldb.index.file.value.CommittedLocalFile;

public class LocalFileStore
implements FileStore {
    private final File basePath;

    public LocalFileStore(File path, String name) {
        this.basePath = new File(path, name);
        this.basePath.mkdir();
    }

    @Override
    public boolean isEncrypted() {
        return false;
    }

    @Override
    public FileValue getFile(String name, String hash, long length, String key, Supplier<FileContentData> contentDataSupplier) {
        File storeFile = this.getStoreFile(hash, length);
        return new CommittedLocalFile(storeFile, name, hash, length, contentDataSupplier);
    }

    @Override
    public FileValue storeFile(FileValue fileValue) throws IOException {
        if (fileValue == null || fileValue.getSize() == 0L) {
            return null;
        }
        File filePath = this.createPath(fileValue.getHash(), fileValue.getSize());
        if (!filePath.exists() || filePath.length() != fileValue.getSize()) {
            fileValue.copyToFile(filePath);
        }
        return new CommittedLocalFile(filePath, fileValue.getFileName(), fileValue.getHash(), fileValue.getSize(), fileValue::getFileContentData);
    }

    private File getStoreFile(String hash, long length) {
        return FileStoreUtil.getPath(this.basePath, hash, length);
    }

    private File createPath(String hash, long length) {
        File filePath = this.getStoreFile(hash, length);
        if (!filePath.getParentFile().exists()) {
            filePath.getParentFile().mkdirs();
        }
        return filePath;
    }
}

