/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.file.value;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import org.teamapps.udb.model.FileContentData;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.file.value.FileValueType;

public class CommittedRemoteFile
implements FileValue {
    private final Supplier<File> fileSupplier;
    private final String fileName;
    private final String hash;
    private final long size;
    private final Supplier<FileContentData> contentDataSupplier;
    private File file;
    private FileContentData contentData;

    public CommittedRemoteFile(Supplier<File> fileSupplier, String fileName, String hash, long size, Supplier<FileContentData> contentDataSupplier) {
        this.fileSupplier = fileSupplier;
        this.fileName = fileName;
        this.hash = hash;
        this.size = size;
        this.contentDataSupplier = contentDataSupplier;
    }

    private File getFile() {
        if (this.file == null) {
            this.file = this.fileSupplier.get();
        }
        return this.file;
    }

    @Override
    public FileValueType getType() {
        return FileValueType.COMMITTED_REMOTE_FILE;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.getFile()));
    }

    @Override
    public File getAsFile() {
        try {
            Path path = Files.createTempFile("tmp", "." + this.getFileExtension(), new FileAttribute[0]);
            Files.copy(this.getFile().toPath(), path, StandardCopyOption.REPLACE_EXISTING);
            return path.toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void copyToFile(File file) throws IOException {
        Files.copy(this.getFile().toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public String getKey() {
        return null;
    }

    @Override
    public FileContentData getFileContentData() {
        if (this.contentData == null) {
            this.contentData = this.contentDataSupplier.get();
        }
        return this.contentData;
    }

    @Override
    public String getDetectedLanguage() {
        return this.getFileContentData().getLanguage();
    }
}

