/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.message;

import java.io.File;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.teamapps.message.protocol.message.MessageRecord;
import org.teamapps.message.protocol.model.ModelRegistry;
import org.teamapps.universaldb.message.BaseMessageCache;
import org.teamapps.universaldb.message.BaseMessageStoreImpl;
import org.teamapps.universaldb.message.CloseableIterator;
import org.teamapps.universaldb.message.MessageChangeType;

public interface BaseMessageStore {
    public static BaseMessageStore create(File path, String name) {
        return new BaseMessageStoreImpl(path, name);
    }

    public static BaseMessageStore create(File path, String name, BaseMessageCache messageCache) {
        return new BaseMessageStoreImpl(path, name, messageCache);
    }

    public static BaseMessageStore create(File path, String name, ModelRegistry modelRegistry, BaseMessageCache messageCache, BiConsumer<MessageRecord, MessageChangeType> changeHandler) {
        return new BaseMessageStoreImpl(path, name, modelRegistry, messageCache, changeHandler);
    }

    public void save(MessageRecord var1);

    public void delete(int var1);

    public void undelete(int var1);

    public MessageRecord getById(int var1);

    public MessageRecord getByPosition(long var1);

    public MessageRecord getLast();

    public int getMessageCount();

    public int getDeletedCount();

    public List<MessageRecord> getAllMessages();

    public List<MessageRecord> getPreviousMessages(int var1, int var2);

    public List<MessageRecord> getNextMessages(int var1, int var2);

    public List<MessageRecord> getMessageVersions(int var1);

    public CloseableIterator<MessageRecord> iterate();

    public CloseableIterator<MessageRecord> iterateDeleted();

    public Stream<MessageRecord> getStream();

    public Stream<MessageRecord> getStream(int var1);

    public boolean isEmpty();

    public long getStoreSize();

    public void flush();

    public void close();

    public void drop();
}

