/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.model;

import java.util.HashMap;
import java.util.Map;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.IndexType;

public enum FieldType {
    BOOLEAN(1),
    SHORT(2),
    INT(3),
    LONG(4),
    FLOAT(5),
    DOUBLE(6),
    TEXT(7),
    TRANSLATABLE_TEXT(8),
    FILE(9),
    SINGLE_REFERENCE(10),
    MULTI_REFERENCE(11),
    TIMESTAMP(12),
    DATE(13),
    TIME(14),
    DATE_TIME(15),
    LOCAL_DATE(16),
    ENUM(17),
    BINARY(18),
    CURRENCY(19),
    DYNAMIC_CURRENCY(20);

    private final int id;
    private static final Map<Integer, FieldType> FIELD_TYPE_MAP;

    private FieldType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public boolean isReference() {
        return this == SINGLE_REFERENCE || this == MULTI_REFERENCE;
    }

    public boolean isMultiReference() {
        return this == MULTI_REFERENCE;
    }

    public boolean isEnum() {
        return this == ENUM;
    }

    public boolean isFile() {
        return this == FILE;
    }

    public boolean isDateBased() {
        return switch (this.ordinal()) {
            case 11, 12, 14, 15 -> true;
            default -> false;
        };
    }

    public ColumnType getColumnType() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ColumnType.BOOLEAN;
            case 1 -> ColumnType.SHORT;
            case 2 -> ColumnType.INT;
            case 3 -> ColumnType.LONG;
            case 4 -> ColumnType.FLOAT;
            case 5 -> ColumnType.DOUBLE;
            case 6 -> ColumnType.TEXT;
            case 7 -> ColumnType.TRANSLATABLE_TEXT;
            case 8 -> ColumnType.FILE;
            case 9 -> ColumnType.SINGLE_REFERENCE;
            case 10 -> ColumnType.MULTI_REFERENCE;
            case 11 -> ColumnType.TIMESTAMP;
            case 12 -> ColumnType.DATE;
            case 13 -> ColumnType.TIME;
            case 14 -> ColumnType.DATE_TIME;
            case 15 -> ColumnType.LOCAL_DATE;
            case 16 -> ColumnType.ENUM;
            case 17 -> ColumnType.BINARY;
            case 18 -> ColumnType.CURRENCY;
            case 19 -> ColumnType.DYNAMIC_CURRENCY;
        };
    }

    public IndexType getIndexType() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> IndexType.BOOLEAN;
            case 1, 16 -> IndexType.SHORT;
            case 2, 11, 13 -> IndexType.INT;
            case 3, 12, 14, 15, 18, 19 -> IndexType.LONG;
            case 4 -> IndexType.FLOAT;
            case 5 -> IndexType.DOUBLE;
            case 6 -> IndexType.TEXT;
            case 7 -> IndexType.TRANSLATABLE_TEXT;
            case 8 -> IndexType.FILE;
            case 9 -> IndexType.REFERENCE;
            case 10 -> IndexType.MULTI_REFERENCE;
            case 17 -> IndexType.BINARY;
        };
    }

    public static FieldType getTypeById(int id) {
        return FIELD_TYPE_MAP.get(id);
    }

    static {
        FIELD_TYPE_MAP = new HashMap<Integer, FieldType>();
        for (FieldType fieldType : FieldType.values()) {
            FIELD_TYPE_MAP.put(fieldType.getId(), fieldType);
        }
    }
}

