/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.query;

import java.util.BitSet;
import java.util.function.Function;
import org.teamapps.universaldb.query.Filter;
import org.teamapps.universaldb.query.IndexPath;

public class CustomEntityFilter
implements Filter {
    private final Function<Integer, Boolean> filterFunction;
    private IndexPath indexPath = new IndexPath();

    public CustomEntityFilter(Function<Integer, Boolean> filterFunction) {
        this.filterFunction = filterFunction;
    }

    @Override
    public BitSet filter(BitSet input) {
        BitSet localRecords = this.indexPath.calculatePathBitSet(input);
        BitSet result = this.localFilter(localRecords);
        return this.indexPath.calculateReversePath(result, input);
    }

    @Override
    public BitSet localFilter(BitSet localRecords) {
        BitSet result = new BitSet();
        int id = localRecords.nextSetBit(0);
        while (id >= 0) {
            if (this.filterFunction.apply(id).booleanValue()) {
                result.set(id);
            }
            id = localRecords.nextSetBit(id + 1);
        }
        return result;
    }

    @Override
    public IndexPath getPath() {
        return this.indexPath;
    }

    @Override
    public void prependPath(IndexPath path) {
        path.addPath(this.indexPath);
        this.indexPath = path;
    }

    @Override
    public String explain(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getExplainTabs(level));
        sb.append("custom-filter");
        sb.append("\n");
        return sb.toString();
    }
}

