/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.analysis;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.universaldb.index.log.DefaultLogIndex;
import org.teamapps.universaldb.index.log.LogIterator;
import org.teamapps.universaldb.index.log.RotatingLogIndex;
import org.teamapps.universaldb.index.transaction.resolved.ResolvedTransaction;
import org.teamapps.universaldb.index.transaction.schema.ModelUpdate;

public class TransactionLogAnalyzer {
    public static void analyzeLog(File path) {
        RotatingLogIndex transactionLog = new RotatingLogIndex(path, "transactions");
        DefaultLogIndex modelsLog = new DefaultLogIndex(path, "models");
        List<ModelUpdate> modelUpdates = TransactionLogAnalyzer.getModelUpdates(modelsLog);
        LogIterator logIterator = transactionLog.readLogs();
        while (logIterator.hasNext()) {
            ResolvedTransaction resolvedTransaction = ResolvedTransaction.createResolvedTransaction(logIterator.next());
        }
        logIterator.closeSave();
    }

    public static synchronized List<ModelUpdate> getModelUpdates(DefaultLogIndex modelsLog) {
        if (modelsLog.isEmpty()) {
            return Collections.emptyList();
        }
        return modelsLog.readAllLogs().stream().map(ModelUpdate::new).collect(Collectors.toList());
    }
}

