/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.teamapps.universaldb.DatabaseData;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.model.TableModel;

public class DatabaseManager {
    private final Map<String, DatabaseData> databaseMap = new HashMap<String, DatabaseData>();
    private static final DatabaseManager BASE_INSTANCE = new DatabaseManager();
    private List<Consumer<UniversalDB>> managedDbHandler = new ArrayList<Consumer<UniversalDB>>();

    public static DatabaseManager getBaseInstance() {
        return BASE_INSTANCE;
    }

    public synchronized void registerDatabase(String name, UniversalDB newDb, ClassLoader classLoader) {
        for (DatabaseData dbData : this.databaseMap.values()) {
            Set remoteDbNames = dbData.getUniversalDB().getTransactionIndex().getCurrentModel().getRemoteTables().stream().map(TableModel::getRemoteDatabase).collect(Collectors.toSet());
            if (!remoteDbNames.contains(newDb.getName())) continue;
            if (!remoteDbNames.stream().allMatch(this.databaseMap::containsKey)) continue;
            this.installRemoteTables(dbData.getUniversalDB(), classLoader);
        }
        this.databaseMap.put(name, new DatabaseData(newDb, classLoader));
        Set remoteDbNames = newDb.getTransactionIndex().getCurrentModel().getRemoteTables().stream().map(TableModel::getRemoteDatabase).collect(Collectors.toSet());
        if (remoteDbNames.stream().allMatch(this.databaseMap::containsKey)) {
            this.installRemoteTables(newDb, classLoader);
        }
        this.managedDbHandler.forEach(handler -> handler.accept(newDb));
    }

    private void installRemoteTables(UniversalDB db, ClassLoader classLoader) {
        db.installRemoteTableClasses(classLoader);
    }

    public void addDatabaseHandler(Consumer<UniversalDB> handler) {
        this.managedDbHandler.add(handler);
    }

    public synchronized UniversalDB getDatabase(String name) {
        DatabaseData databaseData = this.databaseMap.get(name);
        return databaseData != null ? databaseData.getUniversalDB() : null;
    }

    public synchronized ClassLoader getClassLoader(UniversalDB udb) {
        return this.getClassLoader(udb.getName());
    }

    public synchronized ClassLoader getClassLoader(String name) {
        return this.databaseMap.get(name).getClassLoader();
    }

    public synchronized List<UniversalDB> getDatabases() {
        return this.databaseMap.values().stream().map(DatabaseData::getUniversalDB).toList();
    }
}

