/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.text;

import java.util.Collections;
import java.util.List;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.text.TextFilterType;

public class TextFilter {
    private final TextFilterType filterType;
    private final String value;
    private UserContext userContext;

    public static TextFilter emptyFilter() {
        return new TextFilter(TextFilterType.EMPTY, null);
    }

    public static TextFilter notEmptyFilter() {
        return new TextFilter(TextFilterType.NOT_EMPTY, null);
    }

    public static TextFilter textEqualsFilter(String value) {
        return new TextFilter(TextFilterType.TEXT_EQUALS, value);
    }

    public static TextFilter textEqualsIgnoreCaseFilter(String value) {
        return new TextFilter(TextFilterType.TEXT_EQUALS_IGNORE_CASE, value);
    }

    public static TextFilter textNotEqualsFilter(String value) {
        return new TextFilter(TextFilterType.TEXT_NOT_EQUALS, value);
    }

    public static TextFilter textByteLengthGreaterFilter(int size) {
        return new TextFilter(TextFilterType.TEXT_BYTE_LENGTH_GREATER, "" + size);
    }

    public static TextFilter textByteLengthSmallerFilter(int size) {
        return new TextFilter(TextFilterType.TEXT_BYTE_LENGTH_SMALLER, "" + size);
    }

    public static TextFilter termEqualsFilter(String value) {
        return new TextFilter(TextFilterType.TERM_EQUALS, value);
    }

    public static TextFilter termNotEqualsFilter(String value) {
        return new TextFilter(TextFilterType.TERM_NOT_EQUALS, value);
    }

    public static TextFilter termStartsWithFilter(String value) {
        return new TextFilter(TextFilterType.TERM_STARTS_WITH, value);
    }

    public static TextFilter termStartsNotWithFilter(String value) {
        return new TextFilter(TextFilterType.TERM_STARTS_NOT_WITH, value);
    }

    public static TextFilter termSimilarFilter(String value) {
        return new TextFilter(TextFilterType.TERM_SIMILAR, value);
    }

    public static TextFilter termNotSimilarFilter(String value) {
        return new TextFilter(TextFilterType.TERM_NOT_SIMILAR, value);
    }

    public static TextFilter termContainsFilter(String value) {
        return new TextFilter(TextFilterType.TERM_CONTAINS, value);
    }

    public static TextFilter termContainsNotFilter(String value) {
        return new TextFilter(TextFilterType.TERM_CONTAINS_NOT, value);
    }

    protected TextFilter(TextFilterType filterType, String value) {
        this(filterType, value, null);
    }

    protected TextFilter(TextFilterType filterType, String value, UserContext userContext) {
        this.filterType = filterType;
        this.value = value;
        this.userContext = userContext;
    }

    public TextFilterType getFilterType() {
        return this.filterType;
    }

    public String getValue() {
        return this.value;
    }

    public List<String> getRankedLanguages() {
        return this.userContext != null ? this.userContext.getRankedLanguages() : Collections.singletonList("en");
    }

    public UserContext getUserContext() {
        return this.userContext;
    }

    public String toString() {
        return this.userContext == null ? String.valueOf((Object)this.filterType) + ":" + this.value : String.valueOf((Object)this.filterType) + ":" + this.value + " (" + String.join((CharSequence)",", this.userContext.getRankedLanguages()) + ")";
    }
}

