/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.message;

import java.io.File;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.teamapps.message.protocol.message.Message;
import org.teamapps.message.protocol.message.MessageRecord;
import org.teamapps.message.protocol.model.PojoObjectDecoder;
import org.teamapps.universaldb.message.CloseableIterator;
import org.teamapps.universaldb.message.MessageCache;
import org.teamapps.universaldb.message.MessageChangeType;
import org.teamapps.universaldb.message.MessageStoreImpl;

public interface MessageStore<MESSAGE extends MessageRecord> {
    public static <MESSAGE extends Message> MessageStore<MESSAGE> create(File path, String name, PojoObjectDecoder<MESSAGE> messageDecoder) {
        return new MessageStoreImpl<MESSAGE>(path, name, messageDecoder, null);
    }

    public static <MESSAGE extends Message> MessageStore<MESSAGE> create(File path, String name, PojoObjectDecoder<MESSAGE> messageDecoder, MessageCache<MESSAGE> messageCache) {
        return new MessageStoreImpl<MESSAGE>(path, name, messageDecoder, messageCache);
    }

    public static <MESSAGE extends Message> MessageStore<MESSAGE> create(File path, String name, PojoObjectDecoder<MESSAGE> messageDecoder, MessageCache<MESSAGE> messageCache, BiConsumer<MESSAGE, MessageChangeType> changeHandler) {
        return new MessageStoreImpl<MESSAGE>(path, name, messageDecoder, messageCache, changeHandler);
    }

    public void save(MESSAGE var1);

    public void delete(int var1);

    public void undelete(int var1);

    public MESSAGE getById(int var1);

    public MESSAGE getByPosition(long var1);

    public MESSAGE getLast();

    public int getMessageCount();

    public int getDeletedCount();

    public List<MESSAGE> getAllMessages();

    public List<MESSAGE> getPreviousMessages(int var1, int var2);

    public List<MESSAGE> getNextMessages(int var1, int var2);

    public List<MESSAGE> getMessageVersions(int var1);

    public CloseableIterator<MESSAGE> iterate();

    public CloseableIterator<MESSAGE> iterateDeleted();

    public Stream<MESSAGE> getStream();

    public Stream<MESSAGE> getStream(int var1);

    public boolean isEmpty();

    public long getStoreSize();

    public void flush();

    public void close();

    public void drop();
}

