package org.teamapps.udb.model;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.model.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import java.util.*;
import java.time.*;



public class FileContentData extends Message {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<FileContentData> decoder = new PojoObjectDecoder<FileContentData>() {
		@Override
		public FileContentData decode(DataInputStream dis, FileDataReader fileDataReader) {
			try {
				return new FileContentData(dis, fileDataReader);
			} catch (IOException e) {
				LOGGER.error("Error creating FileContentData instance", e);
			}
			return null;
		}

		@Override
		public FileContentData decode(Element element, FileDataReader fileDataReader) {
			return new FileContentData(element, fileDataReader);
		}

        @Override
        public FileContentData decode(String xml, FileDataReader fileDataReader) {
            try {
                return new FileContentData(xml, fileDataReader);
            } catch (Exception e) {
                LOGGER.error("Error creating FileContentData instance", e);
            }
            return null;
        }

		@Override
		public FileContentData defaultMessage() {
			return (FileContentData) new FileContentData().setDefaultValues(UdbModel.MODEL_COLLECTION);
		}

		@Override
		public FileContentData remap(MessageRecord message) {
			return new FileContentData(message, UdbModel.MODEL_COLLECTION);
		}

        @Override
        public String getMessageUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<FileContentData> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return UdbModel.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return UdbModel.MODEL_COLLECTION;
	}

    public static FileContentData remap(MessageRecord message) {
        return new FileContentData(message, UdbModel.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "#udb.fileContentData";


	public FileContentData() {
		super(UdbModel.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public FileContentData(MessageRecord message, ModelCollection modelCollection) {
		super(message, modelCollection);
	}

	public FileContentData(DataInputStream dis) throws IOException {
		super(dis, UdbModel.MODEL_COLLECTION.getModel(OBJECT_UUID), null, UdbModel.MODEL_COLLECTION);
	}

	public FileContentData(DataInputStream dis, FileDataReader fileDataReader) throws IOException {
		super(dis, UdbModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, UdbModel.MODEL_COLLECTION);
	}

	public FileContentData(byte[] bytes) throws IOException {
		super(bytes, UdbModel.MODEL_COLLECTION.getModel(OBJECT_UUID), null, UdbModel.MODEL_COLLECTION);
	}

	public FileContentData(byte[] bytes, FileDataReader fileDataReader) throws IOException {
		super(bytes, UdbModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, UdbModel.MODEL_COLLECTION);
	}

	public FileContentData(Element element, FileDataReader fileDataReader) {
		super(element, UdbModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, UdbModel.MODEL_COLLECTION);
	}

    public FileContentData(String xml, FileDataReader fileDataReader) throws Exception {
        super(xml, UdbModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, UdbModel.MODEL_COLLECTION);
    }

	public String getName() {
		return getStringAttribute("name");
	}

	public FileContentData setName(String value) {
		setStringAttribute("name", value);
		return this;
	}

	public long getFileSize() {
		return getLongAttribute("fileSize");
	}

	public FileContentData setFileSize(long value) {
		setLongAttribute("fileSize", value);
		return this;
	}

	public String getHash() {
		return getStringAttribute("hash");
	}

	public FileContentData setHash(String value) {
		setStringAttribute("hash", value);
		return this;
	}

	public String getContent() {
		return getStringAttribute("content");
	}

	public FileContentData setContent(String value) {
		setStringAttribute("content", value);
		return this;
	}

	public String getMimeType() {
		return getStringAttribute("mimeType");
	}

	public FileContentData setMimeType(String value) {
		setStringAttribute("mimeType", value);
		return this;
	}

	public String getCreatedBy() {
		return getStringAttribute("createdBy");
	}

	public FileContentData setCreatedBy(String value) {
		setStringAttribute("createdBy", value);
		return this;
	}

	public String getModifiedBy() {
		return getStringAttribute("modifiedBy");
	}

	public FileContentData setModifiedBy(String value) {
		setStringAttribute("modifiedBy", value);
		return this;
	}

	public Instant getDateCreated() {
		return getTimestampAttribute("dateCreated");
	}

	public FileContentData setDateCreated(Instant value) {
		setTimestampAttribute("dateCreated", value);
		return this;
	}

	public Instant getDateModified() {
		return getTimestampAttribute("dateModified");
	}

	public FileContentData setDateModified(Instant value) {
		setTimestampAttribute("dateModified", value);
		return this;
	}

	public int getPages() {
		return getIntAttribute("pages");
	}

	public FileContentData setPages(int value) {
		setIntAttribute("pages", value);
		return this;
	}

	public String getTitle() {
		return getStringAttribute("title");
	}

	public FileContentData setTitle(String value) {
		setStringAttribute("title", value);
		return this;
	}

	public String getLatitude() {
		return getStringAttribute("latitude");
	}

	public FileContentData setLatitude(String value) {
		setStringAttribute("latitude", value);
		return this;
	}

	public String getLongitude() {
		return getStringAttribute("longitude");
	}

	public FileContentData setLongitude(String value) {
		setStringAttribute("longitude", value);
		return this;
	}

	public String getDevice() {
		return getStringAttribute("device");
	}

	public FileContentData setDevice(String value) {
		setStringAttribute("device", value);
		return this;
	}

	public String getSoftware() {
		return getStringAttribute("software");
	}

	public FileContentData setSoftware(String value) {
		setStringAttribute("software", value);
		return this;
	}

	public String getSoftwareVersion() {
		return getStringAttribute("softwareVersion");
	}

	public FileContentData setSoftwareVersion(String value) {
		setStringAttribute("softwareVersion", value);
		return this;
	}

	public String getDuration() {
		return getStringAttribute("duration");
	}

	public FileContentData setDuration(String value) {
		setStringAttribute("duration", value);
		return this;
	}

	public int getImageWidth() {
		return getIntAttribute("imageWidth");
	}

	public FileContentData setImageWidth(int value) {
		setIntAttribute("imageWidth", value);
		return this;
	}

	public int getImageHeight() {
		return getIntAttribute("imageHeight");
	}

	public FileContentData setImageHeight(int value) {
		setIntAttribute("imageHeight", value);
		return this;
	}

	public String getLanguage() {
		return getStringAttribute("language");
	}

	public FileContentData setLanguage(String value) {
		setStringAttribute("language", value);
		return this;
	}

	public String[] getMetaKeys() {
		return getStringArrayAttribute("metaKeys");
	}

	public FileContentData setMetaKeys(String[] value) {
		setStringArrayAttribute("metaKeys", value);
		return this;
	}

	public List<String> getMetaKeysAsList() {
		return getStringArrayAsList("metaKeys");
	}

	public FileContentData setMetaKeysAsList(List<String> value) {
		setStringArrayAsList("metaKeys", value);
		return this;
	}

	public String[] getMetaValues() {
		return getStringArrayAttribute("metaValues");
	}

	public FileContentData setMetaValues(String[] value) {
		setStringArrayAttribute("metaValues", value);
		return this;
	}

	public List<String> getMetaValuesAsList() {
		return getStringArrayAsList("metaValues");
	}

	public FileContentData setMetaValuesAsList(List<String> value) {
		setStringArrayAsList("metaValues", value);
		return this;
	}



}