/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.file.value;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.teamapps.udb.model.FileContentData;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.file.value.FileContentParser;
import org.teamapps.universaldb.index.file.value.FileValueType;

public class UncommittedFile
implements FileValue {
    private final File file;
    private final String fileName;
    private final String hash;
    private final long size;
    private final FileContentParser contentParser;
    private FileContentData contentData;

    public UncommittedFile(File file) {
        this(file, file.getName());
    }

    public UncommittedFile(File file, String fileName) {
        this.file = file;
        this.fileName = fileName != null ? fileName : file.getName();
        this.size = file.length();
        this.contentParser = new FileContentParser(file, fileName);
        this.hash = this.contentParser.getHash();
    }

    @Override
    public FileValueType getType() {
        return FileValueType.UNCOMMITTED_FILE;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    @Override
    public File getAsFile() {
        return this.file;
    }

    @Override
    public void copyToFile(File file) throws IOException {
        Files.copy(this.file.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public String getKey() {
        return null;
    }

    @Override
    public FileContentData getFileContentData() {
        return this.getFileContentData(100000);
    }

    @Override
    public FileContentData getFileContentData(int maxContentLength) {
        if (this.contentData == null) {
            this.contentData = this.contentParser.getFileContentData(maxContentLength);
        }
        return this.contentData;
    }

    @Override
    public String getDetectedLanguage() {
        if (this.getFileContentData() != null) {
            if (this.contentData.getLanguage() == null && this.contentParser != null) {
                this.contentParser.getContentLanguage();
            }
            return this.contentData.getLanguage();
        }
        return null;
    }
}

