/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.transaction.request;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teamapps.universaldb.index.transaction.TransactionType;
import org.teamapps.universaldb.index.transaction.request.TransactionRequestRecord;
import org.teamapps.universaldb.index.transaction.request.TransactionRequestRecordType;
import org.teamapps.universaldb.model.DatabaseModel;

public class TransactionRequest {
    private final long nodeId;
    private final long requestId;
    private final TransactionType transactionType;
    private final int userId;
    private final long timestamp;
    private final List<TransactionRequestRecord> records = new ArrayList<TransactionRequestRecord>();
    private DatabaseModel databaseModel;
    private final Set<Integer> createRecordCorrelationSet = new HashSet<Integer>();
    private final Map<Integer, Integer> recordIdByCorrelationId = new HashMap<Integer, Integer>();

    public TransactionRequest(long nodeId, long requestId, int userId) {
        this(nodeId, requestId, userId, System.currentTimeMillis());
    }

    public TransactionRequest(long nodeId, long requestId, int userId, long timestamp) {
        this.nodeId = nodeId;
        this.requestId = requestId;
        this.transactionType = TransactionType.DATA_UPDATE;
        this.userId = userId;
        this.timestamp = timestamp;
    }

    public TransactionRequest(long nodeId, long requestId, int userId, DatabaseModel databaseModel) {
        this.nodeId = nodeId;
        this.requestId = requestId;
        this.transactionType = TransactionType.MODEL_UPDATE;
        this.userId = userId;
        this.timestamp = System.currentTimeMillis();
        this.databaseModel = databaseModel;
    }

    public TransactionRequest(byte[] bytes) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
        this.nodeId = dis.readLong();
        this.requestId = dis.readLong();
        this.transactionType = TransactionType.getById(dis.readUnsignedByte());
        this.userId = dis.readInt();
        this.timestamp = dis.readLong();
        if (this.transactionType == TransactionType.DATA_UPDATE) {
            int size = dis.readInt();
            for (int i = 0; i < size; ++i) {
                this.records.add(new TransactionRequestRecord(dis));
            }
        } else {
            this.databaseModel = new DatabaseModel(dis);
        }
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeLong(this.nodeId);
        dos.writeLong(this.requestId);
        dos.writeByte(this.transactionType.getId());
        dos.writeInt(this.userId);
        dos.writeLong(this.timestamp);
        if (this.transactionType == TransactionType.DATA_UPDATE) {
            dos.writeInt(this.records.size());
            for (TransactionRequestRecord record : this.records) {
                record.write(dos);
            }
        } else {
            this.databaseModel.write(dos);
        }
        return bos.toByteArray();
    }

    public void addRecord(TransactionRequestRecord record) {
        if (record.getRecordType() != TransactionRequestRecordType.CREATE || !this.createRecordCorrelationSet.contains(record.getCorrelationId())) {
            this.createRecordCorrelationSet.add(record.getCorrelationId());
            this.records.add(record);
        }
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public int getUserId() {
        return this.userId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<TransactionRequestRecord> getRecords() {
        return this.records;
    }

    public DatabaseModel getDatabaseModel() {
        return this.databaseModel;
    }

    public int getResolvedRecordIdByCorrelationId(int correlationId) {
        if (this.recordIdByCorrelationId.containsKey(correlationId)) {
            return this.recordIdByCorrelationId.get(correlationId);
        }
        return 0;
    }

    public void putResolvedRecordIdForCorrelationId(int correlationId, int recordId) {
        this.recordIdByCorrelationId.put(correlationId, recordId);
    }

    public Map<Integer, Integer> getRecordIdByCorrelationId() {
        return this.recordIdByCorrelationId;
    }
}

