/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.transaction.resolved.legacy;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.MappedObject;
import org.teamapps.universaldb.index.log.DefaultLogIndex;
import org.teamapps.universaldb.index.log.LogIterator;
import org.teamapps.universaldb.index.log.RotatingLogIndex;
import org.teamapps.universaldb.index.transaction.resolved.legacy.LegacyResolvedTransaction;
import org.teamapps.universaldb.index.transaction.resolved.legacy.LegacyResolvedTransactionRecordValue;
import org.teamapps.universaldb.schema.Column;
import org.teamapps.universaldb.schema.Schema;

public class TransactionLegacyConverter {
    public static void convertLegacyTransactionIndex(File transactionsPath, File fileStorePath, Set<String> filteredDbs) throws Exception {
        RotatingLogIndex logIndex = new RotatingLogIndex(transactionsPath, "transactions");
        DefaultLogIndex models = new DefaultLogIndex(transactionsPath, "schemas");
        Schema schema = models.readAllLogs().stream().map(bytes -> {
            try {
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream((byte[])bytes));
                Schema model = new Schema(dis);
                dis.readLong();
                dis.readLong();
                return model;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).reduce((first, second) -> second).orElse(null);
        Map<Integer, String> fileFieldById = schema.getDatabases().stream().flatMap(db -> db.getTables().stream()).flatMap(table -> table.getColumns().stream()).filter(column -> column.getType() == ColumnType.FILE).collect(Collectors.toMap(Column::getMappingId, column -> column.getFQN().replace('.', '/')));
        Map<Integer, String> fqnById = Stream.concat(Stream.concat(schema.getDatabases().stream().map(e -> e), schema.getDatabases().stream().flatMap(db -> db.getTables().stream()).map(e -> e)), schema.getDatabases().stream().flatMap(db -> db.getTables().stream()).flatMap(table -> table.getColumns().stream()).map(e -> e)).collect(Collectors.toMap(MappedObject::getMappingId, MappedObject::getFQN));
        HashMap dbByMappingId = new HashMap();
        schema.getDatabases().stream().forEach(e -> dbByMappingId.put(e.getMappingId(), e.getFQN()));
        schema.getDatabases().stream().flatMap(db -> db.getTables().stream()).forEach(e -> dbByMappingId.put(e.getMappingId(), e.getDatabase().getFQN()));
        schema.getDatabases().stream().flatMap(db -> db.getTables().stream()).flatMap(t -> t.getColumns().stream()).forEach(e -> dbByMappingId.put(e.getMappingId(), e.getTable().getDatabase().getFQN()));
        BiFunction<String, Integer, File> fileByUuidAndFieldId = (uuid, fieldId) -> {
            String relativePath = (String)fileFieldById.get(fieldId);
            return new File(fileStorePath, relativePath + "/" + uuid.substring(0, 4) + "/" + uuid);
        };
        LegacyResolvedTransactionRecordValue.setFileByUuidAndFieldId(fileByUuidAndFieldId);
        HashMap<String, Integer> recordsByTable = new HashMap<String, Integer>();
        int maxRecords = 0;
        LogIterator iterator = logIndex.readLogs();
        int counter = 0;
        int schemaUpdates = 0;
        int countManyRecs = 0;
        int countMoreThanOne = 0;
        long time = System.currentTimeMillis();
        while (iterator.hasNext()) {
            int size;
            byte[] bytes2 = iterator.next();
            LegacyResolvedTransaction resolvedTransaction = LegacyResolvedTransaction.createResolvedTransaction(bytes2);
            int n = size = resolvedTransaction.getTransactionRecords() == null ? 0 : resolvedTransaction.getTransactionRecords().size();
            if (size > 0) {
                recordsByTable.compute((String)dbByMappingId.get(resolvedTransaction.getTransactionRecords().get(0).getTableId()), (k, v) -> v == null ? 1 : v + 1);
                if (size > 1) {
                    long count = resolvedTransaction.getTransactionRecords().stream().map(tr -> (String)dbByMappingId.get(tr.getTableId())).distinct().count();
                    if (count > 1L) {
                        System.out.println("Multi dbs:" + count);
                    }
                    ++countMoreThanOne;
                }
            } else {
                ++schemaUpdates;
            }
            if (size > 100) {
                ++countManyRecs;
            }
            maxRecords = Math.max(maxRecords, size);
            if (++counter % 250000 != 0) continue;
            System.out.println("Transactions: " + counter + ", files:" + LegacyResolvedTransactionRecordValue.fileCounter + ", time: " + (System.currentTimeMillis() - time));
        }
        iterator.close();
        LegacyResolvedTransactionRecordValue.pathCounts.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> System.out.println((String)e.getKey() + ": " + String.valueOf(e.getValue())));
        System.out.println("Schema updates:" + schemaUpdates);
        System.out.println("Max records: " + maxRecords);
        System.out.println("Many records: " + countManyRecs);
        System.out.println("More than one: " + countMoreThanOne);
        System.out.println("---");
        recordsByTable.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> System.out.println((String)e.getKey() + ": " + String.valueOf(e.getValue())));
        System.out.println("---");
        System.out.println("DONE, time: " + (System.currentTimeMillis() - time) + ", files:" + LegacyResolvedTransactionRecordValue.fileCounter);
    }
}

