/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb;

import java.io.File;
import org.teamapps.universaldb.DatabaseManager;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.file.store.DatabaseFileStore;
import org.teamapps.universaldb.index.file.store.LocalDatabaseFileStore;
import org.teamapps.universaldb.schema.ModelProvider;

public class UniversalDbBuilder {
    private ModelProvider modelProvider;
    private File basePath;
    private File indexPath;
    private File fullTextIndexPath;
    private File transactionLogPath;
    private File fileStorePath;
    private DatabaseFileStore fileStore;
    private DatabaseManager databaseManager;
    private ClassLoader classLoader;
    private boolean skipTransactionIndexCheck = false;

    public static UniversalDbBuilder create() {
        return new UniversalDbBuilder();
    }

    public UniversalDbBuilder basePath(File basePath) {
        this.basePath = basePath;
        return this;
    }

    public UniversalDbBuilder indexPath(File indexPath) {
        this.indexPath = indexPath;
        return this;
    }

    public UniversalDbBuilder fullTextIndexPath(File fullTextIndexPath) {
        this.fullTextIndexPath = fullTextIndexPath;
        return this;
    }

    public UniversalDbBuilder transactionLogPath(File transactionLogPath) {
        this.transactionLogPath = transactionLogPath;
        return this;
    }

    public UniversalDbBuilder fileStorePath(File filesPath) {
        this.fileStorePath = filesPath;
        return this;
    }

    public UniversalDbBuilder fileStore(DatabaseFileStore fileStore) {
        this.fileStore = fileStore;
        return this;
    }

    public UniversalDbBuilder modelProvider(ModelProvider modelProvider) {
        this.modelProvider = modelProvider;
        return this;
    }

    public UniversalDbBuilder databaseManager(DatabaseManager databaseManager) {
        this.databaseManager = databaseManager;
        return this;
    }

    public UniversalDbBuilder classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public UniversalDbBuilder skipTransactionIndexCheck(boolean skipTransactionIndexCheck) {
        this.skipTransactionIndexCheck = skipTransactionIndexCheck;
        return this;
    }

    public UniversalDB build() throws Exception {
        if (this.basePath != null) {
            if (this.indexPath == null) {
                this.indexPath = new File(this.basePath, "index");
                this.indexPath.mkdir();
            }
            if (this.fullTextIndexPath == null) {
                this.fullTextIndexPath = new File(this.basePath, "text");
                this.fullTextIndexPath.mkdir();
            }
            if (this.transactionLogPath == null) {
                this.transactionLogPath = new File(this.basePath, "transactions");
                this.transactionLogPath.mkdir();
            }
            if (this.fileStorePath == null && this.fileStore == null) {
                this.fileStorePath = new File(this.basePath, "files");
                this.fileStorePath.mkdir();
            }
        }
        if (this.fileStore == null) {
            this.fileStore = new LocalDatabaseFileStore(this.fileStorePath);
        }
        if (this.databaseManager == null) {
            this.databaseManager = DatabaseManager.getBaseInstance();
        }
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
        return new UniversalDB(this.modelProvider, this.databaseManager, this.fileStore, this.indexPath, this.fullTextIndexPath, this.transactionLogPath, this.classLoader, this.skipTransactionIndexCheck);
    }
}

