/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.teamapps.universaldb.DatabaseManager;
import org.teamapps.universaldb.index.DatabaseIndex;
import org.teamapps.universaldb.index.FieldIndex;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.file.FileIndex;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.file.store.DatabaseFileStore;
import org.teamapps.universaldb.index.reference.CyclicReferenceUpdate;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.reference.value.MultiReferenceEditValue;
import org.teamapps.universaldb.index.reference.value.RecordReference;
import org.teamapps.universaldb.index.reference.value.ResolvedMultiReferenceUpdate;
import org.teamapps.universaldb.index.text.FullTextIndexValue;
import org.teamapps.universaldb.index.transaction.TransactionIndex;
import org.teamapps.universaldb.index.transaction.TransactionType;
import org.teamapps.universaldb.index.transaction.request.TransactionRequest;
import org.teamapps.universaldb.index.transaction.request.TransactionRequestRecord;
import org.teamapps.universaldb.index.transaction.request.TransactionRequestRecordType;
import org.teamapps.universaldb.index.transaction.request.TransactionRequestRecordValue;
import org.teamapps.universaldb.index.transaction.resolved.ResolvedTransaction;
import org.teamapps.universaldb.index.transaction.resolved.ResolvedTransactionRecord;
import org.teamapps.universaldb.index.transaction.resolved.ResolvedTransactionRecordType;
import org.teamapps.universaldb.index.transaction.resolved.ResolvedTransactionRecordValue;
import org.teamapps.universaldb.index.transaction.schema.ModelUpdate;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.universaldb.model.DatabaseModel;
import org.teamapps.universaldb.model.TableModel;
import org.teamapps.universaldb.schema.ModelProvider;
import org.teamapps.universaldb.update.RecordUpdateEvent;

public class UniversalDB {
    public static final Marker SKIP_DB_LOGGING = MarkerFactory.getMarker((String)"SKIP_DB_LOGGING");
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final ThreadLocal<Integer> THREAD_LOCAL_USER_ID = ThreadLocal.withInitial(() -> 0);
    private final DatabaseManager databaseManager;
    private final DatabaseIndex databaseIndex;
    private final DatabaseFileStore fileStore;
    private final File indexPath;
    private final File fullTextIndexPath;
    private final File transactionLogPath;
    private final TransactionIndex transactionIndex;
    private final Map<Integer, TableIndex> tableById = new HashMap<Integer, TableIndex>();
    private final Map<Integer, FieldIndex> columnById = new HashMap<Integer, FieldIndex>();
    private final Map<TableIndex, Class> entityClassByTableIndex = new HashMap<TableIndex, Class>();
    private final Map<TableIndex, Class> queryClassByTableIndex = new HashMap<TableIndex, Class>();
    private final ArrayBlockingQueue<RecordUpdateEvent> updateEventQueue = new ArrayBlockingQueue(25000);
    private final Map<Long, CompletableFuture<ResolvedTransaction>> transactionCompletableFutureMap = new ConcurrentHashMap<Long, CompletableFuture<ResolvedTransaction>>();

    protected UniversalDB(ModelProvider modelProvider, DatabaseManager databaseManager, DatabaseFileStore fileStore, File indexPath, File fullTextIndexPath, File transactionLogPath, ClassLoader classLoader, boolean skipTransactionIndexCheck) throws Exception {
        this.databaseManager = databaseManager;
        this.fileStore = fileStore;
        this.indexPath = indexPath;
        this.fullTextIndexPath = fullTextIndexPath;
        this.transactionLogPath = transactionLogPath;
        this.transactionIndex = new TransactionIndex(transactionLogPath, skipTransactionIndexCheck);
        this.createShutdownHook();
        DatabaseModel model = modelProvider.getModel();
        if (!model.isValid()) {
            throw new RuntimeException("Error invalid database model:" + model.getName());
        }
        if (!this.transactionIndex.isValidModel(model)) {
            throw new RuntimeException("Cannot load incompatible model. Current model is:\n" + String.valueOf(this.transactionIndex.getCurrentModel()) + "\nNew model is:\n" + String.valueOf(model));
        }
        this.databaseIndex = new DatabaseIndex(model.getName(), indexPath, fullTextIndexPath, fileStore);
        if (this.transactionIndex.isModelUpdate(model)) {
            this.executeTransaction(this.createModelUpdateTransactionRequest(model));
        } else {
            DatabaseModel currentModel = this.transactionIndex.getCurrentModel();
            this.mergeDatabaseIndex(currentModel);
        }
        this.installLocalTableClasses(classLoader);
        databaseManager.registerDatabase(model.getName(), this, UniversalDB.class.getClassLoader());
    }

    private void mergeDatabaseIndex(DatabaseModel currentModel) {
        this.databaseIndex.installModel(currentModel, true, this);
        for (TableIndex table : this.databaseIndex.getTables()) {
            this.tableById.put(table.getMappingId(), table);
            for (FieldIndex fieldIndex : table.getFieldIndices()) {
                this.columnById.put(fieldIndex.getMappingId(), fieldIndex);
            }
        }
    }

    public static int getUserId() {
        return THREAD_LOCAL_USER_ID.get();
    }

    public static void setUserId(int userId) {
        THREAD_LOCAL_USER_ID.set(userId);
    }

    private void createShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                logger.info(SKIP_DB_LOGGING, "SHUTTING DOWN DATABASE");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }));
    }

    private void installLocalTableClasses(ClassLoader classLoader) throws Exception {
        DatabaseModel currentModel = this.transactionIndex.getCurrentModel();
        for (TableModel tableModel : currentModel.getLocalTables()) {
            TableIndex tableIndex = this.databaseIndex.getTable(tableModel.getName());
            this.installTablePojos(classLoader, currentModel.getFullNameSpace(), tableModel, tableIndex);
        }
    }

    public void installRemoteTableClasses(ClassLoader classLoader) {
        try {
            DatabaseModel currentModel = this.transactionIndex.getCurrentModel();
            for (TableModel remoteTable : currentModel.getRemoteTables()) {
                UniversalDB remoteDb = this.databaseManager.getDatabase(remoteTable.getRemoteDatabase());
                TableIndex tableIndex = remoteDb.getDatabaseIndex().getTable(remoteTable.getRemoteTableName());
                String fullNameSpace = remoteTable.getRemoteDatabaseNamespace() != null ? remoteTable.getRemoteDatabaseNamespace() + "." + remoteTable.getRemoteDatabase().toLowerCase() : currentModel.getFullNameSpace();
                this.installTablePojos(classLoader, fullNameSpace, remoteTable, tableIndex);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void installTablePojos(ClassLoader classLoader, String fullNamespace, TableModel tableModel, TableIndex tableIndex) throws Exception {
        String tableName = tableModel.getName();
        try {
            String className = fullNamespace + ".Udb" + tableName.substring(0, 1).toUpperCase() + tableName.substring(1);
            Class<?> schemaClass = Class.forName(className, true, classLoader);
            Method method = schemaClass.getDeclaredMethod("setTableIndex", TableIndex.class, UniversalDB.class);
            method.setAccessible(true);
            method.invoke(null, tableIndex, this);
            String queryClassName = fullNamespace + ".Udb" + tableName.substring(0, 1).toUpperCase() + tableName.substring(1) + "Query";
            Class<?> queryClass = Class.forName(queryClassName, true, classLoader);
            this.entityClassByTableIndex.put(tableIndex, schemaClass);
            this.queryClassByTableIndex.put(tableIndex, queryClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load entity class for tableIndex:" + tableIndex.getFQN() + ", " + e.getMessage());
        }
        catch (Exception e) {
            throw e;
        }
    }

    public void installModelUpdate(ModelProvider modelProvider, ClassLoader classLoader) throws Exception {
        DatabaseModel model = modelProvider.getModel();
        if (!this.transactionIndex.isValidModel(model)) {
            throw new RuntimeException("Cannot load incompatible model. Current model is:\n" + String.valueOf(this.transactionIndex.getCurrentModel()) + "\nNew model is:\n" + String.valueOf(model));
        }
        if (this.transactionIndex.isModelUpdate(model)) {
            TransactionRequest modelUpdateTransactionRequest = this.createModelUpdateTransactionRequest(model);
            this.executeTransaction(modelUpdateTransactionRequest);
        }
        this.installLocalTableClasses(classLoader);
        this.installRemoteTableClasses(classLoader);
    }

    public Class getEntityClass(TableIndex tableIndex) {
        return this.entityClassByTableIndex.get(tableIndex);
    }

    public Class getQueryClass(TableIndex tableIndex) {
        return this.queryClassByTableIndex.get(tableIndex);
    }

    public synchronized TransactionRequest createTransactionRequest() {
        return new TransactionRequest(this.transactionIndex.getNodeId(), this.transactionIndex.createTransactionRequestId(), UniversalDB.getUserId());
    }

    public synchronized TransactionRequest createModelUpdateTransactionRequest(DatabaseModel databaseModel) {
        return new TransactionRequest(this.transactionIndex.getNodeId(), this.transactionIndex.createTransactionRequestId(), UniversalDB.getUserId(), databaseModel);
    }

    public synchronized void createInitialTableTransactions(TableIndex tableIndex) throws Exception {
        if (!tableIndex.getRecordVersioningIndex().isEmpty()) {
            return;
        }
        BitSet records = tableIndex.getRecords();
        int id = records.nextSetBit(0);
        while (id >= 0) {
            this.writeInitialTransaction(tableIndex, id, false);
            id = records.nextSetBit(id + 1);
        }
        if (tableIndex.isKeepDeletedRecords()) {
            records = tableIndex.getDeletedRecords();
            id = records.nextSetBit(0);
            while (id >= 0) {
                this.writeInitialTransaction(tableIndex, id, true);
                id = records.nextSetBit(id + 1);
            }
        }
    }

    private void writeInitialTransaction(TableIndex tableIndex, int recordId, boolean deleted) throws Exception {
        ResolvedTransaction transaction = this.createInitialTransaction(tableIndex, recordId, false);
        ResolvedTransactionRecord record = new ResolvedTransactionRecord(ResolvedTransactionRecordType.CREATE_WITH_ID, tableIndex.getMappingId(), recordId);
        transaction.addTransactionRecord(record);
        List<FieldIndex> columnIndices = tableIndex.getFieldIndices().stream().filter(col -> !col.isEmpty(recordId)).toList();
        for (FieldIndex column : columnIndices) {
            ResolvedTransactionRecordValue recordValue = this.createInitialTransactionRecordValue(column, recordId);
            record.addRecordValue(recordValue);
        }
        tableIndex.getRecordVersioningIndex().writeRecordUpdate(transaction, record);
        this.transactionIndex.writeTransaction(transaction);
        if (deleted) {
            transaction = this.createInitialTransaction(tableIndex, recordId, true);
            record = new ResolvedTransactionRecord(ResolvedTransactionRecordType.DELETE, tableIndex.getMappingId(), recordId);
            transaction.addTransactionRecord(record);
            record.addRecordValue(this.createInitialTransactionRecordValue(tableIndex.getFieldIndex("metaDeletionDate"), recordId));
            record.addRecordValue(this.createInitialTransactionRecordValue(tableIndex.getFieldIndex("metaDeletedBy"), recordId));
            tableIndex.getRecordVersioningIndex().writeRecordUpdate(transaction, record);
            this.transactionIndex.writeTransaction(transaction);
        }
    }

    private ResolvedTransaction createInitialTransaction(TableIndex tableIndex, int recordId, boolean deleted) {
        long transactionId = this.transactionIndex.getLastTransactionId() + 1L;
        int userId = 0;
        int timestamp = 0;
        FieldIndex dateColumn = tableIndex.getFieldIndex(deleted ? "metaDeletionDate" : "metaCreationDate");
        FieldIndex userRefColumn = tableIndex.getFieldIndex(deleted ? "metaDeletedBy" : "metaCreatedBy");
        if (dateColumn != null && userRefColumn != null) {
            userId = (Integer)userRefColumn.getGenericValue(recordId);
            timestamp = (Integer)dateColumn.getGenericValue(recordId);
        }
        return new ResolvedTransaction(this.transactionIndex.getNodeId(), this.transactionIndex.createTransactionRequestId(), transactionId, userId, (long)timestamp * 1000L);
    }

    private ResolvedTransactionRecordValue createInitialTransactionRecordValue(FieldIndex column, int recordId) {
        switch (column.getType()) {
            case BOOLEAN: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case TEXT: 
            case TRANSLATABLE_TEXT: 
            case BINARY: {
                Object value = column.getGenericValue(recordId);
                return new ResolvedTransactionRecordValue(column.getMappingId(), column.getType(), value);
            }
            case REFERENCE: {
                SingleReferenceIndex singleReferenceIndex = (SingleReferenceIndex)column;
                int referencedRecordId = singleReferenceIndex.getValue(recordId);
                return new ResolvedTransactionRecordValue(column.getMappingId(), column.getType(), referencedRecordId);
            }
            case MULTI_REFERENCE: {
                MultiReferenceIndex multiReferenceIndex = (MultiReferenceIndex)column;
                List<Integer> references = multiReferenceIndex.getReferencesAsList(recordId);
                ResolvedMultiReferenceUpdate multiReferenceUpdate = ResolvedMultiReferenceUpdate.createSetReferences(references);
                return new ResolvedTransactionRecordValue(column.getMappingId(), column.getType(), multiReferenceUpdate);
            }
            case FILE: {
                FileIndex fileIndex = (FileIndex)column;
                FileValue fileValue = fileIndex.getValue(recordId);
                return new ResolvedTransactionRecordValue(column.getMappingId(), column.getType(), fileValue);
            }
        }
        return null;
    }

    public ResolvedTransaction executeTransaction(TransactionRequest transaction) {
        try {
            return this.handleTransactionRequest(transaction);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private synchronized ResolvedTransaction handleTransactionRequest(TransactionRequest transactionRequest) throws Exception {
        TransactionType transactionType = transactionRequest.getTransactionType();
        long transactionId = this.transactionIndex.getLastTransactionId() + 1L;
        ResolvedTransaction resolvedTransaction = ResolvedTransaction.createFromRequest(transactionId, transactionRequest);
        if (transactionType == TransactionType.DATA_UPDATE) {
            this.handleDataUpdateRequest(transactionRequest, resolvedTransaction);
        } else {
            this.handleModelUpdateRequest(transactionRequest, resolvedTransaction);
        }
        return resolvedTransaction;
    }

    private void handleModelUpdateRequest(TransactionRequest request, ResolvedTransaction resolvedTransaction) throws Exception {
        DatabaseModel model = request.getDatabaseModel();
        if (!this.transactionIndex.isValidModel(model)) {
            throw new RuntimeException("Cannot update incompatible model. Current model is:\n" + String.valueOf(this.transactionIndex.getCurrentModel()) + "\nNew model is:\n" + String.valueOf(model));
        }
        ModelUpdate modelUpdate = resolvedTransaction.getModelUpdate();
        this.transactionIndex.writeTransaction(resolvedTransaction);
        this.transactionIndex.writeModelUpdate(modelUpdate);
        this.mergeDatabaseIndex(modelUpdate.getMergedModel());
    }

    private void handleDataUpdateRequest(TransactionRequest request, ResolvedTransaction resolvedTransaction) throws Exception {
        int recordId;
        TableIndex tableIndex;
        for (TransactionRequestRecord record : request.getRecords()) {
            if (record.getRecordType() != TransactionRequestRecordType.CREATE && record.getRecordType() != TransactionRequestRecordType.CREATE_WITH_ID) continue;
            tableIndex = this.getTableIndexById(record.getTableId());
            recordId = tableIndex.createRecord(record.getRecordId());
            request.putResolvedRecordIdForCorrelationId(record.getCorrelationId(), recordId);
        }
        for (TransactionRequestRecord record : request.getRecords()) {
            tableIndex = this.getTableIndexById(record.getTableId());
            if (record.isTransactionProcessingStarted()) {
                logger.error("Prevented processing of record again:" + record.getTableId() + ":" + record.getRecordId());
                continue;
            }
            record.setTransactionProcessingStarted(true);
            recordId = record.getRecordId() != 0 ? record.getRecordId() : request.getResolvedRecordIdByCorrelationId(record.getCorrelationId());
            ResolvedTransactionRecord resolvedRecord = ResolvedTransactionRecord.createFromRequest(record, recordId);
            resolvedTransaction.addTransactionRecord(resolvedRecord);
            switch (record.getRecordType()) {
                case CREATE: 
                case CREATE_WITH_ID: 
                case UPDATE: {
                    for (TransactionRequestRecordValue recordValue : record.getRecordValues()) {
                        List<CyclicReferenceUpdate> cyclicReferenceUpdates = this.persistColumnValueUpdates(recordId, recordValue, request.getRecordIdByCorrelationId(), resolvedRecord);
                        if (cyclicReferenceUpdates == null || cyclicReferenceUpdates.isEmpty()) continue;
                        for (CyclicReferenceUpdate referenceUpdate : cyclicReferenceUpdates) {
                            resolvedTransaction.addTransactionRecord(ResolvedTransactionRecord.createCyclicRecord(referenceUpdate));
                        }
                    }
                    List<FullTextIndexValue> fullTextIndexValues = record.getRecordValues().stream().filter(value -> value.getIndexType() == IndexType.TEXT || value.getIndexType() == IndexType.TRANSLATABLE_TEXT).map(value -> {
                        String columnName = this.getColumnById(value.getColumnId()).getName();
                        return value.getIndexType() == IndexType.TEXT ? new FullTextIndexValue(columnName, (String)value.getValue()) : new FullTextIndexValue(columnName, (TranslatableText)value.getValue());
                    }).collect(Collectors.toList());
                    if (fullTextIndexValues.isEmpty()) break;
                    tableIndex.updateFullTextIndex(recordId, fullTextIndexValues, record.getRecordType() == TransactionRequestRecordType.UPDATE);
                    break;
                }
                case DELETE: {
                    List<CyclicReferenceUpdate> cyclicReferenceUpdates = tableIndex.deleteRecord(record.getRecordId());
                    for (TransactionRequestRecordValue recordValue : record.getRecordValues()) {
                        this.persistColumnValueUpdates(recordId, recordValue, request.getRecordIdByCorrelationId(), resolvedRecord);
                    }
                    if (cyclicReferenceUpdates == null || cyclicReferenceUpdates.isEmpty()) break;
                    for (CyclicReferenceUpdate referenceUpdate : cyclicReferenceUpdates) {
                        resolvedTransaction.addTransactionRecord(ResolvedTransactionRecord.createCyclicRecord(referenceUpdate));
                    }
                    break;
                }
                case RESTORE: {
                    List<CyclicReferenceUpdate> cyclicReferenceUpdates = tableIndex.restoreRecord(record.getRecordId());
                    for (TransactionRequestRecordValue recordValue : record.getRecordValues()) {
                        this.persistColumnValueUpdates(recordId, recordValue, request.getRecordIdByCorrelationId(), resolvedRecord);
                    }
                    if (cyclicReferenceUpdates == null || cyclicReferenceUpdates.isEmpty()) break;
                    for (CyclicReferenceUpdate referenceUpdate : cyclicReferenceUpdates) {
                        resolvedTransaction.addTransactionRecord(ResolvedTransactionRecord.createCyclicRecord(referenceUpdate));
                    }
                    break;
                }
            }
            this.addRecordUpdateEvent(resolvedRecord, resolvedTransaction.getUserId());
        }
        this.transactionIndex.writeTransaction(resolvedTransaction);
        for (ResolvedTransactionRecord transactionRecord : resolvedTransaction.getTransactionRecords()) {
            tableIndex = this.getTableIndexById(transactionRecord.getTableId());
            if (!tableIndex.getTableModel().isVersioning()) continue;
            tableIndex.getRecordVersioningIndex().writeRecordUpdate(resolvedTransaction, transactionRecord);
        }
        resolvedTransaction.setRecordIdByCorrelationId(request.getRecordIdByCorrelationId());
    }

    public synchronized void handleTransaction(ResolvedTransaction transaction) throws Exception {
        if (transaction.getTransactionType() == TransactionType.DATA_UPDATE) {
            this.handleDataUpdateTransaction(transaction);
        } else {
            this.handleModelUpdateTransaction(transaction);
        }
    }

    private void handleModelUpdateTransaction(ResolvedTransaction transaction) throws Exception {
        DatabaseModel model = transaction.getModelUpdate().getMergedModel();
        DatabaseModel currentModel = this.transactionIndex.getCurrentModel();
        if (currentModel != null) {
            currentModel.mergeModel(model);
        } else {
            currentModel = model;
        }
        this.transactionIndex.writeTransaction(transaction);
        this.transactionIndex.writeModelUpdate(transaction.getModelUpdate());
        this.mergeDatabaseIndex(currentModel);
    }

    private void handleDataUpdateTransaction(ResolvedTransaction transaction) throws Exception {
        TableIndex tableIndex;
        for (ResolvedTransactionRecord record : transaction.getTransactionRecords()) {
            tableIndex = this.getTableIndexById(record.getTableId());
            switch (record.getRecordType()) {
                case CREATE: 
                case CREATE_WITH_ID: 
                case UPDATE: {
                    if (record.getRecordType() == ResolvedTransactionRecordType.CREATE || record.getRecordType() == ResolvedTransactionRecordType.CREATE_WITH_ID) {
                        tableIndex.createRecord(record.getRecordId());
                    }
                    for (ResolvedTransactionRecordValue recordValue : record.getRecordValues()) {
                        this.persistColumnValueUpdates(record.getRecordId(), recordValue);
                    }
                    List<FullTextIndexValue> fullTextIndexValues = record.getRecordValues().stream().filter(value -> value.getIndexType() == IndexType.TEXT || value.getIndexType() == IndexType.TRANSLATABLE_TEXT).map(value -> {
                        String columnName = this.getColumnById(value.getColumnId()).getName();
                        return value.getIndexType() == IndexType.TEXT ? new FullTextIndexValue(columnName, (String)value.getValue()) : new FullTextIndexValue(columnName, (TranslatableText)value.getValue());
                    }).collect(Collectors.toList());
                    if (fullTextIndexValues.isEmpty()) break;
                    tableIndex.updateFullTextIndex(record.getRecordId(), fullTextIndexValues, record.getRecordType() == ResolvedTransactionRecordType.UPDATE);
                    break;
                }
                case DELETE: {
                    tableIndex.deleteRecord(record.getRecordId());
                    for (ResolvedTransactionRecordValue recordValue : record.getRecordValues()) {
                        this.persistColumnValueUpdates(record.getRecordId(), recordValue);
                    }
                    break;
                }
                case RESTORE: {
                    tableIndex.restoreRecord(record.getRecordId());
                    for (ResolvedTransactionRecordValue recordValue : record.getRecordValues()) {
                        this.persistColumnValueUpdates(record.getRecordId(), recordValue);
                    }
                    break;
                }
            }
            this.addRecordUpdateEvent(record, transaction.getUserId());
        }
        this.transactionIndex.writeTransaction(transaction);
        for (ResolvedTransactionRecord transactionRecord : transaction.getTransactionRecords()) {
            tableIndex = this.getTableIndexById(transactionRecord.getTableId());
            if (!tableIndex.getTableModel().isVersioning()) continue;
            tableIndex.getRecordVersioningIndex().writeRecordUpdate(transaction, transactionRecord);
        }
    }

    private List<CyclicReferenceUpdate> persistColumnValueUpdates(int recordId, TransactionRequestRecordValue recordValue, Map<Integer, Integer> recordIdByCorrelationId, ResolvedTransactionRecord resolvedRecord) {
        FieldIndex fieldIndex = this.getColumnById(recordValue.getColumnId());
        Object value = recordValue.getValue();
        if (fieldIndex.getType() == IndexType.MULTI_REFERENCE) {
            MultiReferenceIndex multiReferenceIndex = (MultiReferenceIndex)fieldIndex;
            MultiReferenceEditValue editValue = (MultiReferenceEditValue)value;
            editValue.updateReferences(recordIdByCorrelationId);
            ResolvedMultiReferenceUpdate resolvedUpdateValue = editValue.getResolvedUpdateValue();
            resolvedRecord.addRecordValue(new ResolvedTransactionRecordValue(recordValue.getColumnId(), recordValue.getIndexType(), resolvedUpdateValue));
            return multiReferenceIndex.setReferenceEditValue(recordId, editValue);
        }
        if (fieldIndex.getType() == IndexType.REFERENCE) {
            SingleReferenceIndex singleReferenceIndex = (SingleReferenceIndex)fieldIndex;
            if (value != null) {
                RecordReference recordReference = (RecordReference)value;
                recordReference.updateReference(recordIdByCorrelationId);
                resolvedRecord.addRecordValue(new ResolvedTransactionRecordValue(recordValue.getColumnId(), recordValue.getIndexType(), recordReference.getRecordId()));
                return singleReferenceIndex.setReferenceValue(recordId, recordReference);
            }
            resolvedRecord.addRecordValue(new ResolvedTransactionRecordValue(recordValue.getColumnId(), recordValue.getIndexType(), null));
            return singleReferenceIndex.setReferenceValue(recordId, null);
        }
        fieldIndex.setGenericValue(recordId, value);
        resolvedRecord.addRecordValue(new ResolvedTransactionRecordValue(recordValue.getColumnId(), recordValue.getIndexType(), value));
        return null;
    }

    private void persistColumnValueUpdates(int recordId, ResolvedTransactionRecordValue recordValue) {
        FieldIndex fieldIndex = this.getColumnById(recordValue.getColumnId());
        Object value = recordValue.getValue();
        if (fieldIndex.getType() == IndexType.MULTI_REFERENCE) {
            MultiReferenceIndex multiReferenceIndex = (MultiReferenceIndex)fieldIndex;
            ResolvedMultiReferenceUpdate multiReferenceUpdate = (ResolvedMultiReferenceUpdate)value;
            multiReferenceIndex.setResolvedReferenceEditValue(recordId, multiReferenceUpdate);
        } else if (fieldIndex.getType() == IndexType.REFERENCE) {
            SingleReferenceIndex singleReferenceIndex = (SingleReferenceIndex)fieldIndex;
            if (value != null) {
                int referencedRecordId = (Integer)value;
                singleReferenceIndex.setValue(recordId, referencedRecordId, false);
            } else {
                singleReferenceIndex.setValue(recordId, 0, false);
            }
        } else {
            fieldIndex.setGenericValue(recordId, value);
        }
    }

    public void createDatabaseDump(File dumpFolder) throws IOException {
        File dbFolder = new File(dumpFolder, this.databaseIndex.getName());
        dbFolder.mkdir();
        for (TableIndex table : this.databaseIndex.getTables()) {
            File tableFolder = new File(dbFolder, table.getName());
            tableFolder.mkdir();
            BitSet records = table.getRecords();
            for (FieldIndex fieldIndex : table.getFieldIndices()) {
                File dumpFile = new File(tableFolder, fieldIndex.getName() + ".dbd");
                fieldIndex.dumpIndex(dumpFile, records);
            }
        }
    }

    private void addRecordUpdateEvent(ResolvedTransactionRecord resolvedRecord, int userId) {
        if (userId > 0) {
            RecordUpdateEvent updateEvent = new RecordUpdateEvent(resolvedRecord.getTableId(), resolvedRecord.getRecordId(), userId, resolvedRecord.getRecordType().getUpdateType());
            this.updateEventQueue.offer(updateEvent);
        }
    }

    public TableIndex getTableIndexById(int mappingId) {
        return this.tableById.get(mappingId);
    }

    public FieldIndex getColumnById(int mappingId) {
        return this.columnById.get(mappingId);
    }

    public String getName() {
        return this.databaseIndex.getName();
    }

    public DatabaseIndex getDatabaseIndex() {
        return this.databaseIndex;
    }

    public TransactionIndex getTransactionIndex() {
        return this.transactionIndex;
    }

    public ArrayBlockingQueue<RecordUpdateEvent> getUpdateEventQueue() {
        return this.updateEventQueue;
    }
}

