/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.numeric;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.universaldb.index.enumeration.EnumFilterType;
import org.teamapps.universaldb.index.numeric.NumericFilterType;
import org.teamapps.universaldb.pojo.Entity;

public class NumericFilter {
    private NumericFilterType filterType;
    private Number value1;
    private Number value2;
    private List<Number> values;

    public static NumericFilter equalsFilter(Number number) {
        return new NumericFilter(NumericFilterType.EQUALS, number, null);
    }

    public static NumericFilter notEqualsFilter(Number number) {
        return new NumericFilter(NumericFilterType.NOT_EQUALS, number, null);
    }

    public static NumericFilter greaterFilter(Number number) {
        return new NumericFilter(NumericFilterType.GREATER, number, null);
    }

    public static NumericFilter greaterEqualsFilter(Number number) {
        return new NumericFilter(NumericFilterType.GREATER_EQUALS, number, null);
    }

    public static NumericFilter smallerFilter(Number number) {
        return new NumericFilter(NumericFilterType.SMALLER, number, null);
    }

    public static NumericFilter smallerEqualsFilter(Number number) {
        return new NumericFilter(NumericFilterType.SMALLER_EQUALS, number, null);
    }

    public static NumericFilter betweenFilter(Number number1, Number number2) {
        return new NumericFilter(NumericFilterType.BETWEEN, number1, number2);
    }

    public static NumericFilter betweenExclusiveFilter(Number number1, Number number2) {
        return new NumericFilter(NumericFilterType.BETWEEN_EXCLUSIVE, number1, number2);
    }

    public static NumericFilter containsFilter(Number ... numbers) {
        return new NumericFilter(NumericFilterType.CONTAINS, Arrays.asList(numbers));
    }

    public static NumericFilter containsEntitiesFilter(Collection<? extends Entity> entities) {
        List<Number> list = entities.stream().map(entity -> entity.getId()).collect(Collectors.toList());
        return new NumericFilter(NumericFilterType.CONTAINS, list);
    }

    public static NumericFilter containsFilter(List<Number> numbers) {
        return new NumericFilter(NumericFilterType.CONTAINS, numbers);
    }

    public static NumericFilter containsNotFilter(List<Number> numbers) {
        return new NumericFilter(NumericFilterType.CONTAINS_NOT, numbers);
    }

    public static NumericFilter createEnumFilter(EnumFilterType filterType, Enum ... enums) {
        ArrayList<Number> enumIds = new ArrayList<Number>();
        if (enums != null) {
            for (Enum anEnum : enums) {
                enumIds.add((short)(anEnum.ordinal() + 1));
            }
        }
        return NumericFilter.createEnumFilter(filterType, enumIds);
    }

    public static NumericFilter createEnumFilter(EnumFilterType filterType, List<Number> enumIds) {
        short value = enumIds.isEmpty() ? (short)0 : (Short)enumIds.get(0);
        switch (filterType) {
            case EQUALS: {
                return NumericFilter.equalsFilter(value);
            }
            case NOT_EQUALS: {
                return NumericFilter.notEqualsFilter(value);
            }
            case IS_EMPTY: {
                return NumericFilter.equalsFilter(0);
            }
            case IS_NOT_EMPTY: {
                return NumericFilter.notEqualsFilter(0);
            }
            case CONTAINS: {
                return NumericFilter.containsFilter(enumIds);
            }
            case CONTAINS_NOT: {
                return NumericFilter.containsNotFilter(enumIds);
            }
        }
        return null;
    }

    protected NumericFilter(NumericFilterType filterType, Number value1, Number value2) {
        this.filterType = filterType;
        this.value1 = value1;
        this.value2 = value2;
    }

    protected NumericFilter(NumericFilterType filterType, List<Number> values) {
        this.filterType = filterType;
        this.values = values;
    }

    public NumericFilterType getFilterType() {
        return this.filterType;
    }

    public Number getValue1() {
        return this.value1;
    }

    public Number getValue2() {
        return this.value2;
    }

    public List<Number> getValues() {
        return this.values;
    }

    public String toString() {
        if (this.value2 == null) {
            return String.valueOf((Object)this.filterType) + ":" + String.valueOf(this.value1);
        }
        return String.valueOf((Object)this.filterType) + ":" + String.valueOf(this.value1) + "," + String.valueOf(this.value2);
    }
}

