/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.transaction.resolved.legacy;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.reference.CyclicReferenceUpdate;
import org.teamapps.universaldb.index.reference.value.ResolvedMultiReferenceUpdate;
import org.teamapps.universaldb.index.transaction.request.TransactionRequestRecord;
import org.teamapps.universaldb.index.transaction.resolved.ResolvedTransactionRecordType;
import org.teamapps.universaldb.index.transaction.resolved.legacy.LegacyResolvedTransactionRecordValue;

public class LegacyResolvedTransactionRecord {
    private final ResolvedTransactionRecordType recordType;
    private final int tableId;
    private final int recordId;
    private final List<LegacyResolvedTransactionRecordValue> recordValues = new ArrayList<LegacyResolvedTransactionRecordValue>();

    public LegacyResolvedTransactionRecord(ResolvedTransactionRecordType recordType, int tableId, int recordId) {
        this.recordType = recordType;
        this.tableId = tableId;
        this.recordId = recordId;
    }

    public LegacyResolvedTransactionRecord(DataInputStream dis) throws IOException {
        this.recordType = ResolvedTransactionRecordType.getById(dis.readByte());
        this.tableId = dis.readInt();
        this.recordId = dis.readInt();
        int count = dis.readInt();
        for (int i = 0; i < count; ++i) {
            this.recordValues.add(new LegacyResolvedTransactionRecordValue(dis));
        }
    }

    public static LegacyResolvedTransactionRecord createCyclicRecord(CyclicReferenceUpdate cyclicReferenceUpdate) {
        ResolvedTransactionRecordType recordType = cyclicReferenceUpdate.isRemoveReference() ? ResolvedTransactionRecordType.REMOVE_CYCLIC_REFERENCE : ResolvedTransactionRecordType.ADD_CYCLIC_REFERENCE;
        int tableId = cyclicReferenceUpdate.getReferenceIndex().getTable().getMappingId();
        int recordId = cyclicReferenceUpdate.getRecordId();
        LegacyResolvedTransactionRecord record = new LegacyResolvedTransactionRecord(recordType, tableId, recordId);
        int columnId = cyclicReferenceUpdate.getReferenceIndex().getMappingId();
        IndexType indexType = cyclicReferenceUpdate.getReferenceIndex().getType();
        Object value = cyclicReferenceUpdate.isSingleReference() ? Integer.valueOf(cyclicReferenceUpdate.getReferencedRecordId()) : ResolvedMultiReferenceUpdate.createAddRemoveReferences(cyclicReferenceUpdate);
        record.addRecordValue(new LegacyResolvedTransactionRecordValue(columnId, indexType, value));
        return record;
    }

    public static LegacyResolvedTransactionRecord createFromRequest(TransactionRequestRecord requestRecord, int recordId) {
        ResolvedTransactionRecordType recordType = ResolvedTransactionRecordType.getByRequestType(requestRecord.getRecordType());
        return new LegacyResolvedTransactionRecord(recordType, requestRecord.getTableId(), recordId);
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeByte(this.recordType.getId());
        dos.writeInt(this.tableId);
        dos.writeInt(this.recordId);
        dos.writeInt(this.recordValues.size());
        for (LegacyResolvedTransactionRecordValue recordValue : this.recordValues) {
            recordValue.write(dos);
        }
    }

    public void addRecordValue(LegacyResolvedTransactionRecordValue recordValue) {
        this.recordValues.add(recordValue);
    }

    public ResolvedTransactionRecordType getRecordType() {
        return this.recordType;
    }

    public List<LegacyResolvedTransactionRecordValue> getRecordValues() {
        return this.recordValues;
    }

    public int getTableId() {
        return this.tableId;
    }

    public int getRecordId() {
        return this.recordId;
    }
}

