/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.commons.util.collections.ByKeyComparisonResult;
import org.teamapps.commons.util.collections.CollectionUtil;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.FieldIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.file.store.DatabaseFileStore;
import org.teamapps.universaldb.model.DatabaseModel;
import org.teamapps.universaldb.model.ReferenceFieldModel;
import org.teamapps.universaldb.model.TableModel;

public class DatabaseIndex {
    private final String name;
    private final File dataPath;
    private final File fullTextIndexPath;
    private final List<TableIndex> tables;
    private final DatabaseFileStore databaseFileStore;
    private DatabaseModel databaseModel;

    public DatabaseIndex(String name, File dataPath, File fullTextIndexPath, DatabaseFileStore databaseFileStore) {
        this.name = name;
        this.dataPath = dataPath;
        this.fullTextIndexPath = fullTextIndexPath;
        this.databaseFileStore = databaseFileStore;
        this.tables = new ArrayList<TableIndex>();
    }

    public File getDataPath() {
        return this.dataPath;
    }

    public File getFullTextIndexPath() {
        return this.fullTextIndexPath;
    }

    public DatabaseFileStore getDatabaseFileStore() {
        return this.databaseFileStore;
    }

    public void installModel(DatabaseModel model, boolean checkFullTextIndex, UniversalDB universalDB) {
        this.databaseModel = model;
        ByKeyComparisonResult compareResult = CollectionUtil.compareByKey(this.tables, this.databaseModel.getLocalTables(), TableIndex::getName, TableModel::getName, (boolean)true);
        if (!compareResult.getAEntriesNotInB().isEmpty()) {
            throw new RuntimeException("Unknown table indices that are not within the model:" + compareResult.getAEntriesNotInB().stream().map(TableIndex::getName).collect(Collectors.joining(", ")));
        }
        for (TableIndex tableIndex2 : compareResult.getAEntriesInB()) {
            TableModel tableModel = (TableModel)compareResult.getB((Object)tableIndex2);
            tableIndex2.installOrMerge(tableModel);
        }
        for (TableModel tableModel : compareResult.getBEntriesNotInA()) {
            TableIndex tableIndex3 = new TableIndex(this, tableModel);
            tableIndex3.installOrMerge(tableModel);
            this.addTable(tableIndex3);
        }
        this.tables.stream().flatMap(tableIndex -> tableIndex.getReferenceFields().stream()).forEach(index -> {
            FieldIndex reverseIndex;
            ReferenceFieldModel referenceFieldModel = index.getReferenceFieldModel();
            TableIndex referencedTable = referenceFieldModel.getReferencedTable() != null ? this.getTable(referenceFieldModel.getReferencedTable().getName()) : null;
            FieldIndex fieldIndex = reverseIndex = referenceFieldModel.getReverseReferenceField() != null ? referencedTable.getFieldIndex(referenceFieldModel.getReverseReferenceField().getName()) : null;
            if (referencedTable == null && !referenceFieldModel.getReferencedTable().isRemoteTable()) {
                throw new RuntimeException("Error missing reference table:" + index.getName() + " -> " + index.getReferenceFieldModel().getReferencedTable().getName());
            }
            index.setReferencedTable(referencedTable, reverseIndex, referenceFieldModel.isCascadeDelete());
        });
        if (checkFullTextIndex) {
            for (TableIndex tableIndex2 : this.tables) {
                if (tableIndex2.getTableModel().isVersioning()) {
                    tableIndex2.getRecordVersioningIndex().checkVersionIndex(universalDB);
                }
                tableIndex2.checkFullTextIndex();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public TableIndex addTable(TableIndex table) {
        this.tables.add(table);
        return table;
    }

    public List<TableIndex> getTables() {
        return this.tables;
    }

    public TableIndex getTable(String name) {
        return this.tables.stream().filter(table -> table.getName().equals(name)).findAny().orElse(null);
    }

    public DatabaseModel getDatabaseModel() {
        return this.databaseModel;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Database: ").append(this.name).append("\n");
        for (TableIndex table : this.tables) {
            sb.append(table.toString()).append("\n");
        }
        return sb.toString();
    }
}

