/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.filelegacy;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.AbstractIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.binary.BinaryIndex;
import org.teamapps.universaldb.index.filelegacy.FileFilter;
import org.teamapps.universaldb.index.filelegacy.FileMetaData;
import org.teamapps.universaldb.index.filelegacy.FileStore;
import org.teamapps.universaldb.index.filelegacy.FileUtil;
import org.teamapps.universaldb.index.filelegacy.FileValue;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.text.CollectionTextSearchIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.model.FieldModel;
import org.teamapps.universaldb.util.DataStreamUtil;

public class FileIndex
extends AbstractIndex<FileValue, FileFilter> {
    private final TextIndex uuidIndex = null;
    private final TextIndex hashIndex = null;
    private final LongIndex sizeIndex = null;
    private final BinaryIndex metaDataIndex = null;
    private final FullTextIndexingOptions fullTextIndexingOptions;
    private final CollectionTextSearchIndex fileDataIndex = null;
    private final FileStore fileStore;
    private final String filePath;

    public FileIndex(FieldModel fieldModel, TableIndex table, ColumnType columnType, FullTextIndexingOptions fullTextIndexingOptions, CollectionTextSearchIndex collectionSearchIndex, FileStore fileStore) {
        super(fieldModel, table);
        this.fullTextIndexingOptions = fullTextIndexingOptions;
        this.filePath = this.getFQN().replace('.', '/');
        this.fileStore = fileStore;
    }

    @Override
    public IndexType getType() {
        return IndexType.FILE;
    }

    @Override
    public FileValue getGenericValue(int id) {
        return this.getValue(id);
    }

    @Override
    public boolean isEmpty(int id) {
        return this.getValue(id) == null;
    }

    @Override
    public void setGenericValue(int id, FileValue value) {
        this.setValue(id, value);
    }

    public FileValue getValue(int id) {
        String uuid = this.uuidIndex.getValue(id);
        if (uuid != null) {
            byte[] value;
            String hash = this.hashIndex.getValue(id);
            long size = this.sizeIndex.getValue(id);
            FileValue fileValue = new FileValue(uuid, hash, size);
            if (this.fullTextIndexingOptions.isIndex() && (value = this.metaDataIndex.getValue(id)) != null) {
                try {
                    FileMetaData metaData = new FileMetaData(value);
                    fileValue.setMetaData(metaData);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Supplier<File> fileSupplier = this.fileStore.getFileSupplier(this.filePath, uuid, hash);
            fileValue.setFileSupplier(fileSupplier);
            return fileValue;
        }
        return null;
    }

    public void setValue(int id, FileValue value) {
        String uuid = this.uuidIndex.getValue(id);
        if (value == null) {
            if (uuid != null) {
                this.uuidIndex.setValue(id, null);
                this.hashIndex.setValue(id, null);
                this.sizeIndex.setValue(id, 0L);
                if (this.fileDataIndex != null) {
                    this.fileDataIndex.setRecordValues(id, Collections.emptyList(), true);
                    this.metaDataIndex.setValue(id, null);
                }
            }
        } else {
            boolean update = uuid != null;
            this.uuidIndex.setValue(id, value.getUuid());
            this.hashIndex.setValue(id, value.getHash());
            this.sizeIndex.setValue(id, value.getSize());
            if (this.fileDataIndex != null && value.getMetaData() != null) {
                this.fileDataIndex.setRecordValues(id, value.getMetaData().getFullTextIndexData(), update);
                this.metaDataIndex.setValue(id, value.getMetaData().getMetaDataBytes());
            }
        }
    }

    public FileValue storeFile(File file) {
        if (file == null) {
            return null;
        }
        return this.storeFile(file, file.getName());
    }

    public FileValue storeFile(File file, String fileName) {
        if (file == null) {
            return null;
        }
        FileValue fileValue = new FileValue(file, fileName);
        return this.storeFile(fileValue);
    }

    public FileValue storeFile(FileValue fileValue) {
        if (fileValue == null || fileValue.retrieveFile() == null) {
            return null;
        }
        if (this.fullTextIndexingOptions.isIndex()) {
            FileMetaData metaData = FileUtil.parseFileMetaData(fileValue.retrieveFile(), fileValue.getMetaData());
            fileValue.setMetaData(metaData);
        }
        this.fileStore.setFile(this.filePath, fileValue.getUuid(), fileValue.getHash(), fileValue.retrieveFile());
        fileValue.setFileSupplier(this.fileStore.getFileSupplier(this.filePath, fileValue.getUuid(), fileValue.getHash()));
        return fileValue;
    }

    public void removeStoredFile(int id) {
        String uuid = this.uuidIndex.getValue(id);
        if (uuid != null) {
            this.fileStore.removeFile(this.filePath, uuid);
        }
    }

    @Override
    public void removeValue(int id) {
        this.setValue(id, null);
    }

    @Override
    public List<SortEntry> sortRecords(List<SortEntry> sortEntries, boolean ascending, UserContext userContext) {
        return sortEntries;
    }

    @Override
    public void dumpIndex(DataOutputStream dataOutputStream, BitSet records) throws IOException {
        int id = records.nextSetBit(0);
        while (id >= 0) {
            String uuid = this.uuidIndex.getValue(id);
            if (uuid != null) {
                String hash = this.hashIndex.getValue(id);
                long size = this.sizeIndex.getValue(id);
                byte[] metaData = this.metaDataIndex.getValue(id);
                dataOutputStream.writeInt(id);
                DataStreamUtil.writeStringWithLengthHeader(dataOutputStream, uuid);
                DataStreamUtil.writeStringWithLengthHeader(dataOutputStream, hash);
                dataOutputStream.writeLong(size);
                DataStreamUtil.writeByteArrayWithLengthHeader(dataOutputStream, metaData);
            }
            id = records.nextSetBit(id + 1);
        }
    }

    @Override
    public void restoreIndex(DataInputStream dataInputStream) throws IOException {
        try {
            int id = dataInputStream.readInt();
            String uuid = DataStreamUtil.readStringWithLengthHeader(dataInputStream);
            String hash = DataStreamUtil.readStringWithLengthHeader(dataInputStream);
            long size = dataInputStream.readLong();
            byte[] metaData = DataStreamUtil.readByteArrayWithLengthHeader(dataInputStream);
            this.uuidIndex.setValue(id, uuid);
            this.hashIndex.setValue(id, hash);
            this.sizeIndex.setValue(id, size);
            this.metaDataIndex.setValue(id, metaData);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Override
    public BitSet filter(BitSet records, FileFilter fileFilter) {
        switch (fileFilter.getFilterType()) {
            case FULL_TEXT_FILTER: {
                return this.filterFullText(records, fileFilter);
            }
            case SIZE_EQUALS: {
                return this.sizeIndex.filterEquals(records, fileFilter.getSize());
            }
            case SIZE_NOT_EQUALS: {
                return this.sizeIndex.filterNotEquals(records, fileFilter.getSize());
            }
            case SIZE_GREATER: {
                return this.sizeIndex.filterGreater(records, fileFilter.getSize());
            }
            case SIZE_SMALLER: {
                return this.sizeIndex.filterSmaller(records, fileFilter.getSize());
            }
            case SIZE_BETWEEN: {
                return this.sizeIndex.filterBetween(records, fileFilter.getSize(), fileFilter.getSize2());
            }
        }
        return null;
    }

    public BitSet filterFullText(BitSet records, FileFilter fileFilter) {
        if (this.fileDataIndex != null) {
            return this.fileDataIndex.filter(records, fileFilter.getTextFilters(), false);
        }
        return new BitSet();
    }

    @Override
    public void close() {
        if (this.fileDataIndex != null) {
            this.fileDataIndex.commit(true);
        }
        this.uuidIndex.close();
        this.hashIndex.close();
        this.sizeIndex.close();
    }

    @Override
    public void drop() {
        if (this.fileDataIndex != null) {
            this.fileDataIndex.drop();
        }
        this.uuidIndex.drop();
        this.hashIndex.drop();
        this.sizeIndex.drop();
    }
}

