/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.generator;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.universaldb.model.DatabaseModel;
import org.teamapps.universaldb.model.EnumFieldModel;
import org.teamapps.universaldb.model.EnumModel;
import org.teamapps.universaldb.model.FieldModel;
import org.teamapps.universaldb.model.FieldType;
import org.teamapps.universaldb.model.FileFieldModel;
import org.teamapps.universaldb.model.ReferenceFieldModel;
import org.teamapps.universaldb.model.TableModel;
import org.teamapps.universaldb.model.ViewModel;
import org.teamapps.universaldb.pojo.template.PojoTemplate;

public class PojoCodeGenerator {
    public static final String UDB_PREFIX = "Udb";
    public static final String QUERY_SUFFIX = "Query";

    private static String tabs(int count) {
        return "\t".repeat(count);
    }

    private static String withQuotes(String value) {
        return value != null ? "\"" + value + "\"" : "null";
    }

    private static String withQuotes(List<String> values) {
        return values.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", "));
    }

    private static String withBoolean(boolean value) {
        return value ? "true" : "false";
    }

    public void generateCode(DatabaseModel databaseModel, File basePath) throws IOException {
        String namespace = databaseModel.getNamespace();
        File baseDir = this.createBaseDir(basePath, namespace);
        this.createModelProviderClass(databaseModel, baseDir);
        File dbPojoDir = new File(baseDir, databaseModel.getName().toLowerCase());
        dbPojoDir.mkdir();
        String packageName = namespace + "." + databaseModel.getName().toLowerCase();
        for (EnumModel enumModel : databaseModel.getEnums()) {
            this.createEnum(enumModel, dbPojoDir, packageName);
        }
        for (ViewModel viewModel : databaseModel.getViews()) {
        }
        for (TableModel tableModel : databaseModel.getTables()) {
            File dir = dbPojoDir;
            String classPackageName = packageName;
            List<String> remoteTableNamespaces = databaseModel.getRemoteTableNamespaces();
            if (tableModel.isRemoteTable() && tableModel.getRemoteDatabaseNamespace() != null) {
                classPackageName = tableModel.getRemoteDatabaseNamespace() + "." + tableModel.getRemoteDatabase().toLowerCase();
                dir = this.createBaseDir(basePath, classPackageName);
            }
            this.createTablePojo(tableModel, dir, classPackageName, remoteTableNamespaces);
            this.createTableQueryPojo(tableModel, dir, classPackageName, remoteTableNamespaces);
        }
    }

    public String createModelProviderClassCode(DatabaseModel model) throws IOException {
        PojoTemplate tpl = PojoTemplate.createModelProviderClass();
        this.createModelProviderClass(tpl, model);
        return tpl.writeTemplateCode();
    }

    public void createModelProviderClass(DatabaseModel model, File baseDir) throws IOException {
        PojoTemplate tpl = PojoTemplate.createModelProviderClass();
        String type = tpl.firstUpper(model.getModelClassName());
        this.createModelProviderClass(tpl, model);
        tpl.writeTemplate(type, baseDir);
    }

    public void createModelProviderClass(PojoTemplate tpl, DatabaseModel model) throws IOException {
        tpl.setValue("package", model.getNamespace());
        String type = tpl.firstUpper(model.getModelClassName());
        StringBuilder sb = new StringBuilder();
        sb.append(PojoCodeGenerator.tabs(2)).append("DatabaseModel model = new DatabaseModel(").append(PojoCodeGenerator.withQuotes(model.getName())).append(", ").append(PojoCodeGenerator.withQuotes(model.getTitle())).append(", ").append(PojoCodeGenerator.withQuotes(model.getNamespace())).append(", ").append(PojoCodeGenerator.withQuotes(model.getModelClassName())).append(");").append(tpl.nl());
        sb.append(PojoCodeGenerator.tabs(2)).append("model.setPojoBuildTime(").append(System.currentTimeMillis()).append("L);").append(tpl.nl());
        for (EnumModel enumModel : model.getEnums().stream().sorted(Comparator.comparing(EnumModel::getName)).toList()) {
            sb.append(PojoCodeGenerator.tabs(2)).append("EnumModel ").append(enumModel.getName()).append(" = ").append("model.createEnum(").append(PojoCodeGenerator.withQuotes(enumModel.getName())).append(", ").append(PojoCodeGenerator.withQuotes(enumModel.getTitle())).append(", ").append("Arrays.asList(").append(PojoCodeGenerator.withQuotes(enumModel.getEnumNames())).append("), ").append("Arrays.asList(").append(PojoCodeGenerator.withQuotes(enumModel.getEnumTitles())).append("));").append(tpl.nl());
        }
        sb.append(tpl.nl());
        for (TableModel table : model.getLocalTables().stream().sorted(Comparator.comparing(TableModel::getName)).toList()) {
            sb.append(PojoCodeGenerator.tabs(2)).append("TableModel ").append(table.getName()).append(" = ").append("model.createTable(").append(PojoCodeGenerator.withQuotes(table.getName())).append(", ").append(PojoCodeGenerator.withQuotes(table.getTitle())).append(", ").append(PojoCodeGenerator.withBoolean(table.isTrackModifications())).append(", ").append(PojoCodeGenerator.withBoolean(table.isVersioning())).append(", ").append(PojoCodeGenerator.withBoolean(table.isRecoverableRecords())).append(");").append(tpl.nl());
        }
        sb.append("\n");
        for (TableModel table : model.getRemoteTables().stream().sorted(Comparator.comparing(TableModel::getName)).toList()) {
            sb.append(PojoCodeGenerator.tabs(2)).append("TableModel ").append(table.getName()).append(" = ").append("model.createRemoteTable(").append(PojoCodeGenerator.withQuotes(table.getName())).append(", ").append(PojoCodeGenerator.withQuotes(table.getTitle())).append(", ").append(PojoCodeGenerator.withQuotes(table.getRemoteTableName())).append(", ").append(PojoCodeGenerator.withQuotes(table.getRemoteDatabase())).append(", ").append(PojoCodeGenerator.withQuotes(table.getRemoteDatabaseNamespace())).append(");").append(tpl.nl());
        }
        for (TableModel table : model.getTables().stream().sorted(Comparator.comparing(TableModel::getName)).toList()) {
            sb.append(tpl.nl());
            for (FieldModel field : table.getFields().stream().filter(f -> !f.isMetaField()).toList()) {
                sb.append(PojoCodeGenerator.tabs(2)).append(table.getName()).append(".").append(this.getAddMethodName(field.getFieldType())).append("(").append(PojoCodeGenerator.withQuotes(field.getName())).append(", ").append(PojoCodeGenerator.withQuotes(field.getTitle()));
                if (field.getFieldType().isReference()) {
                    ReferenceFieldModel referenceFieldModel = (ReferenceFieldModel)field;
                    sb.append(", ").append(referenceFieldModel.getReferencedTable().getName()).append(", ").append(PojoCodeGenerator.withBoolean(referenceFieldModel.isCascadeDelete()));
                } else if (field.getFieldType().isEnum()) {
                    EnumFieldModel enumFieldModel = (EnumFieldModel)field;
                    sb.append(", ").append(enumFieldModel.getEnumModel().getName());
                } else if (field.getFieldType().isFile()) {
                    FileFieldModel fileFieldModel = (FileFieldModel)field;
                    sb.append(", ").append(PojoCodeGenerator.withBoolean(fileFieldModel.isIndexContent())).append(", ").append(fileFieldModel.getMaxIndexContentLength()).append(", ").append(PojoCodeGenerator.withBoolean(fileFieldModel.isDetectLanguage()));
                }
                sb.append(");").append(tpl.nl());
            }
        }
        sb.append(tpl.nl());
        for (TableModel table : model.getTables().stream().sorted(Comparator.comparing(TableModel::getName)).toList()) {
            for (ReferenceFieldModel referenceField : table.getReferenceFields().stream().filter(rf -> rf.getReverseReferenceField() != null).toList()) {
                sb.append(PojoCodeGenerator.tabs(2)).append("model.addReverseReferenceField(").append(table.getName()).append(", ").append(PojoCodeGenerator.withQuotes(referenceField.getName())).append(", ").append(referenceField.getReferencedTable().getName()).append(", ").append(PojoCodeGenerator.withQuotes(referenceField.getReverseReferenceField().getName())).append(");").append(tpl.nl());
            }
        }
        tpl.setValue("type", type);
        tpl.setValue("model", sb.toString());
    }

    private String getAddMethodName(FieldType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case FieldType.BOOLEAN -> "addBoolean";
            case FieldType.SHORT -> "addShort";
            case FieldType.INT -> "addInteger";
            case FieldType.LONG -> "addLong";
            case FieldType.FLOAT -> "addFloat";
            case FieldType.DOUBLE -> "addDouble";
            case FieldType.TEXT -> "addText";
            case FieldType.TRANSLATABLE_TEXT -> "addTranslatableText";
            case FieldType.FILE -> "addFile";
            case FieldType.SINGLE_REFERENCE -> "addReference";
            case FieldType.MULTI_REFERENCE -> "addMultiReference";
            case FieldType.TIMESTAMP -> "addTimestamp";
            case FieldType.DATE -> "addDate";
            case FieldType.TIME -> "addTime";
            case FieldType.DATE_TIME -> "addDateTime";
            case FieldType.LOCAL_DATE -> "addLocalDate";
            case FieldType.ENUM -> "addEnum";
            case FieldType.BINARY -> "addByteArray";
            case FieldType.CURRENCY -> "addCurrency";
            case FieldType.DYNAMIC_CURRENCY -> "addDynamicCurrency";
        };
    }

    private void createEnum(EnumModel enumModel, File dbPojoDir, String packageName) throws IOException {
        PojoTemplate enumTpl = PojoTemplate.createEnum();
        String enumType = enumTpl.firstUpper(enumModel.getName());
        enumTpl.setValue("package", packageName);
        enumTpl.setValue("type", enumType);
        ArrayList<CallSite> enumValues = new ArrayList<CallSite>();
        for (int i = 0; i < enumModel.getEnumNames().size(); ++i) {
            String enumValue = enumModel.getEnumNames().get(i);
            String enumTitle = enumModel.getEnumTitles().get(i);
            enumValues.add((CallSite)((Object)("\t" + enumTpl.createConstantName(enumValue) + "(\"" + enumTitle + "\"),")));
        }
        enumTpl.setValue("enumValues", enumValues.stream().collect(Collectors.joining("\n")));
        enumTpl.writeTemplate(enumType, dbPojoDir);
    }

    private void createTablePojo(TableModel table, File dbPojoDir, String packageName, List<String> importNamespaces) throws IOException {
        PojoTemplate tpl = table.isRemoteTable() ? PojoTemplate.createEntityViewInterface() : PojoTemplate.createEntityInterface();
        PojoTemplate udbTpl = table.isRemoteTable() ? PojoTemplate.createUdbEntityView() : PojoTemplate.createUdbEntity();
        String type = tpl.firstUpper(table.getName());
        String udbType = UDB_PREFIX + type;
        String query = type + QUERY_SUFFIX;
        String udbQuery = UDB_PREFIX + query;
        String imports = importNamespaces.stream().map(s -> "import " + s + ".*;").collect(Collectors.joining("\n"));
        tpl.setValue("package", packageName);
        tpl.setValue("type", type);
        tpl.setValue("udbType", udbType);
        tpl.setValue("query", query);
        tpl.setValue("udbQuery", udbQuery);
        tpl.setValue("imports", imports);
        udbTpl.setValue("package", packageName);
        udbTpl.setValue("type", type);
        udbTpl.setValue("udbType", udbType);
        udbTpl.setValue("imports", imports);
        ArrayList<CallSite> staticFieldNames = new ArrayList<CallSite>();
        ArrayList<Object> staticFields = new ArrayList<Object>();
        ArrayList<CallSite> staticFieldSetters = new ArrayList<CallSite>();
        staticFields.add("\tprotected static TableIndex table;");
        staticFields.add("\tprotected static UniversalDB universalDB;");
        for (FieldModel fieldModel : table.getFields()) {
            String staticFieldName = "FIELD_" + tpl.createConstantName(fieldModel.getName());
            staticFieldNames.add((CallSite)((Object)("\tfinal static String " + staticFieldName + " = \"" + fieldModel.getName() + "\";")));
            staticFields.add("\tprotected static " + tpl.getIndexTypeName(fieldModel.getFieldType()) + " " + fieldModel.getName() + ";");
            staticFieldSetters.add((CallSite)((Object)("\t\t" + fieldModel.getName() + " = (" + tpl.getIndexTypeName(fieldModel.getFieldType()) + ") tableIndex.getFieldIndex(" + staticFieldName + ");")));
            int version = 0;
            boolean loop1 = true;
            boolean loop2 = true;
            boolean loop3 = true;
            boolean loop4 = true;
            while (loop1 || loop2 || loop3 || loop4) {
                loop1 = tpl.addInterfaceGetMethod(fieldModel, ++version);
                loop2 = !table.isRemoteTable() ? tpl.addInterfaceSetMethod(fieldModel, table, version) : false;
                loop3 = udbTpl.addUdbEntityGetMethod(fieldModel, version);
                if (!table.isRemoteTable()) {
                    loop4 = udbTpl.addUdbEntitySetMethod(fieldModel, table, version);
                    continue;
                }
                loop4 = false;
            }
        }
        tpl.setValue("staticFieldNames", staticFieldNames.stream().collect(Collectors.joining("\n")));
        udbTpl.setValue("staticFields", staticFields.stream().collect(Collectors.joining("\n")));
        udbTpl.setValue("staticFieldSetters", staticFieldSetters.stream().collect(Collectors.joining("\n")));
        tpl.writeTemplate(type, dbPojoDir);
        udbTpl.writeTemplate(udbType, dbPojoDir);
    }

    private void createTableQueryPojo(TableModel table, File dbPojoDir, String packageName, List<String> importNamespaces) throws IOException {
        PojoTemplate tpl = PojoTemplate.createQueryInterface();
        PojoTemplate udbTpl = PojoTemplate.createUdbQuery();
        String type = tpl.firstUpper(table.getName());
        String udbType = UDB_PREFIX + type;
        String query = type + QUERY_SUFFIX;
        String udbQuery = UDB_PREFIX + query;
        String imports = importNamespaces.stream().map(s -> "import " + s + ".*;").collect(Collectors.joining("\n"));
        tpl.setValue("package", packageName);
        tpl.setValue("type", type);
        tpl.setValue("udbType", udbType);
        tpl.setValue("query", query);
        tpl.setValue("udbQuery", udbQuery);
        tpl.setValue("imports", imports);
        udbTpl.setValue("package", packageName);
        udbTpl.setValue("type", type);
        udbTpl.setValue("udbType", udbType);
        udbTpl.setValue("query", query);
        udbTpl.setValue("udbQuery", udbQuery);
        udbTpl.setValue("imports", imports);
        for (FieldModel fieldModel : table.getFields()) {
            tpl.addSubQueryInterfaceMethod(fieldModel, query);
            tpl.addQueryInterfaceMethod(fieldModel, query, false);
            tpl.addQueryInterfaceMethod(fieldModel, query, true);
            udbTpl.addUdbSubQueryMethod(fieldModel, query, type);
            udbTpl.addUdbQueryMethod(fieldModel, query, type, false);
            udbTpl.addUdbQueryMethod(fieldModel, query, type, true);
        }
        tpl.writeTemplate(query, dbPojoDir);
        udbTpl.writeTemplate(udbQuery, dbPojoDir);
    }

    private File createBaseDir(File basePath, String nameSpace) {
        nameSpace = nameSpace.toLowerCase();
        String[] parts = nameSpace.split("\\.");
        basePath.mkdir();
        File path = basePath;
        for (String part : parts) {
            path = new File(path, part);
            path.mkdir();
        }
        System.out.println("name-space:" + nameSpace + ", path:" + path.getPath());
        return path;
    }
}

