/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.MappedObject;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.reference.value.ReferenceIteratorValue;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.universaldb.model.FieldModel;
import org.teamapps.universaldb.model.FieldType;
import org.teamapps.universaldb.query.IndexFilter;
import org.teamapps.universaldb.query.IndexPath;

public interface FieldIndex<TYPE, FILTER>
extends MappedObject {
    public String getName();

    public TableIndex getTable();

    public FieldType getFieldType();

    public FieldModel getFieldModel();

    @Override
    public String getFQN();

    public IndexType getType();

    @Override
    public int getMappingId();

    public TYPE getGenericValue(int var1);

    public boolean isEmpty(int var1);

    public void setGenericValue(int var1, TYPE var2);

    public void removeValue(int var1);

    default public FieldIndex getReferencedColumn() {
        return null;
    }

    default public IndexFilter<TYPE, FILTER> createFilter(FILTER filter) {
        return new IndexFilter(this, filter);
    }

    default public IndexFilter<TYPE, FILTER> createFilter(FILTER filter, IndexPath indexPath) {
        return new IndexFilter(this, filter, indexPath);
    }

    public List<SortEntry> sortRecords(List<SortEntry> var1, boolean var2, UserContext var3);

    public BitSet filter(BitSet var1, FILTER var2);

    default public String getStringValue(int id) {
        TYPE value = this.getGenericValue(id);
        if (value == null) {
            return "NULL";
        }
        switch (this.getType()) {
            case TRANSLATABLE_TEXT: {
                TranslatableText translatableText = (TranslatableText)value;
                return translatableText.getText();
            }
            case MULTI_REFERENCE: {
                ReferenceIteratorValue referenceIteratorValue = (ReferenceIteratorValue)value;
                return "(" + referenceIteratorValue.getAsList().stream().limit(100L).map(String::valueOf).collect(Collectors.joining(", ")) + ")";
            }
            case FILE: {
                FileValue fileValue = (FileValue)value;
                return fileValue.getFileName() + "( " + fileValue.getSize() + ")";
            }
            case BINARY: {
                byte[] byteValue = (byte[])value;
                return byteValue.length + " bytes";
            }
        }
        return value.toString();
    }

    default public void dumpIndex(File file, BitSet records) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file), 128000));
        this.dumpIndex(dataOutputStream, records);
        dataOutputStream.close();
    }

    public void dumpIndex(DataOutputStream var1, BitSet var2) throws IOException;

    default public void restoreIndex(File file) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file), 128000));
        this.restoreIndex(dataInputStream);
        dataInputStream.close();
    }

    public void restoreIndex(DataInputStream var1) throws IOException;

    public void close();

    public void drop();
}

