/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.buffer.index;

import java.io.File;
import java.util.BitSet;
import java.util.stream.IntStream;
import org.teamapps.universaldb.index.buffer.common.PrimitiveEntryAtomicStore;

public class BooleanAtomicMappedIndex {
    private final PrimitiveEntryAtomicStore atomicStore;

    public BooleanAtomicMappedIndex(File path, String name) {
        this.atomicStore = new PrimitiveEntryAtomicStore(path, name);
    }

    public boolean getValue(int id) {
        return this.atomicStore.getBoolean(id);
    }

    public void setValue(int id, boolean value) {
        this.atomicStore.setBoolean(id, value);
    }

    public boolean isEmpty(int id) {
        return this.getValue(id);
    }

    public int getMaximumId() {
        return this.atomicStore.getMaximumId(1) * 8;
    }

    public int getLastNonEmptyIndex() {
        int maximumId;
        for (int i = maximumId = this.getMaximumId(); i > 0; --i) {
            if (this.isEmpty(i)) continue;
            return i;
        }
        return -1;
    }

    public IntStream getIndexStream() {
        return IntStream.range(1, this.getMaximumId() + 1);
    }

    public BitSet filterEquals(boolean value, BitSet bitSet) {
        return this.filterEquals(value, bitSet.stream());
    }

    public BitSet filterEquals(boolean value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getBoolean(id) == value).forEach(result::set);
        return result;
    }

    public BitSet filterNotEquals(boolean value, BitSet bitSet) {
        return this.filterNotEquals(value, bitSet.stream());
    }

    public BitSet filterNotEquals(boolean value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getBoolean(id) != value).forEach(result::set);
        return result;
    }

    public void flush() {
        this.atomicStore.flush();
    }

    public void close() {
        this.atomicStore.close();
    }

    public void drop() {
        this.atomicStore.drop();
    }
}

