/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.message.protocol.utils.MessageUtils;
import org.teamapps.universaldb.model.NamingUtils;

public class EnumModel {
    private final String name;
    private String title;
    private List<String> enumNames;
    private List<String> enumTitles;
    private boolean deprecated;
    private boolean deleted;
    private int dateCreated;
    private int dateModified;
    private int versionCreated;
    private int versionModified;

    protected EnumModel(String title, List<String> enumTitles) {
        this(title, title, enumTitles, enumTitles);
    }

    protected EnumModel(String name, String title, List<String> enumTitles) {
        this(name, title, enumTitles, enumTitles);
    }

    protected EnumModel(String name, String title, List<String> enumNames, List<String> enumTitles) {
        this.name = NamingUtils.createName(name);
        this.title = NamingUtils.createTitle(title);
        this.enumNames = enumNames.stream().map(NamingUtils::createName).collect(Collectors.toList());
        this.enumTitles = enumTitles.stream().map(NamingUtils::createTitle).collect(Collectors.toList());
        NamingUtils.checkName(name, title);
    }

    protected EnumModel(DataInputStream dis) throws IOException {
        this.name = MessageUtils.readString((DataInputStream)dis);
        this.title = MessageUtils.readString((DataInputStream)dis);
        this.enumNames = MessageUtils.readStringList((DataInputStream)dis);
        this.enumTitles = MessageUtils.readStringList((DataInputStream)dis);
        this.deprecated = dis.readBoolean();
        this.deleted = dis.readBoolean();
        this.dateCreated = dis.readInt();
        this.dateModified = dis.readInt();
        this.versionCreated = dis.readInt();
        this.versionModified = dis.readInt();
    }

    public void write(DataOutputStream dos) throws IOException {
        MessageUtils.writeString((DataOutputStream)dos, (String)this.name);
        MessageUtils.writeString((DataOutputStream)dos, (String)this.title);
        MessageUtils.writeStringList((DataOutputStream)dos, this.enumNames);
        MessageUtils.writeStringList((DataOutputStream)dos, this.enumTitles);
        dos.writeBoolean(this.deprecated);
        dos.writeBoolean(this.deleted);
        dos.writeInt(this.dateCreated);
        dos.writeInt(this.dateModified);
        dos.writeInt(this.versionCreated);
        dos.writeInt(this.versionModified);
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    public List<String> getEnumNames() {
        return new ArrayList<String>(this.enumNames);
    }

    public List<String> getEnumTitles() {
        return new ArrayList<String>(this.enumTitles);
    }

    protected void updateValues(List<String> enumNames, List<String> enumTitles) {
        this.enumNames = enumNames;
        this.enumTitles = enumTitles;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    protected void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    protected void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public int getDateCreated() {
        return this.dateCreated;
    }

    protected void setDateCreated(int dateCreated) {
        this.dateCreated = dateCreated;
    }

    public int getDateModified() {
        return this.dateModified;
    }

    protected void setDateModified(int dateModified) {
        this.dateModified = dateModified;
    }

    public int getVersionCreated() {
        return this.versionCreated;
    }

    protected void setVersionCreated(int versionCreated) {
        this.versionCreated = versionCreated;
    }

    public int getVersionModified() {
        return this.versionModified;
    }

    protected void setVersionModified(int versionModified) {
        this.versionModified = versionModified;
    }
}

