/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.teamapps.message.protocol.utils.MessageUtils;
import org.teamapps.universaldb.model.DatabaseModel;
import org.teamapps.universaldb.model.FieldModel;
import org.teamapps.universaldb.model.NamingUtils;
import org.teamapps.universaldb.model.TableModel;

public class ViewModel {
    private final String name;
    private final String title;
    private TableModel table;
    private final List<FieldModel> fields = new ArrayList<FieldModel>();
    private boolean deprecated;
    private boolean deleted;
    private int dateCreated;
    private int dateModified;
    private int versionCreated;
    private int versionModified;

    protected ViewModel(String title, TableModel table) {
        this.name = NamingUtils.createName(title);
        this.title = NamingUtils.createTitle(title);
        this.table = table;
    }

    protected ViewModel(DataInputStream dis, List<Function<DatabaseModel, Boolean>> resolveFunctions) throws IOException {
        this.name = MessageUtils.readString((DataInputStream)dis);
        this.title = MessageUtils.readString((DataInputStream)dis);
        String tableName = MessageUtils.readString((DataInputStream)dis);
        resolveFunctions.add(databaseModel -> {
            TableModel table = databaseModel.getTable(tableName);
            this.setTable(table);
            return table != null;
        });
        this.table = null;
        this.deprecated = dis.readBoolean();
        this.deleted = dis.readBoolean();
        this.dateCreated = dis.readInt();
        this.dateModified = dis.readInt();
        this.versionCreated = dis.readInt();
        this.versionModified = dis.readInt();
        int fieldCount = dis.readInt();
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = MessageUtils.readString((DataInputStream)dis);
            resolveFunctions.add(databaseModel -> {
                FieldModel field = databaseModel.getField(tableName, fieldName);
                this.addField(field);
                return field != null;
            });
        }
    }

    public void write(DataOutputStream dos) throws IOException {
        MessageUtils.writeString((DataOutputStream)dos, (String)this.name);
        MessageUtils.writeString((DataOutputStream)dos, (String)this.title);
        MessageUtils.writeString((DataOutputStream)dos, (String)this.table.getName());
        dos.writeBoolean(this.deprecated);
        dos.writeBoolean(this.deleted);
        dos.writeInt(this.dateCreated);
        dos.writeInt(this.dateModified);
        dos.writeInt(this.versionCreated);
        dos.writeInt(this.versionModified);
        dos.writeInt(this.fields.size());
        for (FieldModel field : this.fields) {
            MessageUtils.writeString((DataOutputStream)dos, (String)field.getName());
        }
    }

    public void setTable(TableModel table) {
        this.table = table;
    }

    public ViewModel addField(FieldModel field) {
        this.fields.add(field);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public TableModel getTable() {
        return this.table;
    }

    public List<FieldModel> getFields() {
        return this.fields;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public int getDateCreated() {
        return this.dateCreated;
    }

    public int getDateModified() {
        return this.dateModified;
    }

    public int getVersionCreated() {
        return this.versionCreated;
    }

    public int getVersionModified() {
        return this.versionModified;
    }

    protected void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    protected void setDateCreated(int dateCreated) {
        this.dateCreated = dateCreated;
    }

    protected void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    protected void setDateModified(int dateModified) {
        this.dateModified = dateModified;
    }

    protected void setVersionCreated(int versionCreated) {
        this.versionCreated = versionCreated;
    }

    protected void setVersionModified(int versionModified) {
        this.versionModified = versionModified;
    }
}

