/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.teamapps.universaldb.generator.PojoCodeGenerator;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.model.DatabaseModel;
import org.teamapps.universaldb.model.EnumModel;
import org.teamapps.universaldb.model.TableModel;
import org.teamapps.universaldb.schema.Column;
import org.teamapps.universaldb.schema.Database;
import org.teamapps.universaldb.schema.Schema;
import org.teamapps.universaldb.schema.Table;

public class SchemaConverter {
    public static String convertLegacySchema(String schemaData) {
        try {
            Schema schema = Schema.parse(schemaData);
            List<DatabaseModel> models = SchemaConverter.convertSchema(schema);
            if (models.size() > 0) {
                DatabaseModel model = models.get(0);
                String classCode = new PojoCodeGenerator().createModelProviderClassCode(model);
                System.out.println(classCode);
                return classCode;
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<DatabaseModel> convertSchema(Schema schema) {
        ArrayList<DatabaseModel> models = new ArrayList<DatabaseModel>();
        String pojoNamespace = schema.getPojoNamespace();
        String schemaName = schema.getSchemaName();
        HashMap<Table, TableModel> tableModelByTable = new HashMap<Table, TableModel>();
        HashMap<TableModel, Table> tableByTableModel = new HashMap<TableModel, Table>();
        for (Database database : schema.getDatabases()) {
            TableModel tbl;
            DatabaseModel model = new DatabaseModel(database.getName(), database.getName(), pojoNamespace, schemaName);
            models.add(model);
            for (Table table : database.getAllTables()) {
                if (table.isView()) {
                    TableModel remoteTable;
                    String[] parts = table.getReferencedTablePath().split("\\.");
                    String remoteDatabaseName = parts[0];
                    String remoteTableName = parts[1];
                    if (model.getTable(remoteTableName) == null) {
                        remoteTable = model.createRemoteTable(remoteTableName, remoteTableName, remoteTableName, remoteDatabaseName, schema.getPojoNamespace());
                        tableModelByTable.put(table, remoteTable);
                        tableByTableModel.put(remoteTable, table);
                        continue;
                    }
                    remoteTable = model.createRemoteTable(table.getName(), table.getName(), remoteTableName, remoteDatabaseName, schema.getPojoNamespace());
                    tableModelByTable.put(table, remoteTable);
                    tableByTableModel.put(remoteTable, table);
                    continue;
                }
                TableModel tableModel2 = model.createTable(table.getName(), table.getName(), table.getTableConfig().trackModification(), table.getTableConfig().keepDeleted(), table.getTableConfig().keepDeleted());
                tableModelByTable.put(table, tableModel2);
                tableByTableModel.put(tableModel2, table);
            }
            for (Table table : database.getAllTables()) {
                tbl = (TableModel)tableModelByTable.get(table);
                for (Column column : table.getColumns()) {
                    if (Table.isReservedMetaName(column.getName())) continue;
                    ColumnType columnType = column.getType();
                    switch (columnType) {
                        case BOOLEAN: {
                            tbl.addBoolean(column.getName());
                            break;
                        }
                        case BITSET_BOOLEAN: {
                            break;
                        }
                        case SHORT: {
                            tbl.addShort(column.getName());
                            break;
                        }
                        case INT: {
                            tbl.addInteger(column.getName());
                            break;
                        }
                        case LONG: {
                            tbl.addLong(column.getName());
                            break;
                        }
                        case FLOAT: {
                            tbl.addFloat(column.getName());
                            break;
                        }
                        case DOUBLE: {
                            tbl.addDouble(column.getName());
                            break;
                        }
                        case TEXT: {
                            tbl.addText(column.getName());
                            break;
                        }
                        case TRANSLATABLE_TEXT: {
                            tbl.addTranslatableText(column.getName());
                            break;
                        }
                        case FILE: {
                            tbl.addFile(column.getName(), column.getName(), true, false);
                            break;
                        }
                        case SINGLE_REFERENCE: {
                            TableModel referencedTable = (TableModel)tableModelByTable.get(column.getReferencedTable());
                            if (referencedTable == null) {
                                System.out.println("Missing table:" + column.getReferencedTable().getName());
                            }
                            tbl.addReference(column.getName(), column.getName(), referencedTable, column.isCascadeDeleteReferences());
                            break;
                        }
                        case MULTI_REFERENCE: {
                            TableModel referencedTable = (TableModel)tableModelByTable.get(column.getReferencedTable());
                            if (referencedTable == null) {
                                System.out.println("Missing table:" + column.getReferencedTable().getName());
                            }
                            tbl.addMultiReference(column.getName(), column.getName(), referencedTable, column.isCascadeDeleteReferences());
                            break;
                        }
                        case TIMESTAMP: {
                            tbl.addTimestamp(column.getName());
                            break;
                        }
                        case DATE: {
                            tbl.addDate(column.getName());
                            break;
                        }
                        case TIME: {
                            tbl.addTime(column.getName());
                            break;
                        }
                        case DATE_TIME: {
                            tbl.addDateTime(column.getName());
                            break;
                        }
                        case LOCAL_DATE: {
                            tbl.addLocalDate(column.getName());
                            break;
                        }
                        case ENUM: {
                            List<String> enumValues = column.getEnumValues();
                            EnumModel enumModel = model.getEnumModel(column.getName());
                            if (enumModel == null) {
                                enumModel = model.createEnum(column.getName(), enumValues);
                            }
                            tbl.addEnum(enumModel);
                            break;
                        }
                        case BINARY: {
                            tbl.addByteArray(column.getName());
                            break;
                        }
                        case CURRENCY: {
                            break;
                        }
                    }
                }
            }
            for (Table table : database.getTables()) {
                tbl = (TableModel)tableModelByTable.get(table);
                for (Column column : table.getColumns()) {
                    if (column.getReferencedTable() == null || column.getBackReference() == null) continue;
                    Table referencedTable = column.getReferencedTable();
                    Column backReferenceColumn = referencedTable.getColumn(column.getBackReference());
                    if (backReferenceColumn.getBackReference() == null) {
                        System.out.println("Error: missing backreference old model:" + column.getFQN() + " -> " + backReferenceColumn.getFQN() + ", back-ref:" + backReferenceColumn.getBackReference());
                        continue;
                    }
                    if (!backReferenceColumn.getBackReference().equals(column.getName())) {
                        System.out.println("Error: wrong back reference name in old model:" + column.getFQN() + " -> " + backReferenceColumn.getFQN() + ", back-ref:" + backReferenceColumn.getBackReference());
                        continue;
                    }
                    if (!backReferenceColumn.getReferencedTable().getName().equals(table.getName())) {
                        System.out.println("Error: wrong back reference table in old model:" + column.getFQN() + " -> " + backReferenceColumn.getFQN() + ", back-ref:" + backReferenceColumn.getBackReference());
                        continue;
                    }
                    TableModel refTable = model.getTable(referencedTable.getName());
                    model.addReverseReferenceField(tbl, column.getName(), refTable, column.getBackReference());
                }
            }
            model.initialize(tableModel -> {
                Table table = (Table)tableByTableModel.get(tableModel);
                return table.getMappingId();
            }, (tableModel, fieldModel) -> {
                Table table = (Table)tableByTableModel.get(tableModel);
                Column column = table.getColumns().stream().filter(c -> c.getName().equalsIgnoreCase(fieldModel.getName())).findFirst().orElse(null);
                return column.getMappingId();
            });
        }
        return models;
    }
}

