/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.buffer.index;

import java.io.File;
import java.util.BitSet;
import java.util.Set;
import java.util.stream.IntStream;
import org.teamapps.universaldb.index.buffer.common.PrimitiveEntryAtomicStore;

public class LongAtomicMappedIndex {
    private final PrimitiveEntryAtomicStore atomicStore;

    public LongAtomicMappedIndex(File path, String name) {
        this.atomicStore = new PrimitiveEntryAtomicStore(path, name);
    }

    public long getValue(int id) {
        return this.atomicStore.getLong(id);
    }

    public void setValue(int id, long value) {
        this.atomicStore.setLong(id, value);
    }

    public boolean isEmpty(int id) {
        return this.getValue(id) != 0L;
    }

    public int getMaximumId() {
        return this.atomicStore.getMaximumId(8);
    }

    public int getLastNonEmptyIndex() {
        int maximumId;
        for (int i = maximumId = this.getMaximumId(); i > 0; --i) {
            if (this.isEmpty(i)) continue;
            return i;
        }
        return -1;
    }

    public IntStream getIndexStream() {
        return IntStream.range(1, this.getMaximumId() + 1);
    }

    public BitSet filterEquals(long value, BitSet bitSet) {
        return this.filterEquals(value, bitSet.stream());
    }

    public BitSet filterEquals(long value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getLong(id) == value).forEach(result::set);
        return result;
    }

    public BitSet filterNotEquals(long value, BitSet bitSet) {
        return this.filterNotEquals(value, bitSet.stream());
    }

    public BitSet filterNotEquals(long value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getLong(id) != value).forEach(result::set);
        return result;
    }

    public BitSet filterGreater(long value, BitSet bitSet) {
        return this.filterGreater(value, bitSet.stream());
    }

    public BitSet filterGreater(long value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getLong(id) > value).forEach(result::set);
        return result;
    }

    public BitSet filterSmaller(long value, BitSet bitSet) {
        return this.filterSmaller(value, bitSet.stream());
    }

    public BitSet filterSmaller(long value, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> this.atomicStore.getLong(id) < value).forEach(result::set);
        return result;
    }

    public BitSet filterBetween(long startValue, long endValue, BitSet bitSet) {
        return this.filterBetween(startValue, endValue, bitSet.stream());
    }

    public BitSet filterBetween(long startValue, long endValue, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> {
            long v = this.atomicStore.getLong(id);
            return v > startValue && v < endValue;
        }).forEach(result::set);
        return result;
    }

    public BitSet filterContains(Set<Long> valueSet, BitSet bitSet) {
        return this.filterContains(valueSet, bitSet.stream());
    }

    public BitSet filterContains(Set<Long> valueSet, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> valueSet.contains(this.atomicStore.getLong(id))).forEach(result::set);
        return result;
    }

    public BitSet filterContainsNot(Set<Long> valueSet, BitSet bitSet) {
        return this.filterContainsNot(valueSet, bitSet.stream());
    }

    public BitSet filterContainsNot(Set<Long> valueSet, IntStream idStream) {
        BitSet result = new BitSet();
        idStream.filter(id -> !valueSet.contains(this.atomicStore.getLong(id))).forEach(result::set);
        return result;
    }

    public void flush() {
        this.atomicStore.flush();
    }

    public void close() {
        this.atomicStore.close();
    }

    public void drop() {
        this.atomicStore.drop();
    }
}

