/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.file;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.teamapps.message.protocol.utils.MessageUtils;
import org.teamapps.udb.model.FileContentData;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.AbstractIndex;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.buffer.index.ByteArrayAtomicMappedIndex;
import org.teamapps.universaldb.index.buffer.index.LongAtomicMappedIndex;
import org.teamapps.universaldb.index.buffer.index.StringAtomicMappedIndex;
import org.teamapps.universaldb.index.file.FileFilter;
import org.teamapps.universaldb.index.file.FileFilterType;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.file.store.DatabaseFileStore;
import org.teamapps.universaldb.index.file.store.FileStoreUtil;
import org.teamapps.universaldb.index.file.value.CommittedLocalFile;
import org.teamapps.universaldb.index.file.value.CommittedRemoteFile;
import org.teamapps.universaldb.index.file.value.FileValueType;
import org.teamapps.universaldb.index.file.value.StoreDescriptionFile;
import org.teamapps.universaldb.index.text.CollectionTextSearchIndex;
import org.teamapps.universaldb.message.MessageStore;
import org.teamapps.universaldb.message.MessageStoreImpl;
import org.teamapps.universaldb.model.FileFieldModel;

public class FileIndex
extends AbstractIndex<FileValue, FileFilter> {
    private final StringAtomicMappedIndex nameIndex;
    private final LongAtomicMappedIndex sizeIndex;
    private final ByteArrayAtomicMappedIndex hashIndex;
    private final ByteArrayAtomicMappedIndex keyIndex;
    private final FileFieldModel fileFieldModel;
    private final DatabaseFileStore fileStore;
    private final boolean fileStoreEncrypted;
    private CollectionTextSearchIndex fullTextIndex;
    private MessageStore<FileContentData> contentDataMessageStore;

    public FileIndex(FileFieldModel fileFieldModel, TableIndex tableIndex) {
        super(fileFieldModel, tableIndex);
        this.fileFieldModel = fileFieldModel;
        this.fileStore = tableIndex.getDatabaseIndex().getDatabaseFileStore();
        this.nameIndex = new StringAtomicMappedIndex(tableIndex.getDataPath(), fileFieldModel.getName());
        this.sizeIndex = new LongAtomicMappedIndex(tableIndex.getDataPath(), fileFieldModel.getName() + "-len");
        this.hashIndex = new ByteArrayAtomicMappedIndex(tableIndex.getDataPath(), fileFieldModel.getName() + "-hash");
        this.fileStoreEncrypted = this.fileStore.isEncrypted();
        ByteArrayAtomicMappedIndex byteArrayAtomicMappedIndex = this.keyIndex = this.fileStoreEncrypted ? new ByteArrayAtomicMappedIndex(tableIndex.getDataPath(), fileFieldModel.getName() + "-hash") : null;
        if (fileFieldModel.isIndexContent()) {
            this.contentDataMessageStore = new MessageStoreImpl<FileContentData>(tableIndex.getDataPath(), fileFieldModel.getName() + "-file-meta", FileContentData.getMessageDecoder());
            this.fullTextIndex = new CollectionTextSearchIndex(tableIndex.getFullTextIndexPath(), fileFieldModel.getName());
        }
    }

    public FileFieldModel getFileFieldModel() {
        return this.fileFieldModel;
    }

    @Override
    public IndexType getType() {
        return IndexType.FILE;
    }

    @Override
    public FileValue getGenericValue(int id) {
        return this.getValue(id);
    }

    @Override
    public boolean isEmpty(int id) {
        return this.getValue(id) == null;
    }

    @Override
    public void setGenericValue(int id, FileValue value) {
        this.setValue(id, value);
    }

    public FileValue getValue(int id) {
        long size = this.sizeIndex.getValue(id);
        if (size != 0L) {
            Supplier<FileContentData> contentDataSupplier;
            String name = this.nameIndex.getValue(id);
            String hash = FileStoreUtil.bytesToHex(this.hashIndex.getValue(id));
            String key = this.fileStoreEncrypted ? FileStoreUtil.bytesToHex(this.keyIndex.getValue(id)) : null;
            File file = this.fileStore.getLocalFile(hash, size, key);
            Supplier<FileContentData> supplier = contentDataSupplier = this.fileFieldModel.isIndexContent() ? () -> this.contentDataMessageStore.getById(id) : null;
            if (file != null) {
                return new CommittedLocalFile(file, name, hash, size, contentDataSupplier);
            }
            return new CommittedRemoteFile(() -> this.fileStore.loadRemoteFile(hash, size, key), name, hash, size, contentDataSupplier);
        }
        return null;
    }

    public void setValue(int id, FileValue value) {
        boolean update;
        if (value != null && value.getType() == FileValueType.UNCOMMITTED_FILE) {
            throw new RuntimeException("Error saving uncommitted file is not possible!");
        }
        boolean bl = update = this.sizeIndex.getValue(id) != 0L;
        if (value == null || value.getSize() == 0L) {
            if (update) {
                this.sizeIndex.setValue(id, 0L);
                this.nameIndex.setValue(id, null);
                this.hashIndex.removeValue(id);
                if (this.fileFieldModel.isIndexContent()) {
                    this.fullTextIndex.setRecordValues(id, Collections.emptyList(), true);
                    this.contentDataMessageStore.delete(id);
                }
            }
        } else {
            this.sizeIndex.setValue(id, value.getSize());
            this.nameIndex.setValue(id, value.getFileName());
            this.hashIndex.setValue(id, value.getHashBytes());
            if (this.fileFieldModel.isIndexContent()) {
                FileContentData contentData = value.getFileContentData();
                contentData.setRecordId(id);
                this.fullTextIndex.setRecordValues(id, value.getFullTextIndexData(), update);
                this.contentDataMessageStore.save(contentData);
            }
        }
    }

    public FileValue storeFile(File file) {
        return file != null && file.exists() && file.length() > 0L ? this.storeFile(file, file.getName()) : null;
    }

    public FileValue storeFile(File file, String fileName) {
        FileContentData contentData;
        FileValue fileValue = FileValue.create(file, fileName);
        String key = this.fileStore.storeFile(file, fileValue.getHash(), fileValue.getSize());
        FileContentData fileContentData = contentData = this.fileFieldModel.isIndexContent() ? fileValue.getFileContentData(this.fileFieldModel.getMaxIndexContentLength()) : null;
        if (this.fileFieldModel.isIndexContent() && this.fileFieldModel.isDetectLanguage()) {
            fileValue.getDetectedLanguage();
        }
        return new StoreDescriptionFile(file, fileName, fileValue.getSize(), fileValue.getHash(), key, contentData);
    }

    @Override
    public void removeValue(int id) {
        this.setValue(id, null);
    }

    @Override
    public List<SortEntry> sortRecords(List<SortEntry> sortEntries, boolean ascending, UserContext userContext) {
        return sortEntries;
    }

    @Override
    public void dumpIndex(DataOutputStream dos, BitSet records) throws IOException {
        boolean withContent = this.fileFieldModel.isIndexContent();
        int id = records.nextSetBit(0);
        while (id >= 0) {
            long size = this.sizeIndex.getValue(id);
            if (size > 0L) {
                FileContentData contentData;
                dos.writeInt(id);
                MessageUtils.writeString((DataOutputStream)dos, (String)this.nameIndex.getValue(id));
                MessageUtils.writeByteArray((DataOutputStream)dos, (byte[])this.hashIndex.getValue(id));
                dos.writeLong(size);
                if (withContent && (contentData = this.contentDataMessageStore.getById(id)) != null) {
                    dos.writeBoolean(true);
                    MessageUtils.writeByteArray((DataOutputStream)dos, (byte[])contentData.toBytes());
                }
            }
            id = records.nextSetBit(id + 1);
        }
    }

    @Override
    public void restoreIndex(DataInputStream dis) throws IOException {
        try {
            int id = dis.readInt();
            String name = MessageUtils.readString((DataInputStream)dis);
            byte[] hash = MessageUtils.readByteArray((DataInputStream)dis);
            long size = dis.readLong();
            this.nameIndex.setValue(id, name);
            this.hashIndex.setValue(id, hash);
            this.sizeIndex.setValue(id, size);
            if (dis.readBoolean()) {
                byte[] bytes = MessageUtils.readByteArray((DataInputStream)dis);
                FileContentData contentData = new FileContentData(bytes);
                this.contentDataMessageStore.save(contentData);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Override
    public BitSet filter(BitSet records, FileFilter fileFilter) {
        return switch (fileFilter.getFilterType()) {
            default -> throw new IncompatibleClassChangeError();
            case FileFilterType.FULL_TEXT_FILTER -> this.filterFullText(records, fileFilter);
            case FileFilterType.SIZE_EQUALS -> this.sizeIndex.filterEquals(fileFilter.getSize(), records);
            case FileFilterType.SIZE_NOT_EQUALS -> this.sizeIndex.filterNotEquals(fileFilter.getSize(), records);
            case FileFilterType.SIZE_GREATER -> this.sizeIndex.filterGreater(fileFilter.getSize(), records);
            case FileFilterType.SIZE_SMALLER -> this.sizeIndex.filterSmaller(fileFilter.getSize(), records);
            case FileFilterType.SIZE_BETWEEN -> this.sizeIndex.filterBetween(fileFilter.getSize(), fileFilter.getSize2(), records);
        };
    }

    public BitSet filterFullText(BitSet records, FileFilter fileFilter) {
        if (this.fileFieldModel.isIndexContent()) {
            return this.fullTextIndex.filter(records, fileFilter.getTextFilters(), false);
        }
        return new BitSet();
    }

    @Override
    public void close() {
        if (this.fullTextIndex != null) {
            this.contentDataMessageStore.close();
            this.fullTextIndex.commit(true);
        }
        this.nameIndex.close();
        this.hashIndex.close();
        this.sizeIndex.close();
    }

    @Override
    public void drop() {
        if (this.fullTextIndex != null) {
            this.contentDataMessageStore.drop();
            this.fullTextIndex.drop();
        }
        this.nameIndex.drop();
        this.hashIndex.drop();
        this.sizeIndex.drop();
    }
}

