/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.model;

import java.util.HashMap;
import java.util.Map;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.IndexType;

public enum FieldType {
    BOOLEAN(1),
    SHORT(2),
    INT(3),
    LONG(4),
    FLOAT(5),
    DOUBLE(6),
    TEXT(7),
    TRANSLATABLE_TEXT(8),
    FILE(9),
    SINGLE_REFERENCE(10),
    MULTI_REFERENCE(11),
    TIMESTAMP(12),
    DATE(13),
    TIME(14),
    DATE_TIME(15),
    LOCAL_DATE(16),
    ENUM(17),
    BINARY(18),
    CURRENCY(19),
    DYNAMIC_CURRENCY(20);

    private final int id;
    private static final Map<Integer, FieldType> FIELD_TYPE_MAP;

    private FieldType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public boolean isReference() {
        return this == SINGLE_REFERENCE || this == MULTI_REFERENCE;
    }

    public boolean isMultiReference() {
        return this == MULTI_REFERENCE;
    }

    public boolean isEnum() {
        return this == ENUM;
    }

    public boolean isFile() {
        return this == FILE;
    }

    public boolean isDateBased() {
        return switch (this) {
            case DATE, DATE_TIME, LOCAL_DATE, TIMESTAMP -> true;
            default -> false;
        };
    }

    public ColumnType getColumnType() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case BOOLEAN -> ColumnType.BOOLEAN;
            case SHORT -> ColumnType.SHORT;
            case INT -> ColumnType.INT;
            case LONG -> ColumnType.LONG;
            case FLOAT -> ColumnType.FLOAT;
            case DOUBLE -> ColumnType.DOUBLE;
            case TEXT -> ColumnType.TEXT;
            case TRANSLATABLE_TEXT -> ColumnType.TRANSLATABLE_TEXT;
            case FILE -> ColumnType.FILE;
            case SINGLE_REFERENCE -> ColumnType.SINGLE_REFERENCE;
            case MULTI_REFERENCE -> ColumnType.MULTI_REFERENCE;
            case TIMESTAMP -> ColumnType.TIMESTAMP;
            case DATE -> ColumnType.DATE;
            case TIME -> ColumnType.TIME;
            case DATE_TIME -> ColumnType.DATE_TIME;
            case LOCAL_DATE -> ColumnType.LOCAL_DATE;
            case ENUM -> ColumnType.ENUM;
            case BINARY -> ColumnType.BINARY;
            case CURRENCY -> ColumnType.CURRENCY;
            case DYNAMIC_CURRENCY -> ColumnType.DYNAMIC_CURRENCY;
        };
    }

    public IndexType getIndexType() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case BOOLEAN -> IndexType.BOOLEAN;
            case SHORT, ENUM -> IndexType.SHORT;
            case TIMESTAMP, INT, TIME -> IndexType.INT;
            case DATE, DATE_TIME, LOCAL_DATE, LONG, CURRENCY, DYNAMIC_CURRENCY -> IndexType.LONG;
            case FLOAT -> IndexType.FLOAT;
            case DOUBLE -> IndexType.DOUBLE;
            case TEXT -> IndexType.TEXT;
            case TRANSLATABLE_TEXT -> IndexType.TRANSLATABLE_TEXT;
            case FILE -> IndexType.FILE;
            case SINGLE_REFERENCE -> IndexType.REFERENCE;
            case MULTI_REFERENCE -> IndexType.MULTI_REFERENCE;
            case BINARY -> IndexType.BINARY;
        };
    }

    public static FieldType getTypeById(int id) {
        return FIELD_TYPE_MAP.get(id);
    }

    static {
        FIELD_TYPE_MAP = new HashMap<Integer, FieldType>();
        for (FieldType fieldType : FieldType.values()) {
            FIELD_TYPE_MAP.put(fieldType.getId(), fieldType);
        }
    }
}

