/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index;

import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import org.teamapps.universaldb.index.log.RandomAccessStore;

public class IndexMetaData {
    private static final int INDEX_TYPE_POS = 0;
    private static final int CREATION_TIME_POS = 4;
    private static final int MAPPING_ID_POS = 12;
    private static final int ENCRYPTION_POS = 16;
    private static final int NONCE_POS = 20;
    private static final int COUNTER_OFFSET_POS = 36;
    private static final int FQN_POS = 100;
    private final RandomAccessStore randomAccessStore;

    public IndexMetaData(File dataPath, String name, String fqn, int indexType, int mappingId) {
        if (mappingId == 0) {
            throw new RuntimeException("Error: cannot create index without mappingId:" + name + ", " + fqn);
        }
        this.randomAccessStore = new RandomAccessStore(dataPath, name + ".mdx");
        if (this.randomAccessStore.getSize() == 0L) {
            try {
                this.randomAccessStore.writeInt(0L, indexType);
                this.randomAccessStore.writeLong(4L, System.currentTimeMillis());
                SecureRandom secureRandom = new SecureRandom();
                byte[] nonce = new byte[16];
                secureRandom.nextBytes(nonce);
                int ctrOffset = Math.abs(secureRandom.nextInt());
                if (ctrOffset > 1000000) {
                    ctrOffset /= 1000;
                }
                this.randomAccessStore.write(20L, nonce);
                this.randomAccessStore.writeInt(36L, ctrOffset);
                this.randomAccessStore.writeString(100L, fqn);
                this.randomAccessStore.writeInt(12L, mappingId);
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating index meta data", e);
            }
        } else if (this.getMappingId() != mappingId) {
            throw new RuntimeException("Wrong mapping id:" + this.getMappingId() + ", expected:" + mappingId);
        }
    }

    public int getMappingId() {
        try {
            return this.randomAccessStore.readInt(12L);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing reading meta data mapping id", e);
        }
    }

    public void setMappingId(int mappingId) {
        try {
            this.randomAccessStore.writeInt(12L, mappingId);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing index meta data mapping id", e);
        }
    }

    public int getIndexType() throws IOException {
        return this.randomAccessStore.readInt(0L);
    }

    public long getCreationTime() throws IOException {
        return this.randomAccessStore.readLong(4L);
    }

    public byte[] getNonce() {
        try {
            return this.randomAccessStore.read(20L, 16);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading index meta data", e);
        }
    }

    public int getCtrOffset() {
        try {
            return this.randomAccessStore.readInt(36L);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading index meta data", e);
        }
    }

    public String getFqn() throws IOException {
        return this.randomAccessStore.readString(100L);
    }

    public void setEncrypted(boolean encrypted) throws IOException {
        this.randomAccessStore.writeBoolean(16L, encrypted);
    }

    public boolean isEncrypted() throws IOException {
        return this.randomAccessStore.readBoolean(16L);
    }
}

