/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.numeric;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.AbstractIndex;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.buffer.common.PrimitiveEntryAtomicStore;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.index.numeric.NumericIndex;
import org.teamapps.universaldb.model.FieldModel;

public class DoubleIndex
extends AbstractIndex<Double, NumericFilter>
implements NumericIndex {
    private final PrimitiveEntryAtomicStore atomicStore;

    public DoubleIndex(FieldModel fieldModel, TableIndex tableIndex) {
        super(fieldModel, tableIndex);
        this.atomicStore = new PrimitiveEntryAtomicStore(tableIndex.getDataPath(), fieldModel.getName());
    }

    @Override
    public IndexType getType() {
        return IndexType.DOUBLE;
    }

    @Override
    public Double getGenericValue(int id) {
        return this.getValue(id);
    }

    @Override
    public boolean isEmpty(int id) {
        return this.getValue(id) == 0.0;
    }

    @Override
    public void setGenericValue(int id, Double value) {
        this.setValue(id, value);
    }

    @Override
    public void removeValue(int id) {
        this.setValue(id, 0.0);
    }

    public double getValue(int id) {
        return this.atomicStore.getDouble(id);
    }

    public void setValue(int id, double value) {
        this.atomicStore.setDouble(id, value);
    }

    @Override
    public List<SortEntry> sortRecords(List<SortEntry> sortEntries, boolean ascending, UserContext userContext) {
        int order = ascending ? 1 : -1;
        sortEntries.sort((o1, o2) -> {
            double value1 = this.getValue(o1.getLeafId());
            double value2 = this.getValue(o2.getLeafId());
            return Double.compare(value1, value2) * order;
        });
        return sortEntries;
    }

    @Override
    public void dumpIndex(DataOutputStream dataOutputStream, BitSet records) throws IOException {
        int id = records.nextSetBit(0);
        while (id >= 0) {
            double value = this.getValue(id);
            dataOutputStream.writeInt(id);
            dataOutputStream.writeDouble(value);
            id = records.nextSetBit(id + 1);
        }
    }

    @Override
    public void restoreIndex(DataInputStream dataInputStream) throws IOException {
        try {
            int id = dataInputStream.readInt();
            double value = dataInputStream.readDouble();
            this.setValue(id, value);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        this.atomicStore.close();
    }

    @Override
    public void drop() {
        this.atomicStore.drop();
    }

    @Override
    public BitSet filter(BitSet records, NumericFilter numericFilter) {
        HashSet<Double> set = new HashSet<Double>();
        if (numericFilter.getValues() != null) {
            for (Number value : numericFilter.getValues()) {
                set.add(value.doubleValue());
            }
        }
        switch (numericFilter.getFilterType()) {
            case EQUALS: {
                return this.filterEquals(records, numericFilter.getValue1().doubleValue());
            }
            case NOT_EQUALS: {
                return this.filterNotEquals(records, numericFilter.getValue1().doubleValue());
            }
            case GREATER: {
                return this.filterGreater(records, numericFilter.getValue1().doubleValue());
            }
            case GREATER_EQUALS: {
                return this.filterGreaterOrEquals(records, numericFilter.getValue1().doubleValue());
            }
            case SMALLER: {
                return this.filterSmaller(records, numericFilter.getValue1().doubleValue());
            }
            case SMALLER_EQUALS: {
                return this.filterSmallerOrEquals(records, numericFilter.getValue1().doubleValue());
            }
            case BETWEEN: {
                return this.filterBetween(records, numericFilter.getValue1().doubleValue(), numericFilter.getValue2().doubleValue());
            }
            case BETWEEN_EXCLUSIVE: {
                return this.filterBetweenExclusive(records, numericFilter.getValue1().doubleValue(), numericFilter.getValue2().doubleValue());
            }
            case CONTAINS: {
                return this.filterContains(records, set);
            }
            case CONTAINS_NOT: {
                return this.filterContainsNot(records, set);
            }
        }
        return null;
    }

    public BitSet filterEquals(BitSet bitSet, double compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            double value = this.getValue(id);
            if (value == compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterNotEquals(BitSet bitSet, double compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            double value = this.getValue(id);
            if (value != compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterGreater(BitSet bitSet, double compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            double value = this.getValue(id);
            if (value > compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterGreaterOrEquals(BitSet bitSet, double compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            double value = this.getValue(id);
            if (value >= compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterSmaller(BitSet bitSet, double compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            double value = this.getValue(id);
            if (value < compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterSmallerOrEquals(BitSet bitSet, double compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            double value = this.getValue(id);
            if (value <= compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterBetween(BitSet bitSet, double start, double end) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            double value = this.getValue(id);
            if (value >= start && value <= end) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterBetweenExclusive(BitSet bitSet, double start, double end) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            double value = this.getValue(id);
            if (value > start && value < end) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterContains(BitSet bitSet, Set<Double> set) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            double value = this.getValue(id);
            if (set.contains(value)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterContainsNot(BitSet bitSet, Set<Double> set) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            double value = this.getValue(id);
            if (!set.contains(value)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }
}

