/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.teamapps.commons.util.collections.ByKeyComparisonResult;
import org.teamapps.commons.util.collections.CollectionUtil;
import org.teamapps.message.protocol.utils.MessageUtils;
import org.teamapps.universaldb.model.EnumFieldModel;
import org.teamapps.universaldb.model.EnumModel;
import org.teamapps.universaldb.model.FieldModel;
import org.teamapps.universaldb.model.FieldType;
import org.teamapps.universaldb.model.FileFieldModel;
import org.teamapps.universaldb.model.NamingUtils;
import org.teamapps.universaldb.model.ReferenceFieldModel;
import org.teamapps.universaldb.model.TableModel;
import org.teamapps.universaldb.model.ViewModel;

public class DatabaseModel {
    private static final int DATABASE_MODEL_VERSION = 1;
    private final String name;
    private final String title;
    private final String namespace;
    private final String modelClassName;
    private final List<EnumModel> enums = new ArrayList<EnumModel>();
    private final List<TableModel> tables = new ArrayList<TableModel>();
    private final List<ViewModel> views = new ArrayList<ViewModel>();
    private long pojoBuildTime;
    private int version;
    private int dateCreated;
    private int dateModified;

    public DatabaseModel(String title) {
        this(title, title, "org.teamapps.model");
    }

    public DatabaseModel(String name, String title, String namespace) {
        this(name, title, namespace, NamingUtils.createName(name) + "Model");
    }

    public DatabaseModel(String name, String title, String namespace, String modelClassName) {
        this.name = NamingUtils.createName(name);
        this.title = NamingUtils.createTitle(title);
        this.namespace = namespace;
        this.pojoBuildTime = System.currentTimeMillis();
        this.modelClassName = NamingUtils.createName(modelClassName);
    }

    public DatabaseModel(byte[] bytes) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public DatabaseModel(DataInputStream dis) throws IOException {
        int modelVersion = dis.readInt();
        this.name = MessageUtils.readString((DataInputStream)dis);
        this.title = MessageUtils.readString((DataInputStream)dis);
        this.namespace = MessageUtils.readString((DataInputStream)dis);
        this.modelClassName = MessageUtils.readString((DataInputStream)dis);
        this.pojoBuildTime = dis.readLong();
        this.version = dis.readInt();
        this.dateCreated = dis.readInt();
        this.dateModified = dis.readInt();
        int enumCount = dis.readInt();
        for (int i = 0; i < enumCount; ++i) {
            this.enums.add(new EnumModel(dis));
        }
        int tableCount = dis.readInt();
        ArrayList<Function<DatabaseModel, Boolean>> resolveFunctions = new ArrayList<Function<DatabaseModel, Boolean>>();
        for (int i = 0; i < tableCount; ++i) {
            TableModel tableModel = new TableModel(dis, resolveFunctions, this);
            this.tables.add(tableModel);
        }
        for (Function function : resolveFunctions) {
            if (((Boolean)function.apply(this)).booleanValue()) continue;
            throw new RuntimeException("Db model mapping error");
        }
        int views = dis.readInt();
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(1);
        MessageUtils.writeString((DataOutputStream)dos, (String)this.name);
        MessageUtils.writeString((DataOutputStream)dos, (String)this.title);
        MessageUtils.writeString((DataOutputStream)dos, (String)this.namespace);
        MessageUtils.writeString((DataOutputStream)dos, (String)this.modelClassName);
        dos.writeLong(this.pojoBuildTime);
        dos.writeInt(this.version);
        dos.writeInt(this.dateCreated);
        dos.writeInt(this.dateModified);
        dos.writeInt(this.enums.size());
        for (EnumModel enumModel : this.enums) {
            enumModel.write(dos);
        }
        dos.writeInt(this.tables.size());
        for (TableModel table : this.tables) {
            table.write(dos);
        }
        dos.writeInt(this.views.size());
        for (ViewModel view : this.views) {
            view.write(dos);
        }
    }

    public void initialize() {
        int timestamp;
        if (this.version != 0) {
            return;
        }
        this.version = 1;
        this.dateCreated = timestamp = (int)(System.currentTimeMillis() / 1000L);
        AtomicInteger idGenerator = new AtomicInteger();
        for (EnumModel enumModel : this.enums) {
            enumModel.setVersionCreated(this.version);
            enumModel.setDateCreated(timestamp);
        }
        for (TableModel table : this.tables) {
            table.setTableId(idGenerator.incrementAndGet());
            table.setVersionCreated(this.version);
            table.setDateCreated(timestamp);
            for (FieldModel field : table.getFields()) {
                field.setFieldId(idGenerator.incrementAndGet());
                field.setVersionCreated(this.version);
                field.setDateCreated(timestamp);
            }
        }
        for (ViewModel view : this.views) {
            view.setVersionCreated(this.version);
            view.setDateCreated(timestamp);
        }
    }

    public void initialize(Function<TableModel, Integer> tableIdProvider, BiFunction<TableModel, FieldModel, Integer> fieldIdProvider) {
        int timestamp;
        if (this.version != 0) {
            return;
        }
        this.version = 1;
        this.dateCreated = timestamp = (int)(System.currentTimeMillis() / 1000L);
        for (EnumModel enumModel : this.enums) {
            enumModel.setVersionCreated(this.version);
            enumModel.setDateCreated(timestamp);
        }
        for (TableModel table : this.tables) {
            table.setTableId(tableIdProvider.apply(table));
            table.setVersionCreated(this.version);
            table.setDateCreated(timestamp);
            for (FieldModel field : table.getFields()) {
                field.setFieldId(fieldIdProvider.apply(table, field));
                field.setVersionCreated(this.version);
                field.setDateCreated(timestamp);
            }
        }
    }

    public void initializeWithForeignModel(DatabaseModel model) {
        if (this.version != 0) {
            return;
        }
        this.version = model.getVersion();
        this.dateCreated = model.getDateCreated();
        this.dateModified = model.getDateModified();
        for (EnumModel enumModel : this.enums) {
            EnumModel referenceModel = model.getEnumModel(enumModel.getName());
            if (referenceModel != null) {
                enumModel.setVersionCreated(referenceModel.getVersionCreated());
                enumModel.setDateCreated(referenceModel.getDateCreated());
                enumModel.setDeprecated(referenceModel.isDeprecated());
                continue;
            }
            System.out.println("Missing enum:" + enumModel.getName());
        }
        for (TableModel table : this.tables) {
            TableModel referenceTable = model.getTable(table.getName());
            if (referenceTable != null) {
                table.setTableId(referenceTable.getTableId());
                table.setVersionCreated(referenceTable.getVersionCreated());
                table.setVersionModified(referenceTable.getVersionModified());
                table.setDateModified(referenceTable.getDateModified());
                table.setDateCreated(referenceTable.getDateCreated());
                table.setDeprecated(referenceTable.isDeprecated());
                table.setDeleted(referenceTable.isDeleted());
                for (FieldModel field : table.getFields()) {
                    FieldModel referenceField = referenceTable.getField(field.getName());
                    if (referenceField != null) {
                        field.setFieldId(referenceField.getFieldId());
                        field.setVersionCreated(referenceField.getVersionCreated());
                        field.setVersionModified(referenceField.getVersionModified());
                        field.setDateModified(referenceField.getDateModified());
                        field.setDateCreated(referenceField.getDateCreated());
                        field.setDeprecated(referenceField.isDeprecated());
                        field.setDeleted(referenceField.isDeleted());
                        continue;
                    }
                    System.out.println("Missing field:" + table.getName() + "." + field.getName());
                }
                continue;
            }
            System.out.println("Missing table:" + table.getName());
        }
    }

    public void mergeModel(DatabaseModel model) {
        if (!model.isValid()) {
            throw new RuntimeException("Invalid model for merge");
        }
        if (!this.isCompatible(model)) {
            throw new RuntimeException("Incompatible model for merge");
        }
        int version = this.getVersion() + 1;
        int timestamp = (int)(System.currentTimeMillis() / 1000L);
        this.setVersion(version);
        this.setDateModified(timestamp);
        AtomicInteger idGenerator = new AtomicInteger(this.getMaxId());
        ByKeyComparisonResult enumCompare = CollectionUtil.compareByKey(this.enums, model.getEnums(), EnumModel::getName, EnumModel::getName, (boolean)true);
        for (EnumModel enumModel : enumCompare.getBEntriesInA()) {
            EnumModel existingEnum = (EnumModel)enumCompare.getA((Object)enumModel);
            if (enumModel.getEnumNames().size() <= existingEnum.getEnumNames().size()) continue;
            existingEnum.updateValues(enumModel.getEnumNames(), enumModel.getEnumTitles());
            existingEnum.setVersionModified(version);
            existingEnum.setDateModified(version);
        }
        for (EnumModel enumModel : enumCompare.getBEntriesNotInA()) {
            enumModel.setVersionCreated(version);
            enumModel.setDateCreated(timestamp);
            this.addEnum(enumModel);
        }
        for (EnumModel existingEnum : enumCompare.getAEntriesNotInB().stream().filter(e -> !e.isDeleted() && !e.isDeprecated()).toList()) {
            existingEnum.setDeprecated(true);
            existingEnum.setVersionModified(version);
            existingEnum.setDateModified(timestamp);
        }
        ByKeyComparisonResult tableCompare = CollectionUtil.compareByKey(this.getTables(), model.getTables(), TableModel::getName, TableModel::getName, (boolean)true);
        for (TableModel table : tableCompare.getBEntriesInA()) {
            TableModel existingTable = (TableModel)tableCompare.getA((Object)table);
            if (!existingTable.isRemoteTable() || existingTable.getRemoteDatabaseNamespace() == null && table.getRemoteDatabaseNamespace() != null || existingTable.getRemoteDatabaseNamespace() == null || !existingTable.getRemoteDatabaseNamespace().equals(table.getRemoteDatabaseNamespace())) {
                // empty if block
            }
            ByKeyComparisonResult fieldResult = CollectionUtil.compareByKey(existingTable.getFields(), table.getFields(), FieldModel::getName, FieldModel::getName, (boolean)true);
            for (FieldModel field : fieldResult.getBEntriesInA()) {
                boolean fieldIsUpdated = false;
                FieldModel existingField = (FieldModel)fieldResult.getA((Object)field);
                if (existingField.getTitle().equals(field.getTitle())) {
                    existingField.setTitle(field.getTitle());
                    fieldIsUpdated = true;
                }
                if (!fieldIsUpdated) continue;
                field.setVersionModified(version);
                field.setDateModified(timestamp);
            }
            for (FieldModel field : fieldResult.getBEntriesNotInA()) {
                existingTable.addFieldModel(field);
                if (field.getFieldId() != 0) continue;
                field.setFieldId(idGenerator.incrementAndGet());
                field.setVersionCreated(version);
                field.setDateCreated(timestamp);
            }
            for (FieldModel existingField : fieldResult.getAEntriesNotInB().stream().filter(f -> !f.isDeleted() && !f.isDeprecated()).toList()) {
                existingField.setDeprecated(true);
                existingField.setVersionModified(version);
                existingField.setDateModified(timestamp);
            }
        }
        for (TableModel table : tableCompare.getBEntriesNotInA()) {
            this.addTable(table);
            if (table.getTableId() == 0) {
                table.setTableId(idGenerator.incrementAndGet());
                table.setVersionCreated(version);
                table.setDateCreated(timestamp);
            }
            for (FieldModel field : table.getFields()) {
                if (field.getFieldId() != 0) continue;
                field.setFieldId(idGenerator.incrementAndGet());
                field.setVersionCreated(version);
                field.setDateCreated(timestamp);
            }
        }
        for (TableModel existingTable : tableCompare.getAEntriesNotInB().stream().filter(t -> !t.isDeleted() && !t.isDeprecated()).toList()) {
            existingTable.setDeprecated(true);
            existingTable.setVersionModified(version);
            existingTable.setDateModified(timestamp);
        }
        for (TableModel table : this.getTables()) {
            if (table.getTableId() == 0) {
                throw new RuntimeException("Error: table without id:" + table.getName());
            }
            for (FieldModel field : table.getFields()) {
                if (field.getFieldId() != 0) continue;
                System.out.println("WARNING: fields without id on sanity check - create id:" + table.getName() + ", field:" + field.getName());
                field.setFieldId(idGenerator.incrementAndGet());
                field.setVersionCreated(version);
                field.setDateCreated(timestamp);
            }
        }
    }

    public boolean isCompatible(DatabaseModel model) {
        return this.checkCompatibilityErrors(model).isEmpty();
    }

    public List<String> checkCompatibilityErrors(DatabaseModel newModel) {
        ArrayList<String> errors = new ArrayList<String>();
        if (!newModel.isValid()) {
            errors.add("Model not valid!");
        }
        if (!this.name.equals(newModel.getName())) {
            errors.add("Wrong model name: " + this.name + " vs: " + newModel.getName());
        }
        ByKeyComparisonResult enumCompare = CollectionUtil.compareByKey(this.enums, newModel.getEnums(), EnumModel::getName, EnumModel::getName, (boolean)true);
        for (EnumModel enumModel : enumCompare.getBEntriesInA()) {
            EnumModel existingEnum = (EnumModel)enumCompare.getA((Object)enumModel);
            if (existingEnum.getEnumNames().size() > enumModel.getEnumNames().size()) {
                errors.add("Wrong config for enum " + enumModel.getName() + ", size:" + existingEnum.getEnumNames().size() + "->" + enumModel.getEnumNames().size());
                continue;
            }
            for (int i = 0; i < existingEnum.getEnumNames().size(); ++i) {
                if (existingEnum.getEnumNames().get(i).equals(enumModel.getEnumNames().get(i))) continue;
                errors.add("Wrong config for enum " + enumModel.getName() + ", " + existingEnum.getEnumNames().get(i) + "->" + enumModel.getEnumNames().get(i));
            }
            if (existingEnum.isRemoteEnum() != enumModel.isRemoteEnum()) {
                errors.add("Incompatible enum locality (local vs. remote):" + existingEnum.getName());
            }
            if (existingEnum.isRemoteEnum() && !existingEnum.getRemoteDatabase().equals(enumModel.getRemoteDatabase())) {
                errors.add("Wrong database for enum " + existingEnum.getName() + ", " + existingEnum.getRemoteDatabase() + "->" + enumModel.getRemoteDatabase());
            }
            if (!existingEnum.isRemoteEnum() || existingEnum.getRemoteDatabaseNamespace().equals(enumModel.getRemoteDatabaseNamespace())) continue;
            errors.add("Wrong namespace for enum " + existingEnum.getName() + ", " + existingEnum.getRemoteDatabaseNamespace() + "->" + enumModel.getRemoteDatabaseNamespace());
        }
        for (TableModel table : newModel.getTables()) {
            TableModel existingTable = this.getTable(table.getName());
            if (existingTable == null) continue;
            if (existingTable.isVersioning() != table.isVersioning() || existingTable.isRecoverableRecords() != table.isRecoverableRecords() || existingTable.isTrackModifications() != table.isTrackModifications() || existingTable.isRemoteTable() != table.isRemoteTable() || existingTable.isRemoteTable() && !existingTable.getRemoteDatabase().equals(table.getRemoteDatabase())) {
                errors.add("Wrong config for table " + table.getName() + "." + table.getName() + ", versioning/recoverable/modifications/remoteTable: " + existingTable.isVersioning() + "/" + existingTable.isRecoverableRecords() + "/" + existingTable.isTrackModifications() + "/" + existingTable.isRemoteTable() + "->" + table.isVersioning() + "/" + table.isRecoverableRecords() + "/" + table.isTrackModifications() + "/" + table.isRemoteTable());
            }
            for (FieldModel field : table.getFields()) {
                FieldModel existingField = existingTable.getField(field.getName());
                if (existingField == null) continue;
                if (existingField.getFieldType() != field.getFieldType()) {
                    errors.add("Wrong config for field " + table.getName() + "." + field.getName() + ", type:" + String.valueOf((Object)existingField.getFieldType()) + "->" + String.valueOf((Object)field.getFieldType()));
                    continue;
                }
                if (existingField.getFieldType().isReference()) {
                    ReferenceFieldModel existingReference = (ReferenceFieldModel)existingField;
                    ReferenceFieldModel referenceField = (ReferenceFieldModel)field;
                    if (existingReference.isMultiReference() == referenceField.isMultiReference() && existingReference.isCascadeDelete() == referenceField.isCascadeDelete() && existingReference.getReferencedTable().getName().equals(referenceField.getReferencedTable().getName()) && Objects.isNull(existingReference.getReverseReferenceField()) == Objects.isNull(referenceField.getReverseReferenceField()) && (existingReference.getReverseReferenceField() == null || existingReference.getReverseReferenceField().getName().equals(referenceField.getReverseReferenceField().getName()))) continue;
                    errors.add("Wrong config for field " + table.getName() + "." + field.getName() + ", multi-ref/cascade/ref-table/ref-field: " + existingReference.isMultiReference() + "/" + existingReference.isCascadeDelete() + "/" + existingReference.getReferencedTable().getName() + "/" + this.getRefFieldPathOrNull(existingReference.getReverseReferenceField()) + "->" + referenceField.isMultiReference() + "/" + referenceField.isCascadeDelete() + "/" + referenceField.getReferencedTable().getName() + "/" + this.getRefFieldPathOrNull(referenceField.getReverseReferenceField()));
                    continue;
                }
                if (existingField.getFieldType() != FieldType.ENUM) continue;
                EnumFieldModel existingEnum = (EnumFieldModel)existingField;
                EnumFieldModel enumField = (EnumFieldModel)field;
                if (existingEnum.getEnumModel().getName().equals(enumField.getEnumModel().getName())) continue;
                errors.add("Wrong enum model for field " + field.getName());
            }
        }
        ByKeyComparisonResult viewCompare = CollectionUtil.compareByKey(this.views, newModel.getViews(), ViewModel::getName, ViewModel::getName, (boolean)true);
        for (ViewModel viewModel : viewCompare.getBEntriesInA()) {
            ViewModel existingView = (ViewModel)viewCompare.getA((Object)viewModel);
            if (existingView.getTable().getName().equals(viewModel.getTable().getName())) continue;
            errors.add("Wrong table for view " + viewModel.getName());
        }
        return errors;
    }

    private String getRefFieldPathOrNull(ReferenceFieldModel field) {
        if (field == null) {
            return "null";
        }
        return field.getTableModel().getName() + "." + field.getName();
    }

    public boolean isValid() {
        return this.checkErrors().isEmpty();
    }

    public List<String> checkErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        HashSet<String> tableNames = new HashSet<String>();
        this.enums.stream().collect(Collectors.groupingBy(f -> f.getName().toLowerCase(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).forEach(name -> errors.add("Duplicate enum name:" + name));
        this.tables.stream().collect(Collectors.groupingBy(f -> f.getName().toLowerCase(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).forEach(name -> errors.add("Duplicate table name:" + name));
        this.views.stream().collect(Collectors.groupingBy(f -> f.getName().toLowerCase(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).forEach(name -> errors.add("Duplicate view name:" + name));
        for (EnumModel enumModel : this.enums) {
            if (enumModel.getEnumNames().isEmpty() || enumModel.getEnumNames().size() != enumModel.getEnumTitles().size()) {
                errors.add("Wrong enum values:" + enumModel.getName());
            }
            if (enumModel.getEnumNames().stream().anyMatch(v -> v == null || v.strip().isBlank())) {
                errors.add("Empty enum value:" + enumModel.getName());
            }
            if (!enumModel.getEnumTitles().stream().anyMatch(v -> v == null || v.strip().isBlank())) continue;
            errors.add("Empty enum title:" + enumModel.getName());
        }
        for (TableModel table : this.tables) {
            if (tableNames.contains(table.getName().toLowerCase())) {
                errors.add("Duplicate table name:" + table.getName());
            }
            tableNames.add(table.getName().toLowerCase());
            table.getFields().stream().collect(Collectors.groupingBy(f -> f.getName().toLowerCase(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).forEach(fieldName -> errors.add("Duplicate field name '" + fieldName + "' in table " + table.getName()));
            table.getReferenceFields().stream().filter(f -> f.getReverseReferenceField() != null).filter(f -> !f.equals(f.getReverseReferenceField().getReverseReferenceField())).forEach(f -> errors.add("Wrong reverse reference field " + f.getName() + " in table " + table.getName()));
            table.getEnumFields().stream().filter(f -> this.getEnumModel(f.getEnumModel().getName()) == null).forEach(f -> errors.add("Wrong enum field " + f.getName() + " in table " + table.getName()));
        }
        for (ViewModel view : this.views) {
            if (tableNames.contains(view.getName().toLowerCase())) {
                errors.add("Duplicate table/view name:" + view.getName());
            }
            tableNames.add(view.getName().toLowerCase());
            view.getFields().stream().collect(Collectors.groupingBy(f -> f.getName().toLowerCase(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).forEach(fieldName -> errors.add("Duplicate field " + fieldName + " in view " + view.getName()));
            String tableName = view.getTable().getName();
            view.getFields().stream().filter(f -> !f.getTableModel().getName().equals(tableName)).forEach(f -> errors.add("View with field from other table, field:" + f.getName() + ", view:" + view.getName()));
        }
        return errors;
    }

    public boolean checkIds() {
        for (TableModel table : this.tables) {
            if (table.getTableId() <= 0) {
                return false;
            }
            for (FieldModel field : table.getFields()) {
                if (field.getFieldId() > 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSameModel(DatabaseModel model) {
        if (!this.name.equals(model.getName())) {
            return false;
        }
        if (!this.title.equals(model.getTitle())) {
            return false;
        }
        if (!this.namespace.equals(model.getNamespace())) {
            return false;
        }
        ByKeyComparisonResult enumCompare = CollectionUtil.compareByKey(this.enums, model.getEnums(), EnumModel::getName, EnumModel::getName, (boolean)true);
        if (enumCompare.isDifferent()) {
            return false;
        }
        for (EnumModel enumModel : enumCompare.getBEntriesInA()) {
            EnumModel existingModel = (EnumModel)enumCompare.getA((Object)enumModel);
            if (!existingModel.getName().equals(enumModel.getName())) {
                return false;
            }
            if (!existingModel.getTitle().equals(enumModel.getTitle())) {
                return false;
            }
            if (CollectionUtil.compareByKey(existingModel.getEnumNames(), enumModel.getEnumNames(), s -> s, s -> s).isDifferent()) {
                return true;
            }
            if (CollectionUtil.compareByKey(existingModel.getEnumTitles(), enumModel.getEnumTitles(), s -> s, s -> s).isDifferent()) {
                return true;
            }
            if (existingModel.isRemoteEnum() != enumModel.isRemoteEnum()) {
                return false;
            }
            if (existingModel.isRemoteEnum() && !existingModel.getRemoteDatabase().equals(enumModel.getRemoteDatabase())) {
                return false;
            }
            if (!existingModel.isRemoteEnum() || existingModel.getRemoteDatabaseNamespace().equals(enumModel.getRemoteDatabaseNamespace())) continue;
            return false;
        }
        ByKeyComparisonResult tableCompare = CollectionUtil.compareByKey(this.tables, model.getTables(), TableModel::getName, TableModel::getName, (boolean)true);
        if (tableCompare.isDifferent()) {
            return false;
        }
        for (TableModel tableModel : tableCompare.getBEntriesInA()) {
            TableModel existingModel = (TableModel)tableCompare.getA((Object)tableModel);
            if (!existingModel.getName().equals(tableModel.getName())) {
                return false;
            }
            if (!existingModel.getTitle().equals(tableModel.getTitle())) {
                return false;
            }
            if (existingModel.isRemoteTable() != tableModel.isRemoteTable()) {
                return false;
            }
            if (existingModel.getRemoteDatabaseNamespace() == null && tableModel.getRemoteDatabaseNamespace() != null) {
                return true;
            }
            if (existingModel.getRemoteDatabaseNamespace() != null && !existingModel.getRemoteDatabaseNamespace().equals(tableModel.getRemoteDatabaseNamespace())) {
                return true;
            }
            if (existingModel.isTrackModifications() != tableModel.isTrackModifications()) {
                return false;
            }
            if (existingModel.isVersioning() != tableModel.isVersioning()) {
                return false;
            }
            if (existingModel.isRecoverableRecords() != tableModel.isRecoverableRecords()) {
                return false;
            }
            if (existingModel.getRemoteDatabase() != null && !existingModel.getRemoteDatabase().equals(tableModel.getRemoteDatabase())) {
                return false;
            }
            ByKeyComparisonResult fieldCompare = CollectionUtil.compareByKey(existingModel.getFields(), tableModel.getFields(), FieldModel::getName, FieldModel::getName, (boolean)true);
            if (fieldCompare.isDifferent()) {
                return false;
            }
            for (FieldModel fieldModel : fieldCompare.getBEntriesInA()) {
                FieldModel existingField = (FieldModel)fieldCompare.getA((Object)fieldModel);
                if (!existingField.getName().equals(fieldModel.getName())) {
                    return false;
                }
                if (!existingField.getTitle().equals(fieldModel.getTitle())) {
                    return false;
                }
                if (existingField.getFieldType() != fieldModel.getFieldType()) {
                    return false;
                }
                if (fieldModel.getFieldType().isFile()) {
                    FileFieldModel fileFieldModel = (FileFieldModel)fieldModel;
                    FileFieldModel existingFileModel = (FileFieldModel)existingField;
                    if (existingFileModel.isIndexContent() != fileFieldModel.isIndexContent()) {
                        return false;
                    }
                    if (existingFileModel.isDetectLanguage() != fileFieldModel.isDetectLanguage()) {
                        return false;
                    }
                    if (existingFileModel.getMaxIndexContentLength() == fileFieldModel.getMaxIndexContentLength()) continue;
                    return false;
                }
                if (!fieldModel.getFieldType().isReference()) continue;
                ReferenceFieldModel referenceFieldModel = (ReferenceFieldModel)fieldModel;
                ReferenceFieldModel existingReferenceModel = (ReferenceFieldModel)existingField;
                if (existingReferenceModel.isMultiReference() != referenceFieldModel.isMultiReference()) {
                    return false;
                }
                if (existingReferenceModel.isCascadeDelete() != referenceFieldModel.isCascadeDelete()) {
                    return false;
                }
                if (!existingReferenceModel.getReferencedTable().getName().equals(referenceFieldModel.getReferencedTable().getName())) {
                    return false;
                }
                if (existingReferenceModel.getReverseReferenceField() == null != (referenceFieldModel.getReverseReferenceField() == null)) {
                    return false;
                }
                if (existingReferenceModel.getReverseReferenceField() == null || existingReferenceModel.getReverseReferenceField().getName().equals(referenceFieldModel.getReverseReferenceField().getName())) continue;
                return false;
            }
        }
        return true;
    }

    private int getMaxId() {
        int tableId = this.tables.stream().mapToInt(TableModel::getTableId).max().orElse(0);
        int fieldId = this.tables.stream().flatMap(t -> t.getFields().stream()).mapToInt(FieldModel::getFieldId).max().orElse(0);
        return Math.max(tableId, fieldId);
    }

    public TableModel createTable(String title) {
        return this.createTable(title, title, true, true, true);
    }

    public TableModel createTable(String name, String title) {
        return this.createTable(name, title, true, true, true);
    }

    public TableModel createTable(String name, String title, boolean trackModifications, boolean versioning, boolean recoverableRecords) {
        TableModel tableModel = new TableModel(this, name, title, false, null, null, trackModifications, versioning, recoverableRecords);
        return this.addTable(tableModel);
    }

    public TableModel createRemoteTable(String title, String databaseName) {
        return this.createRemoteTable(title, title, databaseName);
    }

    public TableModel createRemoteTable(String name, String title, String databaseName) {
        TableModel tableModel = new TableModel(this, name, title, true, databaseName, null, false, false, false);
        return this.addTable(tableModel);
    }

    public TableModel createRemoteTable(String name, String title, String databaseName, String namespace) {
        TableModel tableModel = new TableModel(this, name, title, true, databaseName, namespace, false, false, false);
        return this.addTable(tableModel);
    }

    public TableModel createRemoteTable(String name, String title, String tableName, String databaseName, String namespace) {
        TableModel tableModel = new TableModel(this, name, title, true, tableName, databaseName, namespace, false, false, false);
        return this.addTable(tableModel);
    }

    public EnumModel createEnum(String title, String ... values) {
        return this.createEnum(title, Arrays.asList(values));
    }

    public EnumModel createEnum(String title, List<String> enumTitles) {
        return this.createEnum(title, title, enumTitles, enumTitles);
    }

    public EnumModel createEnum(String name, String title, List<String> enumTitles) {
        return this.createEnum(name, title, enumTitles, enumTitles);
    }

    public EnumModel createEnum(String name, String title, List<String> enumNames, List<String> enumTitles) {
        EnumModel enumModel = new EnumModel(name, title, enumNames, enumTitles);
        return this.addEnum(enumModel);
    }

    public EnumModel createRemoteEnum(String name, String title, List<String> enumNames, List<String> enumTitles, String remoteDatabase, String remoteDatabaseNamespace) {
        EnumModel enumModel = new EnumModel(name, title, enumNames, enumTitles, true, remoteDatabase, remoteDatabaseNamespace);
        return this.addEnum(enumModel);
    }

    private EnumModel addEnum(EnumModel enumModel) {
        if (this.enums.stream().anyMatch(e -> e.getName().equalsIgnoreCase(enumModel.getName()))) {
            throw new RuntimeException("Error: enum with name " + enumModel.getName() + " already exists!");
        }
        this.enums.add(enumModel);
        return enumModel;
    }

    public EnumModel getEnumModel(String enumModelName) {
        return this.enums.stream().filter(e -> e.getName().equals(enumModelName)).findAny().orElse(null);
    }

    public List<EnumModel> getEnums() {
        return new ArrayList<EnumModel>(this.enums);
    }

    private TableModel addTable(TableModel tableModel) {
        if (this.tables.stream().anyMatch(e -> e.getName().equalsIgnoreCase(tableModel.getName()))) {
            throw new RuntimeException("Error: table with name " + tableModel.getName() + " already exists!");
        }
        this.tables.add(tableModel);
        return tableModel;
    }

    public void addReverseReferenceField(TableModel tableA, String fieldA, TableModel tableB, String fieldB) {
        ReferenceFieldModel referenceFieldA = tableA.getReferenceField(fieldA);
        ReferenceFieldModel referenceFieldB = tableB.getReferenceField(fieldB);
        if (referenceFieldA == null || referenceFieldB == null) {
            throw new RuntimeException("Error missing reference fields for model:" + fieldA + ", " + fieldB);
        }
        referenceFieldA.setReverseReferenceField(referenceFieldB);
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getModelClassName() {
        return this.modelClassName;
    }

    public String getFullNameSpace() {
        return this.getNamespace() + "." + this.getName().toLowerCase();
    }

    public List<TableModel> getTables() {
        return new ArrayList<TableModel>(this.tables);
    }

    public List<TableModel> getLocalTables() {
        return this.tables.stream().filter(t -> !t.isRemoteTable()).toList();
    }

    public List<TableModel> getRemoteTables() {
        return this.tables.stream().filter(TableModel::isRemoteTable).toList();
    }

    public List<String> getRemoteTableNamespaces() {
        return this.getRemoteTables().stream().filter(t -> t.getRemoteDatabaseNamespace() != null).map(t -> t.getRemoteDatabaseNamespace() + "." + t.getRemoteDatabase().toLowerCase()).distinct().toList();
    }

    public TableModel getTable(String name) {
        return this.tables.stream().filter(t -> t.getName().equals(name)).findAny().orElse(null);
    }

    public FieldModel getField(String tableName, String fieldName) {
        TableModel table = this.getTable(tableName);
        return table != null ? table.getField(fieldName) : null;
    }

    public ReferenceFieldModel getReferenceField(String tableName, String fieldName) {
        TableModel table = this.getTable(tableName);
        return table != null ? table.getReferenceField(fieldName) : null;
    }

    public List<ViewModel> getViews() {
        return new ArrayList<ViewModel>(this.views);
    }

    public List<TableModel> getImportedTables() {
        return this.tables.stream().filter(TableModel::isRemoteTable).toList();
    }

    public List<String> getImportedDatabases() {
        return this.getImportedTables().stream().map(TableModel::getRemoteDatabase).distinct().toList();
    }

    public int getVersion() {
        return this.version;
    }

    private void setVersion(int version) {
        this.version = version;
    }

    public int getDateCreated() {
        return this.dateCreated;
    }

    private void setDateCreated(int dateCreated) {
        this.dateCreated = dateCreated;
    }

    public int getDateModified() {
        return this.dateModified;
    }

    private void setDateModified(int dateModified) {
        this.dateModified = dateModified;
    }

    public long getPojoBuildTime() {
        return this.pojoBuildTime;
    }

    public void setPojoBuildTime(long pojoBuildTime) {
        this.pojoBuildTime = pojoBuildTime;
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.write(dos);
        dos.close();
        return bos.toByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Database model: ").append(this.name).append(", ").append(this.title).append(", ns:").append(this.namespace).append(", build:").append(this.pojoBuildTime).append(", version:").append(this.version).append("\n");
        sb.append("Tables: ").append(this.tables.size()).append("\n");
        for (TableModel table : this.tables) {
            String remoteTable = table.isRemoteTable() ? ", [REMOTE]" : "";
            sb.append("\t").append(table.getName()).append(", ").append(table.getTitle()).append(remoteTable).append(", (").append(table.getTableId()).append(")").append("\n");
            for (FieldModel field : table.getFields()) {
                sb.append("\t").append("\t").append(field.getName()).append(", ").append(field.getTitle()).append(", ").append((Object)field.getFieldType()).append(", (").append(field.getFieldId()).append(")").append("\n");
            }
        }
        return sb.toString();
    }
}

