/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.universaldb.DatabaseData;
import org.teamapps.universaldb.UniversalDB;

public class DatabaseManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final DatabaseManager BASE_INSTANCE = new DatabaseManager();
    private final Map<String, DatabaseData> databaseMap = new HashMap<String, DatabaseData>();
    private List<Consumer<UniversalDB>> managedDbHandler = new ArrayList<Consumer<UniversalDB>>();

    public static DatabaseManager getBaseInstance() {
        return BASE_INSTANCE;
    }

    public synchronized void registerDatabase(String name, UniversalDB newDb, ClassLoader classLoader) {
        LOGGER.info("Register new database: {}", (Object)name);
        this.databaseMap.put(name, new DatabaseData(newDb, classLoader));
        this.databaseMap.values().forEach(databaseData -> this.installRemoteTables(databaseData.getUniversalDB(), databaseData.getClassLoader()));
        this.managedDbHandler.forEach(handler -> handler.accept(newDb));
    }

    public synchronized void updateDatabase(String name, ClassLoader classLoader) {
        LOGGER.info("Update database: {}", (Object)name);
        DatabaseData databaseData = this.getDatabaseData(name);
        databaseData.setClassLoader(classLoader);
        UniversalDB updatedDb = databaseData.getUniversalDB();
        if (updatedDb == null || classLoader == null) {
            throw new RuntimeException("Error missing database for update:" + name);
        }
        this.databaseMap.values().forEach(dbData -> this.installRemoteTables(dbData.getUniversalDB(), dbData.getClassLoader()));
    }

    private void installRemoteTables(UniversalDB db, ClassLoader localDbClassLoader) {
        db.installAvailableRemoteTables(localDbClassLoader);
    }

    public void addDatabaseHandler(Consumer<UniversalDB> handler) {
        this.managedDbHandler.add(handler);
    }

    public synchronized UniversalDB getDatabase(String name) {
        DatabaseData databaseData = this.getDatabaseData(name);
        return databaseData != null ? databaseData.getUniversalDB() : null;
    }

    private DatabaseData getDatabaseData(String name) {
        DatabaseData databaseData = this.databaseMap.get(name);
        return databaseData;
    }

    public synchronized ClassLoader getClassLoader(UniversalDB udb) {
        return this.getClassLoader(udb.getName());
    }

    public synchronized ClassLoader getClassLoader(String name) {
        return this.databaseMap.get(name).getClassLoader();
    }

    public synchronized List<UniversalDB> getDatabases() {
        return this.databaseMap.values().stream().map(DatabaseData::getUniversalDB).toList();
    }
}

